/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game.state.load;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jmex.font2d.Font2D;
import com.jmex.font2d.Text2D;
import com.jmex.game.state.GameState;
import com.jmex.game.state.load.Loader;
import com.jmex.game.state.load.LoaderFadeOut;

public class LoadingGameState
extends GameState
implements Loader {
    protected Node rootNode;
    private Text2D statusText;
    private Quad progressBar;
    private Text2D percentageText;
    protected ColorRGBA color;
    protected AlphaState alphaState;
    private int steps;
    private int current;

    public LoadingGameState() {
        this(100);
    }

    public LoadingGameState(int n) {
        this.steps = n;
        this.current = 0;
        this.init();
    }

    protected void init() {
        this.color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        this.alphaState.setBlendEnabled(true);
        this.alphaState.setSrcFunction(4);
        this.alphaState.setDstFunction(5);
        this.alphaState.setTestEnabled(true);
        this.alphaState.setTestFunction(4);
        this.alphaState.setEnabled(true);
        this.rootNode = new Node();
        this.rootNode.setCullMode(3);
        this.rootNode.setLightCombineMode(0);
        Font2D font2D = new Font2D();
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setFunction(7);
        this.statusText = font2D.createText("Loading...", 10.0f, 0);
        this.statusText.setRenderQueueMode(4);
        this.statusText.setRenderState((RenderState)zBufferState);
        this.statusText.setTextColor(this.color);
        this.statusText.updateRenderState();
        this.rootNode.attachChild((Spatial)this.statusText);
        this.progressBar = new Quad("ProgressBar", 100.0f, 15.0f);
        this.progressBar.setRenderQueueMode(4);
        this.progressBar.setColorBuffer(0, null);
        this.progressBar.setDefaultColor(this.color);
        this.progressBar.setRenderState((RenderState)this.alphaState);
        this.progressBar.updateRenderState();
        this.rootNode.attachChild((Spatial)this.progressBar);
        this.percentageText = font2D.createText("", 10.0f, 0);
        this.percentageText.setRenderQueueMode(4);
        this.percentageText.setRenderState((RenderState)zBufferState);
        this.percentageText.setTextColor(this.color);
        this.percentageText.updateRenderState();
        this.rootNode.attachChild((Spatial)this.percentageText);
    }

    public void update(float f) {
        this.rootNode.updateGeometricState(f, true);
    }

    public void render(float f) {
        DisplaySystem.getDisplaySystem().getRenderer().draw((Spatial)this.rootNode);
    }

    public void cleanup() {
    }

    public void setProgress(float f) {
        int n = (int)(f * 100.0f);
        if (this.percentageText != null) {
            this.statusText.updateRenderState();
            this.statusText.updateModelBound();
            this.statusText.setLocalTranslation(new Vector3f((float)(DisplaySystem.getDisplaySystem().getWidth() / 2) - this.statusText.getWidth() / 2.0f, (float)(DisplaySystem.getDisplaySystem().getHeight() / 2) - this.statusText.getHeight() / 2.0f + 20.0f, 0.0f));
            this.progressBar.setLocalScale(new Vector3f(f, 1.0f, 1.0f));
            float f2 = (float)DisplaySystem.getDisplaySystem().getWidth() / 2.0f - 50.0f + (float)n / 2.0f;
            this.progressBar.setLocalTranslation(new Vector3f(f2, (float)(DisplaySystem.getDisplaySystem().getHeight() / 2), 0.0f));
            this.percentageText.setText(n + "%");
            this.percentageText.updateRenderState();
            this.percentageText.updateModelBound();
            this.percentageText.setLocalTranslation(new Vector3f((float)(DisplaySystem.getDisplaySystem().getWidth() / 2) - this.percentageText.getWidth() / 2.0f, (float)(DisplaySystem.getDisplaySystem().getHeight() / 2) - this.percentageText.getHeight() / 2.0f - 20.0f, 0.0f));
        }
        if (n == 100) {
            LoaderFadeOut loaderFadeOut = new LoaderFadeOut(2.0f, this);
            this.rootNode.addController((Controller)loaderFadeOut);
            loaderFadeOut.setActive(true);
        }
    }

    public void setProgress(float f, String string) {
        if (this.statusText != null) {
            this.statusText.setText(string);
            this.setProgress(f);
        }
    }

    protected void setAlpha(float f) {
        this.color.a = f;
    }

    public float increment() {
        return this.increment(1);
    }

    public float increment(int n) {
        this.current += n;
        float f = (float)this.current / (float)this.steps;
        this.setProgress(f);
        return f;
    }

    public float increment(String string) {
        float f = this.increment();
        this.setProgress(f, string);
        return f;
    }

    public float increment(int n, String string) {
        float f = this.increment(n);
        this.setProgress(f, string);
        return f;
    }
}

