/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jmex.terrain.TerrainBlock;
import java.io.IOException;
import java.nio.Buffer;

public class TerrainPage
extends Node {
    private static final long serialVersionUID = 1L;
    private Vector2f offset;
    private int totalSize;
    private int size;
    private Vector3f stepScale;
    private float offsetAmount;
    private short quadrant = 1;
    private static Vector3f calcVec1 = new Vector3f();

    public TerrainPage() {
    }

    public TerrainPage(String string) {
        super(string);
    }

    public TerrainPage(String string, int n, int n2, Vector3f vector3f, int[] nArray, boolean bl) {
        this(string, n, n2, vector3f, nArray, bl, n2, new Vector2f(), 0.0f);
        this.fixNormals();
    }

    protected TerrainPage(String string, int n, int n2, Vector3f vector3f, int[] nArray, boolean bl, int n3, Vector2f vector2f, float f) {
        super(string);
        if (!FastMath.isPowerOfTwo((int)(n2 - 1))) {
            throw new JmeException("size given: " + n2 + "  Terrain page sizes may only be (2^N + 1)");
        }
        this.offset = vector2f;
        this.offsetAmount = f;
        this.totalSize = n3;
        this.size = n2;
        this.stepScale = vector3f;
        this.split(n, nArray, bl);
    }

    public int getType() {
        return 65;
    }

    public void setDetailTexture(int n, int n2) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if ((this.getChild(i).getType() & 0x40) != 0) {
                ((TerrainPage)this.getChild(i)).setDetailTexture(n, n2);
                continue;
            }
            if ((this.getChild(i).getType() & 0x20) == 0) continue;
            ((TerrainBlock)this.getChild(i)).setDetailTexture(n, n2);
        }
    }

    public void setModelBound(BoundingVolume boundingVolume) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if ((this.getChild(i).getType() & 0x40) != 0) {
                ((TerrainPage)this.getChild(i)).setModelBound(boundingVolume.clone(null));
                continue;
            }
            if ((this.getChild(i).getType() & 0x20) == 0) continue;
            ((TerrainBlock)this.getChild(i)).setModelBound(boundingVolume.clone(null));
        }
    }

    public void updateModelBound() {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if ((this.getChild(i).getType() & 0x40) != 0) {
                ((TerrainPage)this.getChild(i)).updateModelBound();
                continue;
            }
            if ((this.getChild(i).getType() & 0x20) == 0) continue;
            ((TerrainBlock)this.getChild(i)).updateModelBound();
        }
    }

    public void updateFromHeightMap() {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if ((this.getChild(i).getType() & 0x40) != 0) {
                ((TerrainPage)this.getChild(i)).updateFromHeightMap();
                continue;
            }
            if ((this.getChild(i).getType() & 0x20) == 0) continue;
            ((TerrainBlock)this.getChild(i)).updateFromHeightMap();
        }
    }

    public float getHeight(Vector2f vector2f) {
        return this.getHeight(vector2f.x, vector2f.y);
    }

    public float getHeight(Vector3f vector3f) {
        return this.getHeight(vector3f.x, vector3f.z);
    }

    public float getHeight(float f, float f2) {
        Spatial spatial = null;
        int n = this.size - 1 >> 1;
        float f3 = (float)n * this.stepScale.x;
        float f4 = (float)n * this.stepScale.z;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f == 0.0f) {
            f += 0.001f;
        }
        if (f2 == 0.0f) {
            f2 += 0.001f;
        }
        if (f > 0.0f) {
            if (f2 > 0.0f) {
                spatial = this.getChild(3);
                f5 = f;
                f6 = f2;
            } else {
                spatial = this.getChild(2);
                f5 = f;
                f6 = f2 + f4;
            }
        } else if (f2 > 0.0f) {
            spatial = this.getChild(1);
            f5 = f + f3;
            f6 = f2;
        } else {
            spatial = this.getChild(0);
            if (f == 0.0f) {
                f -= 0.1f;
            }
            if (f2 == 0.0f) {
                f2 -= 0.1f;
            }
            f5 = f + f3;
            f6 = f2 + f4;
        }
        if ((spatial.getType() & 0x20) != 0) {
            return ((TerrainBlock)spatial).getHeight(f5, f6);
        }
        if ((spatial.getType() & 0x40) != 0) {
            return ((TerrainPage)spatial).getHeight(f - ((TerrainPage)spatial).getLocalTranslation().x, f2 - ((TerrainPage)spatial).getLocalTranslation().z);
        }
        return Float.NaN;
    }

    public float getHeightFromWorld(Vector3f vector3f) {
        Vector3f vector3f2 = calcVec1.set(vector3f).subtractLocal(this.localTranslation).divideLocal(this.stepScale);
        vector3f2.multLocal(this.getStepScale());
        return this.getHeight(vector3f2.x, vector3f2.z);
    }

    public Vector3f getSurfaceNormal(Vector2f vector2f, Vector3f vector3f) {
        return this.getSurfaceNormal(vector2f.x, vector2f.y, vector3f);
    }

    public Vector3f getSurfaceNormal(Vector3f vector3f, Vector3f vector3f2) {
        return this.getSurfaceNormal(vector3f.x, vector3f.z, vector3f2);
    }

    public Vector3f getSurfaceNormal(float f, float f2, Vector3f vector3f) {
        Spatial spatial = null;
        int n = this.size - 1 >> 1;
        float f3 = (float)n * this.stepScale.x;
        float f4 = (float)n * this.stepScale.z;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f == 0.0f) {
            f += 0.001f;
        }
        if (f2 == 0.0f) {
            f2 += 0.001f;
        }
        if (f > 0.0f) {
            if (f2 > 0.0f) {
                spatial = this.getChild(3);
                f5 = f;
                f6 = f2;
            } else {
                spatial = this.getChild(2);
                f5 = f;
                f6 = f2 + f4;
            }
        } else if (f2 > 0.0f) {
            spatial = this.getChild(1);
            f5 = f + f3;
            f6 = f2;
        } else {
            spatial = this.getChild(0);
            if (f == 0.0f) {
                f -= 0.1f;
            }
            if (f2 == 0.0f) {
                f2 -= 0.1f;
            }
            f5 = f + f3;
            f6 = f2 + f4;
        }
        if ((spatial.getType() & 0x20) != 0) {
            return ((TerrainBlock)spatial).getSurfaceNormal(f5, f6, vector3f);
        }
        if ((spatial.getType() & 0x40) != 0) {
            return ((TerrainPage)spatial).getSurfaceNormal(f - ((TerrainPage)spatial).getLocalTranslation().x, f2 - ((TerrainPage)spatial).getLocalTranslation().z, vector3f);
        }
        return null;
    }

    private void split(int n, int[] nArray, boolean bl) {
        if ((this.size >> 1) + 1 <= n) {
            this.createQuadBlock(nArray, bl);
        } else {
            this.createQuadPage(n, nArray, bl);
        }
    }

    private void createQuadPage(int n, int[] nArray, boolean bl) {
        int n2 = this.size >> 2;
        int n3 = this.size + 1 >> 1;
        Vector2f vector2f = new Vector2f();
        this.offsetAmount += (float)n2;
        int[] nArray2 = TerrainPage.createHeightSubBlock(nArray, 0, 0, n3);
        Vector3f vector3f = new Vector3f((float)(-n2) * this.stepScale.x, 0.0f, (float)(-n2) * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f.x;
        vector2f.y += vector3f.z;
        TerrainPage terrainPage = new TerrainPage(this.getName() + "Page1", n, n3, this.stepScale, nArray2, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainPage.setLocalTranslation(vector3f);
        terrainPage.quadrant = 1;
        this.attachChild((Spatial)terrainPage);
        int[] nArray3 = TerrainPage.createHeightSubBlock(nArray, 0, n3 - 1, n3);
        Vector3f vector3f2 = new Vector3f((float)(-n2) * this.stepScale.x, 0.0f, (float)n2 * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f2.x;
        vector2f.y += vector3f2.z;
        TerrainPage terrainPage2 = new TerrainPage(this.getName() + "Page2", n, n3, this.stepScale, nArray3, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainPage2.setLocalTranslation(vector3f2);
        terrainPage2.quadrant = (short)2;
        this.attachChild((Spatial)terrainPage2);
        int[] nArray4 = TerrainPage.createHeightSubBlock(nArray, n3 - 1, 0, n3);
        Vector3f vector3f3 = new Vector3f((float)n2 * this.stepScale.x, 0.0f, (float)(-n2) * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f3.x;
        vector2f.y += vector3f3.z;
        TerrainPage terrainPage3 = new TerrainPage(this.getName() + "Page3", n, n3, this.stepScale, nArray4, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainPage3.setLocalTranslation(vector3f3);
        terrainPage3.quadrant = (short)3;
        this.attachChild((Spatial)terrainPage3);
        int[] nArray5 = TerrainPage.createHeightSubBlock(nArray, n3 - 1, n3 - 1, n3);
        Vector3f vector3f4 = new Vector3f((float)n2 * this.stepScale.x, 0.0f, (float)n2 * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f4.x;
        vector2f.y += vector3f4.z;
        TerrainPage terrainPage4 = new TerrainPage(this.getName() + "Page4", n, n3, this.stepScale, nArray5, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainPage4.setLocalTranslation(vector3f4);
        terrainPage4.quadrant = (short)4;
        this.attachChild((Spatial)terrainPage4);
    }

    private void createQuadBlock(int[] nArray, boolean bl) {
        int n = this.size >> 2;
        int n2 = this.size >> 1;
        int n3 = this.size + 1 >> 1;
        Vector2f vector2f = new Vector2f();
        this.offsetAmount += (float)n;
        int[] nArray2 = TerrainPage.createHeightSubBlock(nArray, 0, 0, n3);
        Vector3f vector3f = new Vector3f((float)(-n2) * this.stepScale.x, 0.0f, (float)(-n2) * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f.x / 2.0f;
        vector2f.y += vector3f.z / 2.0f;
        TerrainBlock terrainBlock = new TerrainBlock(this.getName() + "Block1", n3, this.stepScale, nArray2, vector3f, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainBlock.setQuadrant((short)1);
        this.attachChild((Spatial)terrainBlock);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        int[] nArray3 = TerrainPage.createHeightSubBlock(nArray, 0, n3 - 1, n3);
        Vector3f vector3f2 = new Vector3f((float)(-n2) * this.stepScale.x, 0.0f, 0.0f);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += vector3f.x / 2.0f;
        vector2f.y += (float)n * this.stepScale.z;
        TerrainBlock terrainBlock2 = new TerrainBlock(this.getName() + "Block2", n3, this.stepScale, nArray3, vector3f2, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainBlock2.setQuadrant((short)2);
        this.attachChild((Spatial)terrainBlock2);
        terrainBlock2.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock2.updateModelBound();
        int[] nArray4 = TerrainPage.createHeightSubBlock(nArray, n3 - 1, 0, n3);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, (float)(-n2) * this.stepScale.z);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += (float)n * this.stepScale.x;
        vector2f.y += vector3f3.z / 2.0f;
        TerrainBlock terrainBlock3 = new TerrainBlock(this.getName() + "Block3", n3, this.stepScale, nArray4, vector3f3, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainBlock3.setQuadrant((short)3);
        this.attachChild((Spatial)terrainBlock3);
        terrainBlock3.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock3.updateModelBound();
        int[] nArray5 = TerrainPage.createHeightSubBlock(nArray, n3 - 1, n3 - 1, n3);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, 0.0f);
        vector2f.x = this.offset.x;
        vector2f.y = this.offset.y;
        vector2f.x += (float)n * this.stepScale.x;
        vector2f.y += (float)n * this.stepScale.z;
        TerrainBlock terrainBlock4 = new TerrainBlock(this.getName() + "Block4", n3, this.stepScale, nArray5, vector3f4, bl, this.totalSize, vector2f, this.offsetAmount);
        terrainBlock4.setQuadrant((short)4);
        this.attachChild((Spatial)terrainBlock4);
        terrainBlock4.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock4.updateModelBound();
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getSize() {
        return this.size;
    }

    public Vector3f getStepScale() {
        return this.stepScale;
    }

    public float getOffsetAmount() {
        return this.offsetAmount;
    }

    public void setOffset(Vector2f vector2f) {
        this.offset = vector2f;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setStepScale(Vector3f vector3f) {
        this.stepScale = vector3f;
    }

    public void setOffsetAmount(float f) {
        this.offsetAmount = f;
    }

    private void deleteNormalVBO(TerrainBlock terrainBlock) {
        if (terrainBlock.getVBOInfo(0) != null && terrainBlock.getVBOInfo(0).getVBOIndexID() > 0) {
            DisplaySystem.getDisplaySystem().getRenderer().deleteVBO((Buffer)terrainBlock.getNormalBuffer(0));
            terrainBlock.getVBOInfo(0).setVBONormalID(-1);
        }
    }

    public void fixNormals() {
        if (this.children != null) {
            int n = this.children.size();
            while (--n >= 0) {
                int n2;
                int n3;
                Spatial spatial = (Spatial)this.children.get(n);
                if ((spatial.getType() & 0x40) != 0) {
                    ((TerrainPage)spatial).fixNormals();
                    continue;
                }
                if ((spatial.getType() & 0x20) == 0) continue;
                TerrainBlock terrainBlock = (TerrainBlock)spatial;
                TerrainBlock terrainBlock2 = this._findRightBlock(terrainBlock);
                TerrainBlock terrainBlock3 = this._findDownBlock(terrainBlock);
                int n4 = terrainBlock.getSize();
                if (terrainBlock2 != null) {
                    float[] fArray = new float[3];
                    for (int i = 0; i < n4; ++i) {
                        n3 = (i + 1) * n4 - 1;
                        n2 = i * n4;
                        terrainBlock2.getNormalBuffer(0).position(n2 * 3);
                        terrainBlock2.getNormalBuffer(0).get(fArray);
                        terrainBlock.getNormalBuffer(0).position(n3 * 3);
                        terrainBlock.getNormalBuffer(0).put(fArray);
                    }
                    this.deleteNormalVBO(terrainBlock2);
                }
                if (terrainBlock3 != null) {
                    int n5 = (n4 - 1) * n4;
                    float[] fArray = new float[3];
                    n3 = 0;
                    while (n3 < n4) {
                        n2 = n5 + n3;
                        int n6 = n3++;
                        terrainBlock3.getNormalBuffer(0).position(n6 * 3);
                        terrainBlock3.getNormalBuffer(0).get(fArray);
                        terrainBlock.getNormalBuffer(0).position(n2 * 3);
                        terrainBlock.getNormalBuffer(0).put(fArray);
                    }
                    this.deleteNormalVBO(terrainBlock3);
                }
                this.deleteNormalVBO(terrainBlock);
            }
        }
    }

    private TerrainBlock getBlock(int n) {
        if (this.children != null) {
            int n2 = this.children.size();
            while (--n2 >= 0) {
                TerrainBlock terrainBlock;
                Spatial spatial = (Spatial)this.children.get(n2);
                if ((spatial.getType() & 0x20) == 0 || (terrainBlock = (TerrainBlock)spatial).getQuadrant() != n) continue;
                return terrainBlock;
            }
        }
        return null;
    }

    private TerrainPage getPage(int n) {
        if (this.children != null) {
            int n2 = this.children.size();
            while (--n2 >= 0) {
                TerrainPage terrainPage;
                Spatial spatial = (Spatial)this.children.get(n2);
                if ((spatial.getType() & 0x40) == 0 || (terrainPage = (TerrainPage)spatial).getQuadrant() != n) continue;
                return terrainPage;
            }
        }
        return null;
    }

    private TerrainBlock _findRightBlock(TerrainBlock terrainBlock) {
        TerrainPage terrainPage;
        if (terrainBlock.getQuadrant() == 1) {
            return this.getBlock(3);
        }
        if (terrainBlock.getQuadrant() == 2) {
            return this.getBlock(4);
        }
        if (terrainBlock.getQuadrant() == 3) {
            TerrainPage terrainPage2 = this._findRightPage();
            if (terrainPage2 != null) {
                terrainPage2.getBlock(1);
            }
        } else if (terrainBlock.getQuadrant() == 4 && (terrainPage = this._findRightPage()) != null) {
            terrainPage.getBlock(2);
        }
        return null;
    }

    private TerrainBlock _findDownBlock(TerrainBlock terrainBlock) {
        TerrainPage terrainPage;
        if (terrainBlock.getQuadrant() == 1) {
            return this.getBlock(2);
        }
        if (terrainBlock.getQuadrant() == 3) {
            return this.getBlock(4);
        }
        if (terrainBlock.getQuadrant() == 2) {
            TerrainPage terrainPage2 = this._findDownPage();
            if (terrainPage2 != null) {
                terrainPage2.getBlock(1);
            }
        } else if (terrainBlock.getQuadrant() == 4 && (terrainPage = this._findDownPage()) != null) {
            terrainPage.getBlock(3);
        }
        return null;
    }

    private TerrainPage _findRightPage() {
        TerrainPage terrainPage;
        if (this.getParent() == null || (this.getParent().getType() & 0x40) != 0) {
            return null;
        }
        TerrainPage terrainPage2 = (TerrainPage)this.getParent();
        if (this.quadrant == 1) {
            return terrainPage2.getPage(3);
        }
        if (this.quadrant == 2) {
            return terrainPage2.getPage(4);
        }
        if (this.quadrant == 3) {
            TerrainPage terrainPage3 = terrainPage2._findRightPage();
            if (terrainPage3 != null) {
                return terrainPage3.getPage(1);
            }
        } else if (this.quadrant == 4 && (terrainPage = terrainPage2._findRightPage()) != null) {
            return terrainPage.getPage(2);
        }
        return null;
    }

    private TerrainPage _findDownPage() {
        TerrainPage terrainPage;
        if (this.getParent() == null || (this.getParent().getType() & 0x40) != 0) {
            return null;
        }
        TerrainPage terrainPage2 = (TerrainPage)this.getParent();
        if (this.quadrant == 1) {
            return terrainPage2.getPage(2);
        }
        if (this.quadrant == 3) {
            return terrainPage2.getPage(4);
        }
        if (this.quadrant == 2) {
            TerrainPage terrainPage3 = terrainPage2._findDownPage();
            if (terrainPage3 != null) {
                return terrainPage3.getPage(1);
            }
        } else if (this.quadrant == 4 && (terrainPage = terrainPage2._findDownPage()) != null) {
            return terrainPage.getPage(3);
        }
        return null;
    }

    public static final int[] createHeightSubBlock(int[] nArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n3 * n3];
        int n4 = (int)FastMath.sqrt((float)nArray.length);
        int n5 = 0;
        for (int i = n2; i < n3 + n2; ++i) {
            for (int j = n; j < n3 + n; ++j) {
                if (j < n4 && i < n4) {
                    nArray2[n5] = nArray[j + i * n4];
                }
                ++n5;
            }
        }
        return nArray2;
    }

    public void setHeightMapValue(int n, int n2, int n3) {
        int n4 = this.findQuadrant(n, n2);
        int n5 = this.size + 1 >> 1;
        if (this.children != null) {
            int n6 = this.children.size();
            while (--n6 >= 0) {
                Spatial spatial = (Spatial)this.children.get(n6);
                int n7 = n;
                int n8 = n2;
                boolean bl = false;
                short s = 0;
                if ((spatial.getType() & 0x40) != 0) {
                    s = ((TerrainPage)spatial).getQuadrant();
                } else if ((spatial.getType() & 0x20) != 0) {
                    s = ((TerrainBlock)spatial).getQuadrant();
                }
                if (s == 1 && (n4 & 1) != 0) {
                    bl = true;
                } else if (s == 2 && (n4 & 2) != 0) {
                    n8 = n2 - n5 + 1;
                    bl = true;
                } else if (s == 3 && (n4 & 4) != 0) {
                    n7 = n - n5 + 1;
                    bl = true;
                } else if (s == 4 && (n4 & 8) != 0) {
                    n7 = n - n5 + 1;
                    n8 = n2 - n5 + 1;
                    bl = true;
                }
                if (!bl) continue;
                if ((spatial.getType() & 0x40) != 0) {
                    ((TerrainPage)spatial).setHeightMapValue(n7, n8, n3);
                    continue;
                }
                if ((spatial.getType() & 0x20) == 0) continue;
                ((TerrainBlock)spatial).setHeightMapValue(n7, n8, n3);
            }
        }
    }

    public void addHeightMapValue(int n, int n2, int n3) {
        int n4 = this.findQuadrant(n, n2);
        int n5 = this.size + 1 >> 1;
        if (this.children != null) {
            int n6 = this.children.size();
            while (--n6 >= 0) {
                Spatial spatial = (Spatial)this.children.get(n6);
                int n7 = n;
                int n8 = n2;
                boolean bl = false;
                short s = 0;
                if ((spatial.getType() & 0x40) != 0) {
                    s = ((TerrainPage)spatial).getQuadrant();
                } else if ((spatial.getType() & 0x20) != 0) {
                    s = ((TerrainBlock)spatial).getQuadrant();
                }
                if (s == 1 && (n4 & 1) != 0) {
                    bl = true;
                } else if (s == 2 && (n4 & 2) != 0) {
                    n8 = n2 - n5 + 1;
                    bl = true;
                } else if (s == 3 && (n4 & 4) != 0) {
                    n7 = n - n5 + 1;
                    bl = true;
                } else if (s == 4 && (n4 & 8) != 0) {
                    n7 = n - n5 + 1;
                    n8 = n2 - n5 + 1;
                    bl = true;
                }
                if (!bl) continue;
                if ((spatial.getType() & 0x40) != 0) {
                    ((TerrainPage)spatial).addHeightMapValue(n7, n8, n3);
                    continue;
                }
                if ((spatial.getType() & 0x20) == 0) continue;
                ((TerrainBlock)spatial).addHeightMapValue(n7, n8, n3);
            }
        }
    }

    public void multHeightMapValue(int n, int n2, int n3) {
        int n4 = this.findQuadrant(n, n2);
        int n5 = this.size + 1 >> 1;
        if (this.children != null) {
            int n6 = this.children.size();
            while (--n6 >= 0) {
                Spatial spatial = (Spatial)this.children.get(n6);
                int n7 = n;
                int n8 = n2;
                boolean bl = false;
                short s = 0;
                if ((spatial.getType() & 0x40) != 0) {
                    s = ((TerrainPage)spatial).getQuadrant();
                } else if ((spatial.getType() & 0x20) != 0) {
                    s = ((TerrainBlock)spatial).getQuadrant();
                }
                if (s == 1 && (n4 & 1) != 0) {
                    bl = true;
                } else if (s == 2 && (n4 & 2) != 0) {
                    n8 = n2 - n5 + 1;
                    bl = true;
                } else if (s == 3 && (n4 & 4) != 0) {
                    n7 = n - n5 + 1;
                    bl = true;
                } else if (s == 4 && (n4 & 8) != 0) {
                    n7 = n - n5 + 1;
                    n8 = n2 - n5 + 1;
                    bl = true;
                }
                if (!bl) continue;
                if ((spatial.getType() & 0x40) != 0) {
                    ((TerrainPage)spatial).multHeightMapValue(n7, n8, n3);
                    continue;
                }
                if ((spatial.getType() & 0x20) == 0) continue;
                ((TerrainBlock)spatial).multHeightMapValue(n7, n8, n3);
            }
        }
    }

    private int findQuadrant(int n, int n2) {
        int n3 = this.size + 1 >> 1;
        int n4 = 0;
        if (n < n3 && n2 < n3) {
            n4 |= 1;
        }
        if (n < n3 && n2 >= n3 - 1) {
            n4 |= 2;
        }
        if (n >= n3 - 1 && n2 < n3) {
            n4 |= 4;
        }
        if (n >= n3 - 1 && n2 >= n3 - 1) {
            n4 |= 8;
        }
        return n4;
    }

    public short getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short s) {
        this.quadrant = s;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.offset, "offset", (Savable)Vector3f.ZERO);
        outputCapsule.write(this.totalSize, "totalSize", 0);
        outputCapsule.write(this.size, "size", 0);
        outputCapsule.write((Savable)this.stepScale, "stepScale", (Savable)new Vector2f());
        outputCapsule.write(this.offsetAmount, "offsetAmount", 0.0f);
        outputCapsule.write(this.quadrant, "quadrant", (short)1);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.offset = (Vector2f)inputCapsule.readSavable("offset", (Savable)new Vector3f(Vector3f.ZERO));
        this.totalSize = inputCapsule.readInt("totalSize", 0);
        this.size = inputCapsule.readInt("size", 0);
        this.stepScale = (Vector3f)inputCapsule.readSavable("stepScale", (Savable)new Vector2f());
        this.offsetAmount = inputCapsule.readFloat("offsetAmount", 0.0f);
        this.quadrant = inputCapsule.readShort("quadrant", (short)1);
    }
}

