/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public abstract class AbstractHeightMap {
    protected int[] heightData = null;
    protected int size = 0;
    protected float heightScale = 1.0f;
    protected float filter = 0.5f;
    public static float NORMALIZE_RANGE = 255.0f;

    public void unloadHeightMap() {
        this.heightData = null;
    }

    public void setHeightScale(float f) {
        this.heightScale = f;
    }

    public void setHeightAtPoint(int n, int n2, int n3) {
        this.heightData[n2 + n3 * this.size] = n;
    }

    public void setSize(int n) {
        if (n <= 0) {
            throw new JmeException("size must be greater than zero.");
        }
        this.size = n;
    }

    public void setFilter(float f) {
        if (f < 0.0f || f >= 1.0f) {
            throw new JmeException("filter must be between 0 and 1");
        }
        this.filter = f;
    }

    public int getTrueHeightAtPoint(int n, int n2) {
        return this.heightData[n + n2 * this.size];
    }

    public float getScaledHeightAtPoint(int n, int n2) {
        return (float)this.heightData[n + n2 * this.size] * this.heightScale;
    }

    public float getInterpolatedHeight(float f, float f2) {
        float f3 = this.getScaledHeightAtPoint((int)f, (int)f2);
        if (f + 1.0f > (float)this.size) {
            return f3;
        }
        float f4 = this.getScaledHeightAtPoint((int)f + 1, (int)f2);
        float f5 = f - (float)((int)f);
        float f6 = (f4 - f3) * f5 + f3;
        if (f2 + 1.0f > (float)this.size) {
            return f3;
        }
        float f7 = this.getScaledHeightAtPoint((int)f, (int)f2 + 1);
        f5 = f2 - (float)((int)f2);
        float f8 = (f7 - f3) * f5 + f3;
        return (f6 + f8) / 2.0f;
    }

    public int[] getHeightMap() {
        return this.heightData;
    }

    public int getSize() {
        return this.size;
    }

    public boolean save(String string) {
        if (null == string) {
            throw new JmeException("Filename must not be null");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    dataOutputStream.write(this.heightData[j + i * this.size]);
                }
            }
            fileOutputStream.close();
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Error opening file " + string);
            return false;
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Error writing to file " + string);
            return false;
        }
        LoggingSystem.getLogger().log(Level.INFO, "Saved terrain to " + string);
        return true;
    }

    public void normalizeTerrain(float[][] fArray) {
        int n;
        int n2;
        float f = fArray[0][0];
        float f2 = fArray[0][0];
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                if (fArray[n2][n] > f2) {
                    f2 = fArray[n2][n];
                    continue;
                }
                if (!(fArray[n2][n] < f)) continue;
                f = fArray[n2][n];
            }
        }
        if (f2 <= f) {
            return;
        }
        float f3 = f2 - f;
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                fArray[n2][n] = (fArray[n2][n] - f) / f3 * NORMALIZE_RANGE;
            }
        }
    }

    public void erodeTerrain(float[][] fArray) {
        int n;
        float f;
        int n2;
        for (n2 = 0; n2 < this.size; ++n2) {
            f = fArray[n2][0];
            for (n = 1; n < this.size; ++n) {
                fArray[n2][n] = this.filter * f + (1.0f - this.filter) * fArray[n2][n];
                f = fArray[n2][n];
            }
        }
        for (n2 = this.size - 1; n2 >= 0; --n2) {
            f = fArray[n2][0];
            for (n = 0; n < this.size; ++n) {
                fArray[n2][n] = this.filter * f + (1.0f - this.filter) * fArray[n2][n];
                f = fArray[n2][n];
            }
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            f = fArray[0][n2];
            for (n = 0; n < this.size; ++n) {
                fArray[n][n2] = this.filter * f + (1.0f - this.filter) * fArray[n][n2];
                f = fArray[n][n2];
            }
        }
        for (n2 = this.size - 1; n2 >= 0; --n2) {
            f = fArray[0][n2];
            for (n = 0; n < this.size; ++n) {
                fArray[n][n2] = this.filter * f + (1.0f - this.filter) * fArray[n][n2];
                f = fArray[n][n2];
            }
        }
    }

    public abstract boolean load();
}

