/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jmex.terrain.util.AbstractHeightMap;
import java.util.logging.Level;

public class ParticleDepositionHeightMap
extends AbstractHeightMap {
    private int jumps;
    private int peakWalk;
    private int minParticles;
    private int maxParticles;
    private float caldera;

    public ParticleDepositionHeightMap(int n, int n2, int n3, int n4, int n5, float f) {
        if (n <= 0 || n2 < 0 || n3 < 0 || n4 > n5 || n4 < 0 || n5 < 0) {
            throw new JmeException("values must be greater than zero, and minParticles must be greater than maxParticles");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new JmeException("Caldera level must be between 0 and 1");
        }
        this.size = n;
        this.jumps = n2;
        this.peakWalk = n3;
        this.minParticles = n4;
        this.maxParticles = n5;
        this.caldera = f;
        this.load();
    }

    public boolean load() {
        int n;
        int n2;
        int[] nArray = new int[]{0, 1, 0, this.size - 1, 1, 1, this.size - 1, this.size - 1};
        int[] nArray2 = new int[]{1, 0, this.size - 1, 0, this.size - 1, 1, this.size - 1, 1};
        float[][] fArray = new float[this.size][this.size];
        int[][] nArray3 = new int[this.size][this.size];
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        for (n2 = 0; n2 < this.jumps; ++n2) {
            int n3;
            int n4;
            boolean bl;
            int n5;
            int n6;
            int n7 = (int)Math.rint(Math.random() * (double)(this.size - 1));
            int n8 = (int)Math.rint(Math.random() * (double)(this.size - 1));
            int n9 = n7;
            int n10 = n8;
            n = (int)Math.rint(Math.random() * (double)(this.maxParticles - this.minParticles) + (double)this.minParticles);
            for (int i = 0; i < n; ++i) {
                int n11;
                if (this.peakWalk != 0 && i % this.peakWalk == 0) {
                    n11 = (int)Math.rint(Math.random() * 7.0);
                    n7 = (n7 + nArray[n11] + this.size) % this.size;
                    n8 = (n8 + nArray2[n11] + this.size) % this.size;
                }
                float[] fArray2 = fArray[n7];
                int n12 = n8;
                fArray2[n12] = fArray2[n12] + 1.0f;
                n6 = n7;
                n5 = n8;
                bl = false;
                block2: while (!bl) {
                    bl = true;
                    n11 = (int)Math.rint(Math.random() * 8.0);
                    for (int j = 0; j < 8; ++j) {
                        n4 = (n6 + nArray[(j + n11) % 8]) % this.size;
                        n3 = (n5 + nArray2[(j + n11) % 8]) % this.size;
                        if (!(fArray[n4][n3] + 1.0f < fArray[n6][n5])) continue;
                        float[] fArray3 = fArray[n4];
                        int n13 = n3;
                        fArray3[n13] = fArray3[n13] + 1.0f;
                        float[] fArray4 = fArray[n6];
                        int n14 = n5;
                        fArray4[n14] = fArray4[n14] - 1.0f;
                        n6 = n4;
                        n5 = n3;
                        bl = false;
                        continue block2;
                    }
                }
                if (!(fArray[n6][n5] > fArray[n9][n10])) continue;
                n9 = n6;
                n10 = n5;
            }
            float f = fArray[n9][n10];
            float f2 = f * (1.0f - this.caldera);
            int n15 = n9;
            int n16 = n9;
            int n17 = n10;
            int n18 = n10;
            nArray3[n9][n10] = 1;
            bl = false;
            while (!bl) {
                bl = true;
                n6 = n15;
                n5 = n17;
                n4 = n16;
                n3 = n18;
                for (n7 = n6; n7 <= n4; ++n7) {
                    for (n8 = n5; n8 <= n3; ++n8) {
                        n9 = (n7 + this.size) % this.size;
                        n10 = (n8 + this.size) % this.size;
                        if (nArray3[n9][n10] != 1) continue;
                        nArray3[n9][n10] = 2;
                        if (!(fArray[n9][n10] > f2) || !(fArray[n9][n10] <= f)) continue;
                        bl = false;
                        fArray[n9][n10] = 2.0f * f2 - fArray[n9][n10];
                        if (nArray3[n9 = (n9 + 1) % this.size][n10] == 0) {
                            if (n7 + 1 > n16) {
                                n16 = n7 + 1;
                            }
                            nArray3[n9][n10] = 1;
                        }
                        if (nArray3[n9 = (n9 + this.size - 2) % this.size][n10] == 0) {
                            if (n7 - 1 < n15) {
                                n15 = n7 - 1;
                            }
                            nArray3[n9][n10] = 1;
                        }
                        if (nArray3[n9 = (n7 + this.size) % this.size][n10 = (n10 + 1) % this.size] == 0) {
                            if (n8 + 1 > n18) {
                                n18 = n8 + 1;
                            }
                            nArray3[n9][n10] = 1;
                        }
                        if (nArray3[n9][n10 = (n10 + this.size - 2) % this.size] != 0) continue;
                        if (n8 - 1 < n17) {
                            n17 = n8 - 1;
                        }
                        nArray3[n9][n10] = 1;
                    }
                }
            }
        }
        this.erodeTerrain(fArray);
        this.normalizeTerrain(fArray);
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.setHeightAtPoint((int)fArray[n2][n], n, n2);
            }
        }
        LoggingSystem.getLogger().log(Level.INFO, "Created heightmap using Particle Deposition");
        return false;
    }

    public void setJumps(int n) {
        if (n < 0) {
            throw new JmeException("jumps must be positive");
        }
        this.jumps = n;
    }

    public void setPeakWalk(int n) {
        if (n <= 0) {
            throw new JmeException("peakWalk must be greater than zero");
        }
        this.peakWalk = n;
    }

    public void setCaldera(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new JmeException("Caldera level must be between 0 and 1");
        }
        this.caldera = f;
    }

    public void setMaxParticles(int n) {
        this.maxParticles = n;
    }

    public void setMinParticles(int n) {
        if (n > this.maxParticles) {
            throw new JmeException("minParticles must be less than the current maxParticles");
        }
        this.minParticles = n;
    }
}

