/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.util.LoggingSystem;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ImageIcon;

public class ProceduralSplatTextureGenerator
extends ProceduralTextureGenerator {
    protected List splatMaps = new ArrayList();
    protected List splatTextures = new ArrayList();

    public ProceduralSplatTextureGenerator(AbstractHeightMap abstractHeightMap) {
        super(abstractHeightMap);
    }

    public void addSplatTexture(ImageIcon imageIcon, ImageIcon imageIcon2) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), null, null);
        graphics2D.dispose();
        this.splatMaps.add(bufferedImage);
        bufferedImage = new BufferedImage(imageIcon2.getIconWidth(), imageIcon2.getIconHeight(), 1);
        graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon2.getImage(), null, null);
        graphics2D.dispose();
        this.splatTextures.add(bufferedImage);
    }

    public void createTexture(int n) {
        super.createTexture(n);
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        int n2 = this.splatTextures.size();
        bufferedImage.getGraphics().drawImage(this.proceduralTexture.getImage(), 0, 0, null);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = bufferedImage.getRGB(i, j);
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                for (int k = 0; k < n2; ++k) {
                    BufferedImage bufferedImage2 = (BufferedImage)this.splatMaps.get(k);
                    BufferedImage bufferedImage3 = (BufferedImage)this.splatTextures.get(k);
                    int n7 = (int)((float)i * ((float)bufferedImage2.getWidth() / (float)n));
                    int n8 = (int)((float)bufferedImage2.getHeight() - ((float)j * ((float)bufferedImage2.getHeight() / (float)n) + 1.0f));
                    float f = (float)(bufferedImage2.getRGB(n7, n8) >> 24 & 0xFF) / 255.0f;
                    n7 = i % bufferedImage3.getWidth();
                    n8 = j % bufferedImage3.getHeight();
                    if (!(f > 0.0f)) continue;
                    n4 = (int)((float)n4 * (1.0f - f) + (float)((bufferedImage3.getRGB(n7, n8) & 0xFF0000) >> 16) * f);
                    n5 = (int)((float)n5 * (1.0f - f) + (float)((bufferedImage3.getRGB(n7, n8) & 0xFF00) >> 8) * f);
                    n6 = (int)((float)n6 * (1.0f - f) + (float)(bufferedImage3.getRGB(n7, n8) & 0xFF) * f);
                }
                n3 = n4 << 16 | n5 << 8 | n6;
                bufferedImage.setRGB(i, j, n3);
                n4 = 0;
                n5 = 0;
                n6 = 0;
            }
        }
        this.proceduralTexture = new ImageIcon(bufferedImage);
        this.proceduralTexture.setDescription("TerrainTexture");
        LoggingSystem.getLogger().log(Level.FINE, "Created splat texture successfully.");
    }

    public int getSplatSize() {
        return this.splatMaps.size();
    }

    public BufferedImage getSplatMap(int n) {
        return (BufferedImage)this.splatMaps.get(n);
    }

    public BufferedImage getSplatTexture(int n) {
        return (BufferedImage)this.splatTextures.get(n);
    }
}

