/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.math.FastMath;
import com.jme.system.JmeException;
import com.jme.util.LittleEndien;
import com.jme.util.LoggingSystem;
import com.jmex.terrain.util.AbstractHeightMap;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class RawHeightMap
extends AbstractHeightMap {
    public static final int FORMAT_8BIT = 0;
    public static final int FORMAT_16BITLE = 1;
    public static final int FORMAT_16BITBE = 2;
    private String filename;
    private int format;
    private boolean swapxy;

    public RawHeightMap(String string, int n) {
        this(string, n, 0, false);
    }

    public RawHeightMap(int[] nArray) {
        this.heightData = nArray;
        this.size = (int)FastMath.sqrt((float)nArray.length);
    }

    public RawHeightMap(String string, int n, int n2, boolean bl) {
        if (null == string || n <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        if (!string.endsWith(".raw")) {
            throw new JmeException("Height data must be RAW format");
        }
        this.filename = string;
        this.size = n;
        this.format = n2;
        this.swapxy = bl;
        this.load();
    }

    public boolean load() {
        if (null == this.filename || this.size <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
            int n = this.format == 1 || this.format == 2 ? 2 : 1;
            if (this.format == 1) {
                LittleEndien littleEndien = new LittleEndien((InputStream)fileInputStream);
                if (this.heightData.length != littleEndien.available() / n) {
                    LoggingSystem.getLogger().log(Level.WARNING, "Incorrect map size. Aborting raw load.");
                }
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int n2 = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[n2] = littleEndien.readUnsignedShort();
                    }
                }
                littleEndien.close();
            } else {
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                if (this.heightData.length != dataInputStream.available() / n) {
                    LoggingSystem.getLogger().log(Level.WARNING, "Incorrect map size. Aborting raw load.");
                }
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int n3 = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[n3] = this.format == 2 ? (int)dataInputStream.readShort() : dataInputStream.readUnsignedByte();
                    }
                }
                dataInputStream.close();
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Heightmap file" + this.filename + " not found.");
            return false;
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Error reading data from " + this.filename);
            return false;
        }
        LoggingSystem.getLogger().log(Level.WARNING, "Successfully loaded " + this.filename);
        return true;
    }

    public void setFilename(String string) {
        if (null == string) {
            throw new JmeException("Must supply valid filename");
        }
        if (null == string || this.size <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        this.filename = string;
    }
}

