/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game.state;

import com.jmex.game.state.GameState;
import java.util.ArrayList;

public class GameStateNode
extends GameState {
    protected ArrayList<GameState> children;

    public GameStateNode(String string) {
        this.name = string;
        this.children = new ArrayList();
    }

    public void update(float f) {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = this.children.get(i);
            if (!gameState.isActive()) continue;
            gameState.update(f);
        }
    }

    public void render(float f) {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = this.children.get(i);
            if (!gameState.isActive()) continue;
            gameState.render(f);
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = this.children.get(i);
            gameState.cleanup();
        }
        this.detachAllChildren();
    }

    public void attachChild(GameState gameState) {
        gameState.setParent(this);
        this.children.add(gameState);
    }

    public void detachChild(GameState gameState) {
        this.children.remove(gameState);
    }

    public void detachChild(String string) {
        this.detachChild(this.getChild(string));
    }

    public void detachChild(int n) {
        this.detachChild(this.getChild(n));
    }

    public void detachAllChildren() {
        this.children.clear();
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public GameState getChild(String string) {
        for (GameState gameState : this.children) {
            if (!string.equals(gameState.getName())) continue;
            return gameState;
        }
        return null;
    }

    public GameState getChild(int n) {
        return this.children.get(n);
    }

    public int getQuantity() {
        return this.children.size();
    }

    public boolean hasChild(GameState gameState) {
        return this.children.contains(gameState);
    }

    public void activateAllChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = this.children.get(i);
            gameState.setActive(true);
        }
    }

    public void deactivateAllChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = this.children.get(i);
            gameState.setActive(false);
        }
    }

    public void activateChildNamed(String string) {
        this.getChild(string).setActive(true);
    }

    public void deactivateChildNamed(String string) {
        this.getChild(string).setActive(false);
    }
}

