/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.pass;

import com.jme.renderer.ColorRGBA;
import com.jme.util.ErrorManager;
import com.jme.util.GameTaskQueueManager;
import com.jmex.editors.swing.widget.RGBAChooserPanel;
import com.jmex.editors.swing.widget.ValueSpinner;
import com.jmex.effects.water.WaterRenderPass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WaterPassEditor
extends JPanel {
    private RGBAChooserPanel endColorButton;
    private RGBAChooserPanel startColorButton;
    private JCheckBox enabledCheckBox;
    private JCheckBox waterFoggingBox;
    private JCheckBox enableReflectionBox;
    private JCheckBox enableRefractionBox;
    private JCheckBox enableProjectionCheckBox;
    private ValueSpinner falloffSpeedField;
    private ValueSpinner clipBiasField;
    private ValueSpinner maxAmplitudeField;
    private ValueSpinner falloffStartField;
    private ValueSpinner baseHeightField;
    private ValueSpinner refractField;
    private ValueSpinner reflectField;
    private static final long serialVersionUID = 1L;
    private float origClipBias;
    private float origHeightFalloffSpeed;
    private float origHeightFalloffStart;
    private float origSpeedReflection;
    private float origSpeedRefraction;
    private float origWaterHeight;
    private float origWaterMaxAmplitude;
    private ColorRGBA origWaterColorEnd = new ColorRGBA();
    private ColorRGBA origWaterColorStart = new ColorRGBA();
    private boolean origUseReflection;
    private boolean origUseRefraction;
    private boolean origUseProjection;
    private boolean origWaterFog;
    protected File lastDir;

    public WaterPassEditor(final WaterRenderPass waterRenderPass) {
        this.origClipBias = waterRenderPass.getClipBias();
        this.origHeightFalloffSpeed = waterRenderPass.getHeightFalloffSpeed();
        this.origHeightFalloffStart = waterRenderPass.getHeightFalloffStart();
        this.origSpeedReflection = waterRenderPass.getSpeedReflection();
        this.origSpeedRefraction = waterRenderPass.getSpeedRefraction();
        this.origWaterColorEnd.set(waterRenderPass.getWaterColorEnd());
        this.origWaterColorStart.set(waterRenderPass.getWaterColorStart());
        this.origWaterHeight = waterRenderPass.getWaterHeight();
        this.origWaterMaxAmplitude = waterRenderPass.getWaterMaxAmplitude();
        this.origUseReflection = waterRenderPass.isUseReflection();
        this.origUseRefraction = waterRenderPass.isUseRefraction();
        this.origUseProjection = waterRenderPass.isUseRefraction();
        this.origWaterFog = waterRenderPass.isUseFadeToFogColor();
        this.setLayout(new GridBagLayout());
        this.enabledCheckBox = new JCheckBox("Water Enabled");
        this.enabledCheckBox.setSelected(waterRenderPass.isEnabled());
        this.enabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                waterRenderPass.setEnabled(WaterPassEditor.this.enabledCheckBox.isSelected());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.enabledCheckBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, "Water Color", 0, 0, null, null));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.add((Component)jPanel, gridBagConstraints2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Start");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 2, 0, 4);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints3);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("End");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(0, 4, 0, 2);
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints4);
        this.startColorButton = new RGBAChooserPanel(){
            private static final long serialVersionUID = 1L;

            protected ColorRGBA getColor() {
                return WaterPassEditor.this.origWaterColorStart.clone();
            }

            protected void setColor(ColorRGBA colorRGBA) {
                waterRenderPass.getWaterColorStart().set(colorRGBA);
            }
        };
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(2, 2, 0, 4);
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridx = 0;
        jPanel.add((Component)this.startColorButton, gridBagConstraints5);
        this.endColorButton = new RGBAChooserPanel(){
            private static final long serialVersionUID = 1L;

            protected ColorRGBA getColor() {
                return WaterPassEditor.this.origWaterColorEnd.clone();
            }

            protected void setColor(ColorRGBA colorRGBA) {
                waterRenderPass.getWaterColorEnd().set(colorRGBA);
            }
        };
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(2, 4, 0, 2);
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.gridx = 1;
        jPanel.add((Component)this.endColorButton, gridBagConstraints6);
        this.waterFoggingBox = new JCheckBox();
        this.waterFoggingBox.setSelected(waterRenderPass.isUseFadeToFogColor());
        this.waterFoggingBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                waterRenderPass.useFadeToFogColor(WaterPassEditor.this.waterFoggingBox.isSelected());
            }
        });
        this.waterFoggingBox.setText("Water Fogging");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.gridx = 0;
        jPanel.add((Component)this.waterFoggingBox, gridBagConstraints7);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(null, "Reflection", 0, 0, null, null));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.gridx = 0;
        this.add((Component)jPanel2, gridBagConstraints8);
        this.enableReflectionBox = new JCheckBox();
        this.enableReflectionBox.setSelected(waterRenderPass.isUseReflection());
        this.enableReflectionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Callable callable = new Callable(){

                    public Object call() {
                        try {
                            waterRenderPass.setUseReflection(WaterPassEditor.this.enableReflectionBox.isSelected());
                        }
                        catch (Exception exception) {
                            ErrorManager.getInstance().addError(Level.SEVERE, "Water Editor Error Caught", (Throwable)exception);
                        }
                        return null;
                    }
                };
                GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
            }
        });
        this.enableReflectionBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.enableReflectionBox.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.enableReflectionBox.setText("Enable:");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridwidth = 2;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridy = 0;
        gridBagConstraints9.gridx = 0;
        jPanel2.add((Component)this.enableReflectionBox, gridBagConstraints9);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Reflection Speed:");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.gridx = 0;
        jPanel2.add((Component)jLabel3, gridBagConstraints10);
        this.reflectField = new ValueSpinner(-1000.0f, 1000.0f, 0.01f);
        this.reflectField.setValue(Float.valueOf(waterRenderPass.getSpeedReflection()));
        this.reflectField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setSpeedReflection(((Number)WaterPassEditor.this.reflectField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.gridx = 1;
        jPanel2.add((Component)this.reflectField, gridBagConstraints11);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, "Refraction", 0, 0, null, null));
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.weightx = 0.0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.gridx = 1;
        this.add((Component)jPanel3, gridBagConstraints12);
        this.enableRefractionBox = new JCheckBox();
        this.enableRefractionBox.setSelected(waterRenderPass.isUseRefraction());
        this.enableRefractionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Callable callable = new Callable(){

                    public Object call() {
                        try {
                            waterRenderPass.setUseRefraction(WaterPassEditor.this.enableRefractionBox.isSelected());
                        }
                        catch (Exception exception) {
                            ErrorManager.getInstance().addError(Level.SEVERE, "Water Editor Error Caught", (Throwable)exception);
                        }
                        return null;
                    }
                };
                GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
            }
        });
        this.enableRefractionBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.enableRefractionBox.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.enableRefractionBox.setText("Enable:");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridwidth = 2;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.gridx = 0;
        jPanel3.add((Component)this.enableRefractionBox, gridBagConstraints13);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Refraction Speed:");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridy = 1;
        gridBagConstraints14.gridx = 0;
        jPanel3.add((Component)jLabel4, gridBagConstraints14);
        this.refractField = new ValueSpinner(-1000.0f, 1000.0f, 0.1f);
        this.refractField.setValue(Float.valueOf(waterRenderPass.getSpeedRefraction()));
        this.refractField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setSpeedRefraction(((Number)WaterPassEditor.this.refractField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints15.gridy = 1;
        gridBagConstraints15.gridx = 1;
        jPanel3.add((Component)this.refractField, gridBagConstraints15);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(null, "Waves", 0, 0, null, null));
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridwidth = 2;
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.gridy = 4;
        gridBagConstraints16.gridx = 0;
        this.add((Component)jPanel4, gridBagConstraints16);
        this.enableProjectionCheckBox = new JCheckBox();
        this.enableProjectionCheckBox.setSelected(waterRenderPass.isUseProjectedShader());
        this.enableProjectionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Callable callable = new Callable(){

                    public Object call() {
                        try {
                            waterRenderPass.setUseProjectedShader(WaterPassEditor.this.enableProjectionCheckBox.isSelected());
                        }
                        catch (Exception exception) {
                            ErrorManager.getInstance().addError(Level.SEVERE, "Water Editor Error Caught", (Throwable)exception);
                        }
                        return null;
                    }
                };
                GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
            }
        });
        this.enableProjectionCheckBox.setText("Use Projected");
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridwidth = 2;
        gridBagConstraints17.gridx = 2;
        gridBagConstraints17.gridy = 0;
        jPanel4.add((Component)this.enableProjectionCheckBox, gridBagConstraints17);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Base Height:");
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints18.anchor = 13;
        gridBagConstraints18.gridy = 1;
        gridBagConstraints18.gridx = 0;
        jPanel4.add((Component)jLabel5, gridBagConstraints18);
        this.baseHeightField = new ValueSpinner(-10000.0f, 10000.0f, 0.1f);
        this.baseHeightField.setValue(Float.valueOf(waterRenderPass.getWaterHeight()));
        this.baseHeightField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setWaterHeight(((Number)WaterPassEditor.this.baseHeightField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints19.gridy = 1;
        gridBagConstraints19.gridx = 1;
        jPanel4.add((Component)this.baseHeightField, gridBagConstraints19);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Falloff Start:");
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(0, 8, 2, 2);
        gridBagConstraints20.anchor = 13;
        gridBagConstraints20.gridy = 1;
        gridBagConstraints20.gridx = 2;
        jPanel4.add((Component)jLabel6, gridBagConstraints20);
        this.falloffStartField = new ValueSpinner(-1000.0f, 1000.0f, 0.1f);
        this.falloffStartField.setValue(Float.valueOf(waterRenderPass.getHeightFalloffStart()));
        this.falloffStartField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setHeightFalloffStart(((Number)WaterPassEditor.this.falloffStartField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints21.gridy = 1;
        gridBagConstraints21.gridx = 3;
        jPanel4.add((Component)this.falloffStartField, gridBagConstraints21);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Max Amplitude:");
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints22.anchor = 13;
        gridBagConstraints22.gridy = 2;
        gridBagConstraints22.gridx = 0;
        jPanel4.add((Component)jLabel7, gridBagConstraints22);
        this.maxAmplitudeField = new ValueSpinner(-1000.0f, 1000.0f, 0.1f);
        this.maxAmplitudeField.setValue(Float.valueOf(waterRenderPass.getWaterMaxAmplitude()));
        this.maxAmplitudeField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setWaterMaxAmplitude(((Number)WaterPassEditor.this.maxAmplitudeField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints23.gridy = 2;
        gridBagConstraints23.gridx = 1;
        jPanel4.add((Component)this.maxAmplitudeField, gridBagConstraints23);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Falloff Speed:");
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.insets = new Insets(0, 8, 2, 2);
        gridBagConstraints24.anchor = 13;
        gridBagConstraints24.gridy = 2;
        gridBagConstraints24.gridx = 2;
        jPanel4.add((Component)jLabel8, gridBagConstraints24);
        this.falloffSpeedField = new ValueSpinner(-1000.0f, 1000.0f, 0.1f);
        this.falloffSpeedField.setValue(Float.valueOf(waterRenderPass.getHeightFalloffSpeed()));
        this.falloffSpeedField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setHeightFalloffSpeed(((Number)WaterPassEditor.this.falloffSpeedField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints25.gridy = 2;
        gridBagConstraints25.gridx = 3;
        jPanel4.add((Component)this.falloffSpeedField, gridBagConstraints25);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Clip Bias:");
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints26.anchor = 13;
        gridBagConstraints26.gridy = 3;
        gridBagConstraints26.gridx = 0;
        jPanel4.add((Component)jLabel9, gridBagConstraints26);
        this.clipBiasField = new ValueSpinner(-1000.0f, 1000.0f, 0.1f);
        this.clipBiasField.setValue(Float.valueOf(waterRenderPass.getClipBias()));
        this.clipBiasField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                waterRenderPass.setClipBias(((Number)WaterPassEditor.this.clipBiasField.getValue()).floatValue());
            }
        });
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.gridy = 3;
        gridBagConstraints27.gridx = 1;
        jPanel4.add((Component)this.clipBiasField, gridBagConstraints27);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.gridwidth = 2;
        gridBagConstraints28.gridy = 5;
        gridBagConstraints28.gridx = 0;
        this.add((Component)jPanel5, gridBagConstraints28);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = WaterPassEditor.this.lastDir != null ? new JFileChooser(WaterPassEditor.this.lastDir) : new JFileChooser();
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(WaterPassEditor.this);
                if (n == 1) {
                    return;
                }
                WaterPassEditor.this.lastDir = jFileChooser.getCurrentDirectory();
                WaterPassEditor.this.origClipBias = waterRenderPass.getClipBias();
                WaterPassEditor.this.origHeightFalloffSpeed = waterRenderPass.getHeightFalloffSpeed();
                WaterPassEditor.this.origHeightFalloffStart = waterRenderPass.getHeightFalloffStart();
                WaterPassEditor.this.origSpeedReflection = waterRenderPass.getSpeedReflection();
                WaterPassEditor.this.origSpeedRefraction = waterRenderPass.getSpeedRefraction();
                WaterPassEditor.this.origWaterColorEnd.set(waterRenderPass.getWaterColorEnd());
                WaterPassEditor.this.origWaterColorStart.set(waterRenderPass.getWaterColorStart());
                WaterPassEditor.this.origWaterHeight = waterRenderPass.getWaterHeight();
                WaterPassEditor.this.origWaterMaxAmplitude = waterRenderPass.getWaterMaxAmplitude();
                WaterPassEditor.this.origUseReflection = waterRenderPass.isUseReflection();
                WaterPassEditor.this.origUseRefraction = waterRenderPass.isUseRefraction();
                WaterPassEditor.this.origUseProjection = waterRenderPass.isUseProjectedShader();
                WaterPassEditor.this.origWaterFog = waterRenderPass.isUseFadeToFogColor();
                File file = jFileChooser.getSelectedFile();
                Properties properties = new Properties();
                properties.put("clipBias", "" + WaterPassEditor.this.origClipBias);
                properties.put("heightFalloffSpeed", "" + WaterPassEditor.this.origHeightFalloffSpeed);
                properties.put("heightFalloffStart", "" + WaterPassEditor.this.origHeightFalloffStart);
                properties.put("speedReflection", "" + WaterPassEditor.this.origSpeedReflection);
                properties.put("speedRefraction", "" + WaterPassEditor.this.origSpeedRefraction);
                properties.put("waterColorEnd", "" + WaterPassEditor.this.origWaterColorEnd.asIntARGB());
                properties.put("waterColorStart", "" + WaterPassEditor.this.origWaterColorStart.asIntARGB());
                properties.put("waterHeight", "" + WaterPassEditor.this.origWaterHeight);
                properties.put("waterMaxAmplitude", "" + WaterPassEditor.this.origWaterMaxAmplitude);
                properties.put("useReflection", "" + WaterPassEditor.this.origUseReflection);
                properties.put("useRefraction", "" + WaterPassEditor.this.origUseRefraction);
                properties.put("useProjection", "" + WaterPassEditor.this.origUseProjection);
                properties.put("useWaterFog", "" + WaterPassEditor.this.origWaterFog);
                try {
                    properties.storeToXML(new FileOutputStream(file), "Water properties.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jButton.setText("Export...");
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.insets = new Insets(2, 2, 0, 4);
        gridBagConstraints29.gridx = 0;
        gridBagConstraints29.gridy = 0;
        jPanel5.add((Component)jButton, gridBagConstraints29);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = WaterPassEditor.this.lastDir != null ? new JFileChooser(WaterPassEditor.this.lastDir) : new JFileChooser();
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(WaterPassEditor.this);
                if (n == 1) {
                    return;
                }
                WaterPassEditor.this.lastDir = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                Properties properties = new Properties();
                try {
                    properties.loadFromXML(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                WaterPassEditor.this.origClipBias = Float.parseFloat(properties.getProperty("clipBias", "0.0"));
                WaterPassEditor.this.origHeightFalloffSpeed = Float.parseFloat(properties.getProperty("heightFalloffSpeed", "0.0"));
                WaterPassEditor.this.origHeightFalloffStart = Float.parseFloat(properties.getProperty("heightFalloffStart", "0.0"));
                WaterPassEditor.this.origSpeedReflection = Float.parseFloat(properties.getProperty("speedReflection", "0.0"));
                WaterPassEditor.this.origSpeedRefraction = Float.parseFloat(properties.getProperty("speedRefraction", "0.0"));
                WaterPassEditor.this.origWaterColorEnd.fromIntARGB(Integer.parseInt(properties.getProperty("waterColorEnd", "0.0")));
                WaterPassEditor.this.origWaterColorStart.fromIntARGB(Integer.parseInt(properties.getProperty("waterColorStart", "0.0")));
                WaterPassEditor.this.origWaterHeight = Float.parseFloat(properties.getProperty("waterHeight", "0.0"));
                WaterPassEditor.this.origWaterMaxAmplitude = Float.parseFloat(properties.getProperty("waterMaxAmplitude", "0.0"));
                WaterPassEditor.this.origUseReflection = Boolean.parseBoolean(properties.getProperty("useReflection", "true"));
                WaterPassEditor.this.origUseRefraction = Boolean.parseBoolean(properties.getProperty("useRefraction", "true"));
                WaterPassEditor.this.origUseProjection = Boolean.parseBoolean(properties.getProperty("useProjection", "true"));
                WaterPassEditor.this.origWaterFog = Boolean.parseBoolean(properties.getProperty("useWaterFog", "true"));
                WaterPassEditor.this.revert(waterRenderPass);
            }
        });
        jButton2.setText("Import...");
        GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
        gridBagConstraints30.insets = new Insets(2, 4, 0, 2);
        gridBagConstraints30.gridx = 1;
        gridBagConstraints30.gridy = 0;
        jPanel5.add((Component)jButton2, gridBagConstraints30);
        JButton jButton3 = new JButton();
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints31.gridwidth = 2;
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.gridy = 1;
        jPanel5.add((Component)jButton3, gridBagConstraints31);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaterPassEditor.this.revert(waterRenderPass);
            }
        });
        jButton3.setText("Reset");
    }

    private void revert(WaterRenderPass waterRenderPass) {
        this.clipBiasField.setValue(Float.valueOf(this.origClipBias));
        this.falloffSpeedField.setValue(Float.valueOf(this.origHeightFalloffSpeed));
        this.falloffStartField.setValue(Float.valueOf(this.origHeightFalloffStart));
        this.reflectField.setValue(Float.valueOf(this.origSpeedReflection));
        this.refractField.setValue(Float.valueOf(this.origSpeedRefraction));
        this.baseHeightField.setValue(Float.valueOf(this.origWaterHeight));
        this.maxAmplitudeField.setValue(Float.valueOf(this.origWaterMaxAmplitude));
        this.enableReflectionBox.setSelected(this.origUseReflection);
        this.enableRefractionBox.setSelected(this.origUseRefraction);
        this.enableProjectionCheckBox.setSelected(this.origUseProjection);
        this.waterFoggingBox.setSelected(this.origWaterFog);
        this.startColorButton.updateColor();
        this.endColorButton.updateColor();
    }

    public static JFrame makeFrame(WaterRenderPass waterRenderPass) {
        JFrame jFrame = new JFrame("Water Settings");
        WaterPassEditor waterPassEditor = new WaterPassEditor(waterRenderPass);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)waterPassEditor, "Center");
        jFrame.pack();
        return jFrame;
    }
}

