/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.settings;

import com.jme.system.GameSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GameSettings settings;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private JComboBox renderer;
    private JComboBox resolution;
    private JComboBox depth;
    private JComboBox frequency;
    private JComboBox verticalSync;
    private JComboBox fullscreen;
    private JComboBox music;
    private JComboBox sfx;
    private JComboBox depthBits;
    private JComboBox alphaBits;
    private JComboBox stencilBits;
    private JComboBox samples;
    private HashMap<String, JComboBox> map;
    private HashMap<String, Object> defaults;

    public GameSettingsPanel(GameSettings gameSettings) {
        this.settings = gameSettings;
        this.map = new HashMap();
        this.defaults = new HashMap();
        this.init();
    }

    private void init() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        List<Component> list = this.getSettingsComponents();
        this.revert();
        JLabel jLabel = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component = list.get(i);
            jLabel = new JLabel(" " + component.getName() + ": ");
            jLabel.setHorizontalAlignment(4);
            this.constraints.gridwidth = 1;
            this.constraints.anchor = 13;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            this.layout.setConstraints(jLabel, this.constraints);
            this.add(jLabel);
            this.constraints.anchor = 17;
            this.constraints.gridwidth = 0;
            this.layout.setConstraints(component, this.constraints);
            this.add(component);
        }
    }

    public void addSetting(String string, Object[] objectArray, Object object) {
        object = this.settings.getObject(string, object);
        System.out.println("Default Choice for " + string + " = " + object);
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setName(string);
        jComboBox.setSelectedItem(object);
        JLabel jLabel = new JLabel(" " + jComboBox.getName() + ": ");
        jLabel.setHorizontalAlignment(4);
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.layout.setConstraints(jLabel, this.constraints);
        this.add(jLabel);
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(jComboBox, this.constraints);
        this.add(jComboBox);
        this.map.put(string, jComboBox);
        this.defaults.put(string, object);
    }

    protected List<Component> getSettingsComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(this.createRenderer());
        arrayList.add(this.createResolution());
        arrayList.add(this.createDepth());
        arrayList.add(this.createFrequency());
        arrayList.add(this.createVerticalSync());
        arrayList.add(this.createFullscreen());
        arrayList.add(this.createMusic());
        arrayList.add(this.createSFX());
        arrayList.add(this.createDepthBits());
        arrayList.add(this.createAlphaBits());
        arrayList.add(this.createStencilBits());
        arrayList.add(this.createSamples());
        return arrayList;
    }

    protected Component createRenderer() {
        this.renderer = new JComboBox<Object>(new Object[]{"LWJGL"});
        this.renderer.setName("Renderer");
        return this.renderer;
    }

    protected Component createResolution() {
        this.resolution = new JComboBox<Object>(new Object[]{"640x480", "800x600", "1024x768", "1280x1024", "1600x1200", "1440x900"});
        this.resolution.setName("Resolution");
        return this.resolution;
    }

    protected Component createDepth() {
        this.depth = new JComboBox<Object>(new Object[]{"16", "32"});
        this.depth.setName("Depth");
        return this.depth;
    }

    protected Component createFrequency() {
        this.frequency = new JComboBox<Object>(new Object[]{"60", "70", "72", "75", "85", "100", "120", "140"});
        this.frequency.setName("Frequency");
        return this.frequency;
    }

    protected Component createVerticalSync() {
        this.verticalSync = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.verticalSync.setName("Vertical Sync");
        return this.verticalSync;
    }

    protected Component createFullscreen() {
        this.fullscreen = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.fullscreen.setName("Fullscreen");
        return this.fullscreen;
    }

    protected Component createMusic() {
        this.music = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.music.setName("Music");
        return this.music;
    }

    protected Component createSFX() {
        this.sfx = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.sfx.setName("Sound Effects");
        return this.sfx;
    }

    protected Component createDepthBits() {
        this.depthBits = new JComboBox<Object>(new Object[]{"8"});
        this.depthBits.setName("Depth Bits");
        return this.depthBits;
    }

    protected Component createAlphaBits() {
        this.alphaBits = new JComboBox<Object>(new Object[]{"0"});
        this.alphaBits.setName("Alpha Bits");
        return this.alphaBits;
    }

    protected Component createStencilBits() {
        this.stencilBits = new JComboBox<Object>(new Object[]{"0"});
        this.stencilBits.setName("Stencil Bits");
        return this.stencilBits;
    }

    protected Component createSamples() {
        this.samples = new JComboBox<Object>(new Object[]{"0"});
        this.samples.setName("Samples");
        return this.samples;
    }

    public void defaults() {
        try {
            this.settings.clear();
            this.revert();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void revert() {
        this.renderer.setSelectedItem(this.settings.getRenderer());
        this.resolution.setSelectedItem(this.settings.getWidth() + "x" + this.settings.getHeight());
        this.depth.setSelectedItem(String.valueOf(this.settings.getDepth()));
        this.frequency.setSelectedItem(String.valueOf(this.settings.getFrequency()));
        this.verticalSync.setSelectedItem(this.settings.isVerticalSync() ? "Yes" : "No");
        this.fullscreen.setSelectedItem(this.settings.isFullscreen() ? "Yes" : "No");
        this.music.setSelectedItem(this.settings.isMusic() ? "Yes" : "No");
        this.sfx.setSelectedItem(this.settings.isSFX() ? "Yes" : "No");
        this.depthBits.setSelectedItem(String.valueOf(this.settings.getDepthBits()));
        this.alphaBits.setSelectedItem(String.valueOf(this.settings.getAlphaBits()));
        this.stencilBits.setSelectedItem(String.valueOf(this.settings.getStencilBits()));
        this.samples.setSelectedItem(String.valueOf(this.settings.getSamples()));
        for (String string : this.map.keySet()) {
            JComboBox jComboBox = this.map.get(string);
            jComboBox.setSelectedItem(this.settings.getObject(string, this.defaults.get(string)));
        }
    }

    public void apply() {
        this.settings.setRenderer((String)this.renderer.getSelectedItem());
        String[] stringArray = ((String)this.resolution.getSelectedItem()).split("x");
        this.settings.setWidth(Integer.parseInt(stringArray[0]));
        this.settings.setHeight(Integer.parseInt(stringArray[1]));
        this.settings.setDepth(Integer.parseInt((String)this.depth.getSelectedItem()));
        this.settings.setFrequency(Integer.parseInt((String)this.frequency.getSelectedItem()));
        this.settings.setVerticalSync(this.verticalSync.getSelectedItem().equals("Yes"));
        this.settings.setFullscreen(this.fullscreen.getSelectedItem().equals("Yes"));
        this.settings.setMusic(this.music.getSelectedItem().equals("Yes"));
        this.settings.setSFX(this.sfx.getSelectedItem().equals("Yes"));
        this.settings.setDepthBits(Integer.parseInt((String)this.depthBits.getSelectedItem()));
        this.settings.setAlphaBits(Integer.parseInt((String)this.alphaBits.getSelectedItem()));
        this.settings.setStencilBits(Integer.parseInt((String)this.stencilBits.getSelectedItem()));
        this.settings.setSamples(Integer.parseInt((String)this.samples.getSelectedItem()));
        for (String string : this.map.keySet()) {
            this.settings.setObject(string, this.map.get(string).getSelectedItem());
        }
    }

    public static final void prompt(GameSettings gameSettings) throws InterruptedException {
        final JFrame jFrame = new JFrame("TestStandardGame - Settings");
        jFrame.setDefaultCloseOperation(0);
        jFrame.setAlwaysOnTop(true);
        final GameSettingsPanel gameSettingsPanel = new GameSettingsPanel(gameSettings);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if ("Defaults".equals(jButton.getText())) {
                    gameSettingsPanel.defaults();
                } else if ("Revert".equals(jButton.getText())) {
                    gameSettingsPanel.revert();
                } else if ("OK".equals(jButton.getText())) {
                    gameSettingsPanel.apply();
                    jFrame.dispose();
                } else if ("Cancel".equals(jButton.getText())) {
                    jFrame.dispose();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Defaults");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("Revert");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("OK");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", gameSettingsPanel);
        container.add("South", jPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        while (jFrame.isVisible()) {
            Thread.sleep(50L);
        }
    }
}

