/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.widget;

import com.jme.renderer.ColorRGBA;
import com.jme.util.ErrorManager;
import com.jme.util.GameTaskQueueManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class RGBAChooserPanel
extends JPanel {
    private JSpinner alphaSpinner;
    private JPanel rgbPanel;
    private static final long serialVersionUID = 1L;

    public RGBAChooserPanel() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setForeground(Color.WHITE);
        jLabel.setFont(new Font("Arial", 1, 10));
        jLabel.setText("RGB");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.rgbPanel = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.ipady = 20;
        gridBagConstraints2.ipadx = 20;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.rgbPanel.setToolTipText("Click here to set RGB color.");
        ColorRGBA colorRGBA = new ColorRGBA(this.getColor());
        colorRGBA.a = 1.0f;
        this.rgbPanel.setBackground(this.makeColor(colorRGBA));
        this.rgbPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Color color = JColorChooser.showDialog(RGBAChooserPanel.this, "Pick a color", RGBAChooserPanel.this.rgbPanel.getBackground());
                if (color == null) {
                    return;
                }
                RGBAChooserPanel.this.rgbPanel.setBackground(color);
                ColorRGBA colorRGBA = RGBAChooserPanel.this.makeColorRGBA(color);
                colorRGBA.a = (float)((Integer)RGBAChooserPanel.this.alphaSpinner.getValue()).intValue() / 255.0f;
                RGBAChooserPanel.this.setColor(colorRGBA);
            }
        });
        this.add((Component)this.rgbPanel, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setForeground(Color.WHITE);
        jLabel2.setFont(new Font("Arial", 1, 10));
        jLabel2.setText("alpha");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints3.anchor = 15;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridx = 0;
        this.add((Component)jLabel2, gridBagConstraints3);
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel((int)(this.getColor().a * 255.0f), 0, 255, 1);
        this.alphaSpinner = new JSpinner(spinnerNumberModel);
        this.alphaSpinner.setFont(new Font("Arial", 0, 9));
        this.alphaSpinner.setToolTipText("Alpha value for above color.");
        this.alphaSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Callable callable = new Callable(){

                    public Object call() {
                        try {
                            ColorRGBA colorRGBA = RGBAChooserPanel.this.makeColorRGBA(RGBAChooserPanel.this.rgbPanel.getBackground());
                            colorRGBA.a = spinnerNumberModel.getNumber().floatValue() / 255.0f;
                            RGBAChooserPanel.this.setColor(colorRGBA);
                        }
                        catch (Exception exception) {
                            ErrorManager.getInstance().addError(Level.SEVERE, "Swing Change Error Caught!", (Throwable)exception);
                        }
                        return null;
                    }
                };
                GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
            }
        });
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints4.ipadx = 15;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.gridx = 0;
        this.add((Component)this.alphaSpinner, gridBagConstraints4);
    }

    public void updateColor() {
        ColorRGBA colorRGBA = new ColorRGBA(this.getColor());
        this.rgbPanel.setBackground(this.makeColor(colorRGBA));
        this.alphaSpinner.setValue((int)(this.getColor().a * 255.0f));
    }

    protected abstract ColorRGBA getColor();

    protected abstract void setColor(ColorRGBA var1);

    protected ColorRGBA makeColorRGBA(Color color) {
        if (color == null) {
            return new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return new ColorRGBA((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    protected Color makeColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            return new Color(0, 0, 0, 1);
        }
        return new Color((int)(colorRGBA.r * 255.0f), (int)(colorRGBA.g * 255.0f), (int)(colorRGBA.b * 255.0f), (int)(colorRGBA.a * 255.0f));
    }
}

