/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.Bone;
import com.jme.animation.BoneAnimation;
import com.jme.animation.BoneChangeEvent;
import com.jme.animation.BoneChangeListener;
import com.jme.animation.BoneInfluence;
import com.jme.math.Matrix4f;
import com.jme.math.Vector3f;
import com.jme.scene.ConnectionPoint;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.batch.GeomBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.VertMap;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinNode
extends Node
implements Savable,
BoneChangeListener {
    private static final long serialVersionUID = 1L;
    public static float THROTTLE = 0.033333335f;
    public static float OFFSCREEN_THROTTLE = 0.25f;
    protected static Vector3f vertex = new Vector3f();
    protected static Vector3f normal = new Vector3f();
    protected boolean recalcBounds = true;
    protected boolean recalcNormals = true;
    protected boolean needsRefresh = true;
    protected Geometry skin = null;
    protected ArrayList<Bone> skeletons = new ArrayList();
    protected ArrayList<BoneInfluence>[][] cache = null;
    protected ArrayList<ConnectionPoint> connectionPoints;
    protected boolean newSkeletonAssigned = false;
    protected transient Matrix4f bindMatrix = new Matrix4f();
    protected float updateTime = 0.0f;

    public SkinNode() {
        this.setLastFrustumIntersection(2);
    }

    public SkinNode(String string) {
        super(string);
    }

    public Geometry getSkin() {
        return this.skin;
    }

    public void setSkin(Geometry geometry) {
        this.skin = geometry;
        this.attachChild(geometry);
    }

    public void setAnimation(BoneAnimation boneAnimation) {
        if (this.skeletons == null || this.skeletons.size() == 0) {
            return;
        }
        if (this.skeletons.get(0) == null) {
            return;
        }
        if (this.skeletons.get(0).getAnimationController() != null) {
            this.skeletons.get(0).getAnimationController().setActiveAnimation(boneAnimation);
        }
    }

    public void setAnimation(int n) {
        if (this.skeletons == null || this.skeletons.size() == 0) {
            return;
        }
        if (this.skeletons.get(0) == null) {
            return;
        }
        if (this.skeletons.get(0).getAnimationController() != null) {
            this.skeletons.get(0).getAnimationController().setActiveAnimation(n);
        }
    }

    public void setAnimation(String string) {
        if (this.skeletons == null || this.skeletons.size() == 0) {
            return;
        }
        if (this.skeletons.get(0) == null) {
            return;
        }
        if (this.skeletons.get(0).getAnimationController() != null) {
            this.skeletons.get(0).getAnimationController().setActiveAnimation(string);
        }
    }

    public String getAnimationString() {
        return this.skeletons.get(0).getAnimationController().getActiveAnimation().getName();
    }

    public boolean isRecalcBounds() {
        return this.recalcBounds;
    }

    public void setRecalcBounds(boolean bl) {
        this.recalcBounds = bl;
    }

    public boolean isRecalcNormals() {
        return this.recalcNormals;
    }

    public void setRecalcNormals(boolean bl) {
        this.recalcNormals = bl;
    }

    public void addBoneInfluence(int n, int n2, Bone bone, float f) {
        ArrayList<BoneInfluence> arrayList;
        if (f == 0.0f) {
            return;
        }
        if (this.cache == null) {
            this.recreateCache();
        }
        if ((arrayList = this.cache[n][n2]) == null) {
            arrayList = new ArrayList(1);
            this.cache[n][n2] = arrayList;
        }
        BoneInfluence boneInfluence = new BoneInfluence(bone, f);
        boneInfluence.boneId = bone.getName();
        if (!arrayList.contains(boneInfluence)) {
            arrayList.add(boneInfluence);
        }
    }

    public void addBoneInfluence(int n, int n2, String string, float f) {
        ArrayList<BoneInfluence> arrayList;
        if (f == 0.0f) {
            return;
        }
        if (this.cache == null) {
            this.recreateCache();
        }
        if ((arrayList = this.cache[n][n2]) == null) {
            arrayList = new ArrayList(1);
            this.cache[n][n2] = arrayList;
        }
        BoneInfluence boneInfluence = new BoneInfluence(null, f);
        boneInfluence.boneId = string;
        if (!arrayList.contains(boneInfluence)) {
            arrayList.add(boneInfluence);
        }
    }

    public ConnectionPoint addConnectionPoint(String string, Bone bone) {
        ConnectionPoint connectionPoint = new ConnectionPoint(string, bone);
        if (this.connectionPoints == null) {
            this.connectionPoints = new ArrayList();
        }
        this.connectionPoints.add(connectionPoint);
        this.attachChild(connectionPoint);
        return connectionPoint;
    }

    public ArrayList<ConnectionPoint> getConnectionPoints() {
        return this.connectionPoints;
    }

    public void recreateCache() {
        this.cache = new ArrayList[this.skin.getBatchCount()][];
        for (int i = 0; i < this.cache.length; ++i) {
            this.cache[i] = new ArrayList[this.skin.getBatch(i).getVertexCount()];
        }
    }

    @Override
    public void updateGeometricState(float f, boolean bl) {
        if (this.newSkeletonAssigned) {
            this.assignSkeletonBoneInfluences();
        }
        this.updateTime += f;
        if (this.skin != null && this.needsRefresh && this.updateTime >= THROTTLE) {
            this.updateSkin();
            if (this.recalcBounds) {
                this.skin.updateModelBound();
            }
            this.needsRefresh = false;
            super.updateGeometricState(this.updateTime, bl);
            this.updateTime = 0.0f;
        }
        this.updateWorldVectors();
        if (this.skin != null) {
            this.skin.updateWorldVectors();
        }
    }

    public void normalizeWeights() {
        if (this.cache == null) {
            return;
        }
        int n = this.cache.length;
        while (--n >= 0) {
            this.normalizeWeights(n);
        }
    }

    public int getInfluenceCount(int n) {
        if (this.cache == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.cache[n].length;
        while (--n3 >= 0) {
            ArrayList<BoneInfluence> arrayList = this.cache[n][n3];
            if (arrayList == null) continue;
            n2 += arrayList.size();
        }
        return n2;
    }

    public void normalizeWeights(int n) {
        if (this.cache == null) {
            return;
        }
        int n2 = this.cache[n].length;
        while (--n2 >= 0) {
            BoneInfluence boneInfluence;
            ArrayList<BoneInfluence> arrayList = this.cache[n][n2];
            if (arrayList == null) continue;
            float f = 0.0f;
            int n3 = arrayList.size();
            while (--n3 >= 0) {
                boneInfluence = arrayList.get(n3);
                f += boneInfluence.weight;
            }
            n3 = arrayList.size();
            while (--n3 >= 0) {
                boneInfluence = arrayList.get(n3);
                boneInfluence.weight /= f;
            }
        }
    }

    public void addSkeleton(Bone bone) {
        if (this.skeletons == null) {
            this.skeletons = new ArrayList();
        }
        this.skeletons.add(bone);
        this.newSkeletonAssigned = true;
        bone.addBoneListener(this);
    }

    public void setSkeleton(Bone bone) {
        if (this.skeletons == null) {
            this.skeletons = new ArrayList();
        }
        this.skeletons.clear();
        this.addSkeleton(bone);
    }

    public void assignSkeletonBoneInfluences() {
        for (int i = 0; i < this.cache.length; ++i) {
            for (int j = 0; j < this.cache[i].length; ++j) {
                if (this.cache[i][j] == null) continue;
                for (int k = 0; k < this.cache[i][j].size(); ++k) {
                    this.cache[i][j].get(k).assignBone(this.skeletons.get(0));
                }
            }
        }
        this.regenInfluenceOffsets();
        this.normalizeWeights();
        this.newSkeletonAssigned = false;
    }

    public void regenInfluenceOffsets() {
        if (this.cache == null) {
            return;
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        int n = this.cache.length;
        while (--n >= 0) {
            GeomBatch geomBatch = this.skin.getBatch(n);
            FloatBuffer floatBuffer = geomBatch.getVertexBuffer();
            FloatBuffer floatBuffer2 = geomBatch.getNormalBuffer();
            floatBuffer.clear();
            floatBuffer2.clear();
            int n2 = this.cache[n].length;
            for (int i = 0; i < n2; ++i) {
                ArrayList<BoneInfluence> arrayList = this.cache[n][i];
                vector3f.set(floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
                vector3f2.set(floatBuffer2.get(), floatBuffer2.get(), floatBuffer2.get());
                if (arrayList == null) continue;
                this.bindMatrix.mult(vector3f, vector3f);
                if (this.recalcNormals) {
                    this.bindMatrix.rotateVect(vector3f2);
                }
                int n3 = arrayList.size();
                while (--n3 >= 0) {
                    BoneInfluence boneInfluence = arrayList.get(n3);
                    boneInfluence.vOffset = new Vector3f(vector3f);
                    if (boneInfluence.bone != null) {
                        boneInfluence.bone.bindMatrix.inverseTranslateVect(boneInfluence.vOffset);
                        boneInfluence.bone.bindMatrix.inverseRotateVect(boneInfluence.vOffset);
                    }
                    if (this.recalcNormals) {
                        boneInfluence.nOffset = new Vector3f(vector3f2);
                        if (boneInfluence.bone == null) continue;
                        boneInfluence.bone.bindMatrix.inverseRotateVect(boneInfluence.nOffset);
                        continue;
                    }
                    boneInfluence.nOffset = null;
                }
            }
        }
    }

    public synchronized void updateSkin() {
        if (this.cache == null || this.skin == null) {
            return;
        }
        if (this.skeletons != null) {
            for (Bone object : this.skeletons) {
                object.update();
            }
        }
        int n = this.cache.length;
        while (--n >= 0) {
            GeomBatch geomBatch = this.skin.getBatch(n);
            FloatBuffer floatBuffer = geomBatch.getVertexBuffer();
            FloatBuffer floatBuffer2 = geomBatch.getNormalBuffer();
            floatBuffer.clear();
            if (this.recalcNormals) {
                floatBuffer2.clear();
            }
            geomBatch.setHasDirtyVertices(true);
            int n2 = this.cache[n].length;
            for (int i = 0; i < n2; ++i) {
                ArrayList<BoneInfluence> arrayList = this.cache[n][i];
                if (arrayList == null) continue;
                vertex.zero();
                if (this.recalcNormals) {
                    normal.zero();
                }
                int n3 = arrayList.size();
                while (--n3 >= 0) {
                    BoneInfluence boneInfluence = arrayList.get(n3);
                    if (boneInfluence.bone == null) continue;
                    boneInfluence.bone.applyBone(boneInfluence, vertex, normal);
                }
                vertex.multLocal(this.worldScale);
                if (floatBuffer.remaining() > 2) {
                    floatBuffer.put(SkinNode.vertex.x).put(SkinNode.vertex.y).put(SkinNode.vertex.z);
                }
                if (!this.recalcNormals || floatBuffer2.remaining() <= 2) continue;
                floatBuffer2.put(SkinNode.normal.x).put(SkinNode.normal.y).put(SkinNode.normal.z);
            }
        }
    }

    public ArrayList<BoneInfluence>[][] getCache() {
        return this.cache;
    }

    public void setCache(ArrayList<BoneInfluence>[][] arrayListArray) {
        this.cache = arrayListArray;
    }

    public ArrayList<Bone> getSkeletons() {
        return this.skeletons;
    }

    public void setBindMatrix(Matrix4f matrix4f) {
        this.bindMatrix = matrix4f;
    }

    @Override
    public void batchChange(Geometry geometry, int n, int n2) {
        if (geometry == this.skin) {
            ArrayList<BoneInfluence>[] arrayListArray = this.cache[n];
            ArrayList<BoneInfluence>[] arrayListArray2 = this.cache[n2];
            this.cache[n] = arrayListArray2;
            this.cache[n2] = arrayListArray;
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        this.revertToBind();
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.recalcBounds, "recalcBounds", true);
        outputCapsule.write(this.recalcNormals, "recalcNormals", true);
        outputCapsule.write(this.skin, "skin", null);
        outputCapsule.writeSavableArrayList(this.skeletons, "skeletons", null);
        outputCapsule.writeSavableArrayListArray2D(this.cache, "cache", null);
        outputCapsule.writeSavableArrayList(this.connectionPoints, "connectionPoints", null);
        outputCapsule.write(this.newSkeletonAssigned, "newSkeletonAssigned", false);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.recalcBounds = inputCapsule.readBoolean("recalcBounds", true);
        this.recalcNormals = inputCapsule.readBoolean("recalcNormals", true);
        this.skin = (Geometry)inputCapsule.readSavable("skin", null);
        this.skeletons = inputCapsule.readSavableArrayList("skeletons", null);
        this.cache = inputCapsule.readSavableArrayListArray2D("cache", null);
        this.connectionPoints = inputCapsule.readSavableArrayList("connectionPoints", null);
        this.newSkeletonAssigned = inputCapsule.readBoolean("newSkeletonAssigned", false);
        this.regenInfluenceOffsets();
        this.skin.updateModelBound();
        this.updateWorldBound();
        for (Bone bone : this.skeletons) {
            bone.addBoneListener(this);
        }
    }

    public void revertToBind() {
        for (Bone bone : this.skeletons) {
            bone.getRootSkeleton().revertToBind();
        }
        this.updateSkin();
        this.bindMatrix.loadIdentity();
    }

    @Override
    public void boneChanged(BoneChangeEvent boneChangeEvent) {
        if (this.getLastFrustumIntersection() != 0 || this.updateTime >= OFFSCREEN_THROTTLE) {
            this.needsRefresh = true;
            this.setLastFrustumIntersection(0);
        }
    }

    public void remapInfluences(VertMap[] vertMapArray) {
        for (int i = 0; i < vertMapArray.length; ++i) {
            this.remapInfluences(vertMapArray[i], i);
        }
    }

    public void remapInfluences(VertMap vertMap, int n) {
        ArrayList<BoneInfluence>[] arrayListArray = this.cache[n];
        ArrayList[] arrayListArray2 = new ArrayList[this.skin.getBatch(n).getVertexCount()];
        this.cache[n] = arrayListArray2;
        for (int i = 0; i < arrayListArray.length; ++i) {
            for (int j = 0; j < arrayListArray[i].size(); ++j) {
                BoneInfluence boneInfluence = arrayListArray[i].get(j);
                if (boneInfluence.bone != null) {
                    this.addBoneInfluence(n, vertMap.getNewIndex(i), boneInfluence.bone, boneInfluence.weight);
                    continue;
                }
                this.addBoneInfluence(n, vertMap.getNewIndex(i), boneInfluence.boneId, boneInfluence.weight);
            }
        }
        this.normalizeWeights(n);
    }

    public void removeBatch(int n) {
        ArrayList[][] arrayListArrayArray = new ArrayList[this.skin.getBatchCount()][];
        for (int i = 0; i < this.cache.length - 1; ++i) {
            arrayListArrayArray[i] = i < n ? this.cache[i] : this.cache[i + 1];
        }
        this.cache = arrayListArrayArray;
    }

    public void refreshSkeletons() {
        for (Bone bone : this.skeletons) {
            bone.updateGeometricState(0.0f, true);
        }
    }
}

