/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.util.LoggingSystem;
import com.jme.util.Timer;
import java.util.logging.Level;

public abstract class FixedLogicrateGame
extends AbstractGame {
    private static final int MAX_LOOPS = 50;
    private Timer timer;
    private int logicTPS;
    private long tickTime;
    private long time0;
    private long time1;
    private int loops;

    public void setLogicTicksPerSecond(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Ticks per second cannot be less than zero.");
        }
        this.logicTPS = n;
        this.tickTime = this.timer.getResolution() / (long)this.logicTPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        LoggingSystem.getLogger().log(Level.INFO, "Application started.");
        try {
            this.getAttributes();
            this.initSystem();
            this.assertDisplayCreated();
            this.timer = Timer.getTimer();
            this.setLogicTicksPerSecond(60);
            this.initGame();
            while (!this.finished && !this.display.isClosing()) {
                this.time1 = this.timer.getTime();
                this.loops = 0;
                while (this.time1 - this.time0 > this.tickTime && this.loops < 50) {
                    InputSystem.update();
                    this.update(-1.0f);
                    this.time0 += this.tickTime;
                    ++this.loops;
                }
                if (this.time1 - this.time0 > this.tickTime) {
                    this.time0 = this.time1 - this.tickTime;
                }
                float f = Math.min(1.0f, (float)(this.time1 - this.time0) / (float)this.tickTime);
                this.render(f);
                this.display.getRenderer().displayBackBuffer();
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.cleanup();
        }
        LoggingSystem.getLogger().log(Level.INFO, "Application ending.");
        this.display.reset();
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
        System.exit(0);
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

