/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.intersection.IntersectionRecord;
import com.jme.math.FastMath;
import com.jme.math.Line;
import com.jme.math.LineSegment;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class BoundingCapsule
extends BoundingVolume {
    private static final long serialVersionUID = 1L;
    private transient LineSegment ls;
    private float radius;
    private static Vector3f compVec1 = new Vector3f();
    private static Vector3f compVec2 = new Vector3f();
    private static Vector3f compVec3 = new Vector3f();
    private static Vector3f compVec4 = new Vector3f();
    private static Vector3f diff = new Vector3f();
    private static Line compLine1 = new Line();

    public BoundingCapsule() {
        this.ls = new LineSegment();
    }

    public BoundingCapsule(Vector3f vector3f, LineSegment lineSegment, float f) {
        this.center = vector3f;
        this.ls = lineSegment;
        this.radius = f;
    }

    public BoundingVolume clone(BoundingVolume boundingVolume) {
        if (boundingVolume != null && boundingVolume.getType() == 3) {
            BoundingCapsule boundingCapsule = (BoundingCapsule)boundingVolume;
            boundingCapsule.getCenter().set(this.center);
            boundingCapsule.setRadius(this.radius);
            boundingCapsule.getLineSegment().set(this.ls);
            boundingCapsule.checkPlane = this.checkPlane;
            return boundingCapsule;
        }
        BoundingCapsule boundingCapsule = new BoundingCapsule((Vector3f)this.center.clone(), (LineSegment)this.ls.clone(), this.radius);
        return boundingCapsule;
    }

    public void computeFromBatches(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        BoundingCapsule boundingCapsule = new BoundingCapsule();
        boundingCapsule.computeFromPoints(((GeomBatch)arrayList.get(0)).getVertexBuffer());
        for (int i = 1; i < arrayList.size(); ++i) {
            BoundingCapsule boundingCapsule2 = new BoundingCapsule();
            boundingCapsule2.computeFromPoints(((GeomBatch)arrayList.get(i)).getVertexBuffer());
            boundingCapsule.mergeLocal(boundingCapsule2);
        }
        this.ls = boundingCapsule.getLineSegment();
        this.center = boundingCapsule.getCenter();
        this.radius = boundingCapsule.getRadius();
    }

    public void computeFromPoints(FloatBuffer floatBuffer) {
        this.leastSquaresFit(floatBuffer);
    }

    private void leastSquaresFit(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return;
        }
        floatBuffer.rewind();
        if (floatBuffer.remaining() <= 2) {
            return;
        }
        if (this.ls == null) {
            this.ls = new LineSegment();
        }
        int n = floatBuffer.remaining() / 3;
        compLine1.orthogonalLineFit(floatBuffer);
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVec1, floatBuffer, i);
            float f2 = compLine1.distanceSquared(compVec1);
            if (!(f2 > f)) continue;
            f = f2;
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(compLine1.getDirection()).normalizeLocal();
        Vector3f.generateComplementBasis(vector3f, vector3f2, vector3f3);
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVec1, floatBuffer, i);
            compVec1.subtractLocal(compLine1.getOrigin());
            float f5 = vector3f.dot(compVec1);
            float f6 = vector3f2.dot(compVec1);
            float f7 = vector3f3.dot(compVec1);
            float f8 = f - (f5 * f5 + f6 * f6);
            float f9 = FastMath.sqrt(FastMath.abs(f8));
            float f10 = f7 + f9;
            if (f10 < f3) {
                f3 = f10;
            }
            if (!((f10 = f7 - f9) > f4)) continue;
            f4 = f10;
        }
        this.radius = FastMath.sqrt(f);
        this.ls.getOrigin().set(compLine1.getOrigin().addLocal(compLine1.getDirection().mult((f3 + f4) * 0.5f, compVec1)));
        this.center = this.ls.getOrigin();
        this.ls.getDirection().set(compLine1.getDirection());
        if (f4 > f3) {
            this.ls.setExtent(0.5f * (f4 - f3));
        } else {
            this.ls.setExtent(0.0f);
        }
    }

    public void computeFromTris(int[] nArray, TriangleBatch triangleBatch, int n, int n2) {
    }

    public void computeFromTris(Triangle[] triangleArray, int n, int n2) {
    }

    public boolean contains(Vector3f vector3f) {
        return this.ls.distanceSquared(vector3f) <= this.radius * this.radius;
    }

    public boolean contains(BoundingSphere boundingSphere) {
        return this.contains(boundingSphere.getRadius(), boundingSphere.getCenter());
    }

    public boolean contains(float f, Vector3f vector3f) {
        float f2 = this.radius - f;
        if ((double)f2 >= 0.0) {
            return this.ls.distanceSquared(vector3f) <= f2 * f2;
        }
        return false;
    }

    public boolean contains(BoundingCapsule boundingCapsule) {
        return this.contains(boundingCapsule.getRadius(), boundingCapsule.getLineSegment().getNegativeEnd(compVec1), boundingCapsule.getLineSegment().getPositiveEnd(compVec2));
    }

    public boolean contains(float f, Vector3f vector3f, Vector3f vector3f2) {
        return this.contains(f, vector3f) && this.contains(f, vector3f2);
    }

    public float distanceToEdge(Vector3f vector3f) {
        return 0.0f;
    }

    public int getType() {
        return 3;
    }

    public boolean intersects(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return false;
        }
        return boundingVolume.intersectsCapsule(this);
    }

    public boolean intersects(Ray ray) {
        float f = this.ls.distanceSquared(ray);
        return f <= this.radius * this.radius;
    }

    public boolean intersectsBoundingBox(BoundingBox boundingBox) {
        return false;
    }

    public boolean intersectsCapsule(BoundingCapsule boundingCapsule) {
        float f;
        float f2 = this.ls.distance(boundingCapsule.getLineSegment());
        return f2 <= (f = this.radius + boundingCapsule.getRadius());
    }

    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox orientedBoundingBox) {
        return false;
    }

    public boolean intersectsSphere(BoundingSphere boundingSphere) {
        return false;
    }

    public IntersectionRecord intersectsWhere(Ray ray) {
        return null;
    }

    public BoundingVolume merge(BoundingVolume boundingVolume) {
        switch (boundingVolume.getType()) {
            case 3: {
                return this.mergeCapsule((BoundingCapsule)boundingVolume, new BoundingCapsule());
            }
            case 0: {
                return this.mergeSphere((BoundingSphere)boundingVolume, new BoundingCapsule());
            }
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                Vector3f vector3f = new Vector3f(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
                Vector3f vector3f2 = boundingBox.center;
                BoundingSphere boundingSphere = new BoundingSphere();
                boundingSphere.setCenter(vector3f2);
                boundingSphere.setRadius(vector3f.length());
                return this.mergeSphere(boundingSphere, new BoundingCapsule());
            }
        }
        return null;
    }

    public BoundingCapsule mergeSphere(BoundingSphere boundingSphere, BoundingCapsule boundingCapsule) {
        if (this.contains(boundingSphere)) {
            return this;
        }
        compLine1.getOrigin().set(this.ls.getOrigin().add(boundingSphere.getCenter(), compVec1).mult(0.5f, compVec1));
        compLine1.getDirection().set(this.ls.getDirection());
        compLine1.getDirection().normalizeLocal();
        this.ls.getPositiveEnd(compVec1);
        float f = compLine1.distance(compVec1) + this.radius;
        this.ls.getNegativeEnd(compVec2);
        float f2 = compLine1.distance(compVec2) + this.radius;
        if (f2 > f) {
            f = f2;
        }
        if ((f2 = compLine1.distance(boundingSphere.getCenter()) + boundingSphere.getRadius()) > f) {
            f = f2;
        }
        float f3 = f - boundingSphere.getRadius();
        float f4 = f3 * f3;
        diff = compLine1.getOrigin().subtract(compVec1, diff);
        float f5 = diff.lengthSquared() - f4;
        float f6 = diff.dot(compLine1.getDirection());
        float f7 = f6 * f6 - f5;
        float f8 = FastMath.sqrt(FastMath.abs(f7));
        float f9 = -f6 - f8;
        float f10 = -f6 + f8;
        diff = compLine1.getOrigin().subtract(compVec2, diff);
        f5 = diff.lengthSquared() - f4;
        f6 = diff.dot(compLine1.getDirection());
        f2 = -f6 - (f8 = FastMath.sqrt(FastMath.abs(f7 = f6 * f6 - f5)));
        if (f2 > f9) {
            f9 = f2;
        }
        if ((f2 = -f6 + f8) < f10) {
            f10 = f2;
        }
        f3 = f - boundingSphere.getRadius();
        f4 = f3 * f3;
        diff = compLine1.getOrigin().subtract(boundingSphere.getCenter(), diff);
        f5 = diff.lengthSquared() - f4;
        f6 = diff.dot(compLine1.getDirection());
        f2 = -f6 - (f8 = FastMath.sqrt(FastMath.abs(f7 = f6 * f6 - f5)));
        if (f2 > f9) {
            f9 = f2;
        }
        if ((f2 = -f6 + f8) < f10) {
            f10 = f2;
        }
        boundingCapsule.setRadius(f);
        boundingCapsule.getLineSegment().getOrigin().set(compLine1.getOrigin().add(compLine1.getDirection().mult(0.5f * (f9 + f10))));
        boundingCapsule.getLineSegment().getDirection().set(compLine1.getDirection());
        if (f9 > f10) {
            boundingCapsule.getLineSegment().setExtent(0.5f * (f9 - f10));
        } else {
            boundingCapsule.getLineSegment().setExtent(0.0f);
        }
        return boundingCapsule;
    }

    public BoundingCapsule mergeCapsule(BoundingCapsule boundingCapsule, BoundingCapsule boundingCapsule2) {
        if (this.contains(boundingCapsule)) {
            return this;
        }
        if (boundingCapsule.contains(this)) {
            return boundingCapsule;
        }
        compLine1.getOrigin().set(this.ls.getOrigin().add(boundingCapsule.getLineSegment().getOrigin(), compVec1).mult(0.5f, compVec1));
        if (this.ls.getDirection().dot(boundingCapsule.getLineSegment().getDirection()) >= 0.0f) {
            compLine1.getDirection().set(this.ls.getDirection().add(boundingCapsule.getLineSegment().getDirection(), compVec1));
        } else {
            compLine1.getDirection().set(this.ls.getDirection().subtract(boundingCapsule.getLineSegment().getDirection(), compVec1));
        }
        compLine1.getDirection().normalizeLocal();
        this.ls.getPositiveEnd(compVec1);
        float f = compLine1.distance(compVec1) + this.radius;
        this.ls.getNegativeEnd(compVec2);
        float f2 = compLine1.distance(compVec2) + this.radius;
        if (f2 > f) {
            f = f2;
        }
        boundingCapsule.getLineSegment().getPositiveEnd(compVec3);
        f2 = compLine1.distance(compVec3) + boundingCapsule.getRadius();
        if (f2 > f) {
            f = f2;
        }
        boundingCapsule.getLineSegment().getNegativeEnd(compVec4);
        f2 = compLine1.distance(compVec4) + boundingCapsule.getRadius();
        if (f2 > f) {
            f = f2;
        }
        float f3 = f - boundingCapsule.getRadius();
        float f4 = f3 * f3;
        diff = compLine1.getOrigin().subtract(compVec1, diff);
        float f5 = diff.lengthSquared() - f4;
        float f6 = diff.dot(compLine1.getDirection());
        float f7 = f6 * f6 - f5;
        float f8 = FastMath.sqrt(FastMath.abs(f7));
        float f9 = -f6 - f8;
        float f10 = -f6 + f8;
        diff = compLine1.getOrigin().subtract(compVec2, diff);
        f5 = diff.lengthSquared() - f4;
        f6 = diff.dot(compLine1.getDirection());
        f2 = -f6 - (f8 = FastMath.sqrt(FastMath.abs(f7 = f6 * f6 - f5)));
        if (f2 > f9) {
            f9 = f2;
        }
        if ((f2 = -f6 + f8) < f10) {
            f10 = f2;
        }
        f3 = f - boundingCapsule.getRadius();
        f4 = f3 * f3;
        diff = compLine1.getOrigin().subtract(compVec3, diff);
        f5 = diff.lengthSquared() - f4;
        f6 = diff.dot(compLine1.getDirection());
        f2 = -f6 - (f8 = FastMath.sqrt(FastMath.abs(f7 = f6 * f6 - f5)));
        if (f2 > f9) {
            f9 = f2;
        }
        if ((f2 = -f6 + f8) < f10) {
            f10 = f2;
        }
        diff = compLine1.getOrigin().subtract(compVec4, diff);
        f5 = diff.lengthSquared() - f4;
        f6 = diff.dot(compLine1.getDirection());
        f2 = -f6 - (f8 = FastMath.sqrt(FastMath.abs(f7 = f6 * f6 - f5)));
        if (f2 > f9) {
            f9 = f2;
        }
        if ((f2 = -f6 + f8) < f10) {
            f10 = f2;
        }
        boundingCapsule2.setRadius(f);
        boundingCapsule2.getLineSegment().getOrigin().set(compLine1.getOrigin().add(compLine1.getDirection().mult(0.5f * (f9 + f10))));
        boundingCapsule2.getLineSegment().getDirection().set(compLine1.getDirection());
        if (f9 > f10) {
            boundingCapsule2.getLineSegment().setExtent(0.5f * (f9 - f10));
        } else {
            boundingCapsule2.getLineSegment().setExtent(0.0f);
        }
        return boundingCapsule2;
    }

    public BoundingVolume mergeLocal(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 3: {
                return this.mergeCapsule((BoundingCapsule)boundingVolume, this);
            }
            case 0: {
                return this.mergeSphere((BoundingSphere)boundingVolume, this);
            }
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                Vector3f vector3f = new Vector3f(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
                Vector3f vector3f2 = boundingBox.center;
                BoundingSphere boundingSphere = new BoundingSphere();
                boundingSphere.setCenter(vector3f2);
                boundingSphere.setRadius(vector3f.length());
                return this.mergeSphere(boundingSphere, this);
            }
        }
        return this;
    }

    public BoundingVolume transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2, BoundingVolume boundingVolume) {
        BoundingCapsule boundingCapsule;
        if (boundingVolume == null || boundingVolume.getType() != 3) {
            boundingCapsule = new BoundingCapsule();
            boundingCapsule.setLineSegment(new LineSegment());
        } else {
            boundingCapsule = (BoundingCapsule)boundingVolume;
        }
        this.center.mult(vector3f2, boundingCapsule.getCenter());
        quaternion.mult(boundingCapsule.getCenter(), boundingCapsule.getCenter());
        boundingCapsule.getCenter().addLocal(vector3f);
        this.ls.getOrigin().mult(vector3f2, boundingCapsule.getLineSegment().getOrigin());
        quaternion.mult(boundingCapsule.getLineSegment().getOrigin(), boundingCapsule.getLineSegment().getOrigin());
        boundingCapsule.getLineSegment().getOrigin().addLocal(vector3f);
        boundingCapsule.getLineSegment().getDirection().set(this.ls.getDirection());
        quaternion.mult(boundingCapsule.getLineSegment().getDirection(), boundingCapsule.getLineSegment().getDirection());
        this.ls.getDirection().mult(vector3f2, compVec1).multLocal(this.ls.getExtent());
        boundingCapsule.getLineSegment().setExtent(compVec1.length());
        boundingCapsule.setRadius(FastMath.abs(this.getMaxAxis(vector3f2) * this.radius));
        return boundingCapsule;
    }

    private float getMaxAxis(Vector3f vector3f) {
        float f = FastMath.abs(vector3f.x);
        float f2 = FastMath.abs(vector3f.y);
        float f3 = FastMath.abs(vector3f.z);
        if (f >= f2) {
            if (f >= f3) {
                return f;
            }
            return f3;
        }
        if (f2 >= f3) {
            return f2;
        }
        return f3;
    }

    public int whichSide(Plane plane) {
        float f = plane.pseudoDistance(this.ls.getNegativeEnd(compVec1));
        if (f <= -this.radius) {
            f = plane.pseudoDistance(this.ls.getPositiveEnd(compVec1));
            if (f <= -this.radius) {
                return 2;
            }
            if (f >= this.radius) {
                return 1;
            }
            return 0;
        }
        if (f >= this.radius) {
            return 1;
        }
        return 0;
    }

    public LineSegment getLineSegment() {
        return this.ls;
    }

    public void setLineSegment(LineSegment lineSegment) {
        this.ls = lineSegment;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public float getVolume() {
        return 4.1887903f * this.radius * this.radius * this.radius + (float)Math.PI * this.radius * this.radius * this.getLineSegment().getOrigin().distance(this.getLineSegment().getDirection());
    }
}

