/*
 * Decompiled with CFR 0.152.
 */
package com.jme.curve;

import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.state.RenderState;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.util.Stack;

public abstract class Curve
extends Geometry {
    private static final int DEFAULT_STEPS = 25;
    protected int steps;
    public RenderState[] states = new RenderState[17];

    public Curve(String string) {
        super(string);
        this.steps = 25;
    }

    public Curve(String string, Vector3f[] vector3fArray) {
        super(string);
        if (null == vector3fArray) {
            throw new JmeException("Control Points may not be null.");
        }
        if (vector3fArray.length < 2) {
            throw new JmeException("There must be at least two control points.");
        }
        this.setVertexBuffer(0, BufferUtils.createFloatBuffer(vector3fArray));
        this.steps = 25;
    }

    public void setSteps(int n) {
        this.steps = n;
    }

    public int getSteps() {
        return this.steps;
    }

    public void draw(Renderer renderer) {
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        super.draw(renderer);
        renderer.draw(this);
    }

    public abstract Vector3f getPoint(float var1);

    public abstract Vector3f getPoint(float var1, Vector3f var2);

    public abstract Matrix3f getOrientation(float var1, float var2);

    public abstract Matrix3f getOrientation(float var1, float var2, Vector3f var3);

    protected void applyRenderState(Stack[] stackArray) {
        for (int i = 0; i < stackArray.length; ++i) {
            this.states[i] = stackArray[i].size() > 0 ? ((RenderState)stackArray[i].peek()).extract(stackArray[i], this) : Renderer.defaultStateList[i];
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.steps, "steps", 25);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.steps = inputCapsule.readInt("steps", 25);
    }
}

