/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image;

import com.jme.image.Image;
import com.jme.math.FastMath;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Texture
implements Serializable,
Savable {
    private static final long serialVersionUID = -3642148179543729674L;
    public static boolean DEFAULT_STORE_TEXTURE = false;
    public static final int MM_NONE = 0;
    public static final int MM_NEAREST = 1;
    public static final int MM_LINEAR = 2;
    public static final int MM_NEAREST_NEAREST = 3;
    public static final int MM_NEAREST_LINEAR = 4;
    public static final int MM_LINEAR_NEAREST = 5;
    public static final int MM_LINEAR_LINEAR = 6;
    public static final int FM_NEAREST = 0;
    public static final int FM_LINEAR = 1;
    public static final int WM_CLAMP_S_CLAMP_T = 0;
    public static final int WM_CLAMP_S_WRAP_T = 1;
    public static final int WM_WRAP_S_CLAMP_T = 2;
    public static final int WM_WRAP_S_WRAP_T = 3;
    public static final int WM_ECLAMP_S_ECLAMP_T = 4;
    public static final int WM_BCLAMP_S_BCLAMP_T = 5;
    public static final int AM_REPLACE = 0;
    public static final int AM_DECAL = 1;
    public static final int AM_MODULATE = 2;
    public static final int AM_BLEND = 3;
    public static final int AM_COMBINE = 4;
    public static final int AM_ADD = 5;
    public static final int ACF_REPLACE = 0;
    public static final int ACF_MODULATE = 1;
    public static final int ACF_ADD = 2;
    public static final int ACF_ADD_SIGNED = 3;
    public static final int ACF_SUBTRACT = 4;
    public static final int ACF_INTERPOLATE = 5;
    public static final int ACF_DOT3_RGB = 6;
    public static final int ACF_DOT3_RGBA = 7;
    public static final int ACS_TEXTURE = 0;
    public static final int ACS_PRIMARY_COLOR = 1;
    public static final int ACS_CONSTANT = 2;
    public static final int ACS_PREVIOUS = 3;
    public static final int ACS_TEXTURE0 = 4;
    public static final int ACS_TEXTURE1 = 5;
    public static final int ACS_TEXTURE2 = 6;
    public static final int ACS_TEXTURE3 = 7;
    public static final int ACS_TEXTURE4 = 8;
    public static final int ACS_TEXTURE5 = 9;
    public static final int ACS_TEXTURE6 = 10;
    public static final int ACS_TEXTURE7 = 11;
    public static final int ACS_TEXTURE8 = 12;
    public static final int ACS_TEXTURE9 = 13;
    public static final int ACS_TEXTURE10 = 14;
    public static final int ACS_TEXTURE11 = 15;
    public static final int ACS_TEXTURE12 = 16;
    public static final int ACS_TEXTURE13 = 17;
    public static final int ACS_TEXTURE14 = 18;
    public static final int ACS_TEXTURE15 = 19;
    public static final int ACS_TEXTURE16 = 20;
    public static final int ACS_TEXTURE17 = 21;
    public static final int ACS_TEXTURE18 = 22;
    public static final int ACS_TEXTURE19 = 23;
    public static final int ACS_TEXTURE20 = 24;
    public static final int ACS_TEXTURE21 = 25;
    public static final int ACS_TEXTURE22 = 26;
    public static final int ACS_TEXTURE23 = 27;
    public static final int ACS_TEXTURE24 = 28;
    public static final int ACS_TEXTURE25 = 29;
    public static final int ACS_TEXTURE26 = 30;
    public static final int ACS_TEXTURE27 = 31;
    public static final int ACS_TEXTURE28 = 32;
    public static final int ACS_TEXTURE29 = 33;
    public static final int ACS_TEXTURE30 = 34;
    public static final int ACS_TEXTURE31 = 35;
    public static final int ACO_SRC_COLOR = 0;
    public static final int ACO_ONE_MINUS_SRC_COLOR = 1;
    public static final int ACO_SRC_ALPHA = 2;
    public static final int ACO_ONE_MINUS_SRC_ALPHA = 3;
    public static final int ACSC_ONE = 0;
    public static final int ACSC_TWO = 1;
    public static final int ACSC_FOUR = 2;
    public static final int EM_NONE = 0;
    public static final int EM_EYE_LINEAR = 1;
    public static final int EM_SPHERE = 2;
    public static final int EM_OBJECT_LINEAR = 4;
    public static final int RTT_SOURCE_RGB = 0;
    public static final int RTT_SOURCE_RGBA = 1;
    public static final int RTT_SOURCE_DEPTH = 2;
    public static final int RTT_SOURCE_LUMINANCE = 3;
    public static final int RTT_SOURCE_LUMINANCE_ALPHA = 4;
    public static final int RTT_SOURCE_ALPHA = 5;
    public static final int RTT_SOURCE_INTENSITY = 6;
    private String imageLocation;
    private Image image;
    private ColorRGBA blendColor;
    private Vector3f translation;
    private Vector3f scale;
    private Quaternion rotation;
    private Matrix4f matrix;
    private float anisoLevel = 1.0f;
    private int mipmapState = 0;
    private transient int textureId;
    private int apply = 2;
    private int wrap = 4;
    private int filter = 0;
    private int envMapMode;
    private int rttSource;
    private int memReq;
    private int combineFuncRGB;
    private int combineFuncAlpha;
    private int combineSrc0RGB = 0;
    private int combineSrc1RGB = 3;
    private int combineSrc2RGB = 2;
    private int combineSrc0Alpha;
    private int combineSrc1Alpha;
    private int combineSrc2Alpha;
    private int combineOp0RGB = 0;
    private int combineOp1RGB = 0;
    private int combineOp2RGB = 2;
    private int combineOp0Alpha;
    private int combineOp1Alpha;
    private int combineOp2Alpha;
    private float combineScaleRGB;
    private float combineScaleAlpha;
    private TextureKey key;
    private boolean storeTexture = DEFAULT_STORE_TEXTURE;

    public Texture() {
        this.setBlendColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        this.combineScaleRGB = 1.0f;
        this.combineScaleAlpha = 1.0f;
        this.rttSource = 1;
        this.memReq = 0;
    }

    public Texture(float f) {
        this();
        this.anisoLevel = f;
    }

    public void setBlendColor(ColorRGBA colorRGBA) {
        this.blendColor = colorRGBA;
    }

    public int getMipmapState() {
        return this.mipmapState;
    }

    public void setMipmapState(int n) {
        if (n < 0 || n > 6) {
            n = 0;
        }
        this.mipmapState = n;
    }

    public void setApply(int n) {
        if (n < 0 || n > 5) {
            n = 2;
        }
        this.apply = n;
    }

    @Deprecated
    public void setCorrection(int n) {
    }

    public void setFilter(int n) {
        if (n < 0 || n > 1) {
            n = 0;
        }
        this.filter = n;
    }

    public void setImage(Image image) {
        this.image = image;
        this.updateMemoryReq();
    }

    public void setWrap(int n) {
        if (n < 0 || n > 5) {
            n = 4;
        }
        this.wrap = n;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int n) {
        this.textureId = n;
    }

    public Image getImage() {
        return this.image;
    }

    public int getMipmap() {
        return this.mipmapState;
    }

    public int getApply() {
        return this.apply;
    }

    public ColorRGBA getBlendColor() {
        return this.blendColor;
    }

    public int getWrap() {
        return this.wrap;
    }

    public int getFilter() {
        return this.filter;
    }

    public int getCombineFuncRGB() {
        return this.combineFuncRGB;
    }

    public void setCombineFuncRGB(int n) {
        this.combineFuncRGB = n;
    }

    public int getCombineOp0Alpha() {
        return this.combineOp0Alpha;
    }

    public void setCombineOp0Alpha(int n) {
        this.combineOp0Alpha = n;
    }

    public int getCombineOp0RGB() {
        return this.combineOp0RGB;
    }

    public void setCombineOp0RGB(int n) {
        this.combineOp0RGB = n;
    }

    public int getCombineOp1Alpha() {
        return this.combineOp1Alpha;
    }

    public void setCombineOp1Alpha(int n) {
        this.combineOp1Alpha = n;
    }

    public int getCombineOp1RGB() {
        return this.combineOp1RGB;
    }

    public void setCombineOp1RGB(int n) {
        this.combineOp1RGB = n;
    }

    public int getCombineOp2Alpha() {
        return this.combineOp2Alpha;
    }

    public void setCombineOp2Alpha(int n) {
        this.combineOp2Alpha = n;
    }

    public int getCombineOp2RGB() {
        return this.combineOp2RGB;
    }

    public void setCombineOp2RGB(int n) {
        this.combineOp2RGB = n;
    }

    public float getCombineScaleAlpha() {
        return this.combineScaleAlpha;
    }

    public void setCombineScaleAlpha(float f) {
        this.combineScaleAlpha = f;
    }

    public float getCombineScaleRGB() {
        return this.combineScaleRGB;
    }

    public void setCombineScaleRGB(float f) {
        this.combineScaleRGB = f;
    }

    public int getCombineSrc0Alpha() {
        return this.combineSrc0Alpha;
    }

    public void setCombineSrc0Alpha(int n) {
        this.combineSrc0Alpha = n;
    }

    public int getCombineSrc0RGB() {
        return this.combineSrc0RGB;
    }

    public void setCombineSrc0RGB(int n) {
        this.combineSrc0RGB = n;
    }

    public int getCombineSrc1Alpha() {
        return this.combineSrc1Alpha;
    }

    public void setCombineSrc1Alpha(int n) {
        this.combineSrc1Alpha = n;
    }

    public int getCombineSrc1RGB() {
        return this.combineSrc1RGB;
    }

    public void setCombineSrc1RGB(int n) {
        this.combineSrc1RGB = n;
    }

    public int getCombineSrc2Alpha() {
        return this.combineSrc2Alpha;
    }

    public void setCombineSrc2Alpha(int n) {
        this.combineSrc2Alpha = n;
    }

    public int getCombineSrc2RGB() {
        return this.combineSrc2RGB;
    }

    public void setCombineSrc2RGB(int n) {
        this.combineSrc2RGB = n;
    }

    public int getCombineFuncAlpha() {
        return this.combineFuncAlpha;
    }

    public void setCombineFuncAlpha(int n) {
        this.combineFuncAlpha = n;
    }

    public void setEnvironmentalMapMode(int n) {
        this.envMapMode = n;
    }

    public int getEnvironmentalMapMode() {
        return this.envMapMode;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String string) {
        this.imageLocation = string;
    }

    public float getAnisoLevel() {
        return this.anisoLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Texture)) {
            return false;
        }
        Texture texture = (Texture)object;
        if (this.textureId != texture.textureId) {
            return false;
        }
        if (this.textureId == 0) {
            if (this.getImage() != null && !this.getImage().equals(texture.getImage())) {
                return false;
            }
            if (this.getImage() == null && texture.getImage() != null) {
                return false;
            }
            if (this.getAnisoLevel() != texture.getAnisoLevel()) {
                return false;
            }
            if (this.getApply() != texture.getApply()) {
                return false;
            }
            if (this.getCombineFuncAlpha() != texture.getCombineFuncAlpha()) {
                return false;
            }
            if (this.getCombineFuncRGB() != texture.getCombineFuncRGB()) {
                return false;
            }
            if (this.getCombineOp0Alpha() != texture.getCombineOp0Alpha()) {
                return false;
            }
            if (this.getCombineOp1RGB() != texture.getCombineOp1RGB()) {
                return false;
            }
            if (this.getCombineOp2Alpha() != texture.getCombineOp2Alpha()) {
                return false;
            }
            if (this.getCombineOp2RGB() != texture.getCombineOp2RGB()) {
                return false;
            }
            if (this.getCombineScaleAlpha() != texture.getCombineScaleAlpha()) {
                return false;
            }
            if (this.getCombineScaleRGB() != texture.getCombineScaleRGB()) {
                return false;
            }
            if (this.getCombineSrc0Alpha() != texture.getCombineSrc0Alpha()) {
                return false;
            }
            if (this.getCombineSrc0RGB() != texture.getCombineSrc0RGB()) {
                return false;
            }
            if (this.getCombineSrc1Alpha() != texture.getCombineSrc1Alpha()) {
                return false;
            }
            if (this.getCombineSrc1RGB() != texture.getCombineSrc1RGB()) {
                return false;
            }
            if (this.getCombineSrc2Alpha() != texture.getCombineSrc2Alpha()) {
                return false;
            }
            if (this.getCombineSrc2RGB() != texture.getCombineSrc2RGB()) {
                return false;
            }
            if (this.getEnvironmentalMapMode() != texture.getEnvironmentalMapMode()) {
                return false;
            }
            if (this.getFilter() != texture.getFilter()) {
                return false;
            }
            if (this.getMipmap() != texture.getMipmap()) {
                return false;
            }
            if (this.getMipmapState() != texture.getMipmapState()) {
                return false;
            }
            if (this.getWrap() != texture.getWrap()) {
                return false;
            }
            if (this.getBlendColor() != null && !this.getBlendColor().equals(texture.getBlendColor())) {
                return false;
            }
            if (this.getBlendColor() == null && texture.getBlendColor() != null) {
                return false;
            }
        }
        return true;
    }

    public Texture createSimpleClone() {
        Texture texture = new Texture(this.anisoLevel);
        return this.createSimpleClone(texture);
    }

    public Texture createSimpleClone(Texture texture) {
        texture.setApply(this.apply);
        texture.setCombineFuncAlpha(this.combineFuncAlpha);
        texture.setCombineFuncRGB(this.combineFuncRGB);
        texture.setCombineOp0Alpha(this.combineOp0Alpha);
        texture.setCombineOp0RGB(this.combineOp0RGB);
        texture.setCombineOp1Alpha(this.combineOp1Alpha);
        texture.setCombineOp1RGB(this.combineOp1RGB);
        texture.setCombineOp2Alpha(this.combineOp2Alpha);
        texture.setCombineOp2RGB(this.combineOp2RGB);
        texture.setCombineScaleAlpha(this.combineScaleAlpha);
        texture.setCombineScaleRGB(this.combineScaleRGB);
        texture.setCombineSrc0Alpha(this.combineSrc0Alpha);
        texture.setCombineSrc0RGB(this.combineSrc0RGB);
        texture.setCombineSrc1Alpha(this.combineSrc1Alpha);
        texture.setCombineSrc1RGB(this.combineSrc1RGB);
        texture.setCombineSrc2Alpha(this.combineSrc2Alpha);
        texture.setCombineSrc2RGB(this.combineSrc2RGB);
        texture.setEnvironmentalMapMode(this.envMapMode);
        texture.setFilter(this.filter);
        texture.setImage(this.image);
        texture.memReq = this.memReq;
        texture.setImageLocation(this.imageLocation);
        texture.setMipmapState(this.mipmapState);
        texture.setTextureId(this.textureId);
        texture.setWrap(this.wrap);
        texture.setBlendColor(this.blendColor != null ? this.blendColor.clone() : null);
        if (this.scale != null) {
            texture.setScale(this.scale);
        }
        if (this.translation != null) {
            texture.setTranslation(this.translation);
        }
        if (this.rotation != null) {
            texture.setRotation(this.rotation);
        }
        if (this.matrix != null) {
            texture.setMatrix(this.matrix);
        }
        return texture;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion quaternion) {
        this.rotation = quaternion;
    }

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix4f matrix4f) {
        this.matrix = matrix4f;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setScale(Vector3f vector3f) {
        this.scale = vector3f;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vector3f vector3f) {
        this.translation = vector3f;
    }

    public int getRTTSource() {
        return this.rttSource;
    }

    public void setRTTSource(int n) {
        this.rttSource = n;
    }

    public int getMemoryReq() {
        return this.memReq;
    }

    public void updateMemoryReq() {
        if (this.image != null) {
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            this.memReq = n * n2;
            switch (this.image.getType()) {
                case 0: 
                case 2: 
                case 4: {
                    this.memReq *= 2;
                    break;
                }
                case 1: {
                    this.memReq *= 3;
                    break;
                }
                case 3: {
                    this.memReq *= 4;
                    break;
                }
                case 5: 
                case 9: 
                case 10: {
                    this.memReq = (int)((double)this.memReq * 1.0);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: {
                    this.memReq = (int)((double)this.memReq * 2.0);
                }
            }
            if (this.getMipmap() >= 3 || this.image.hasMipmaps()) {
                this.memReq = FastMath.isPowerOfTwo(this.image.getWidth()) && FastMath.isPowerOfTwo(this.image.getHeight()) ? (int)((float)this.memReq * 1.33333f) : (int)((float)this.memReq * 2.0f);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.textureId = 0;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.imageLocation, "imageLocation", null);
        outputCapsule.write(this.storeTexture, "storeTexture", DEFAULT_STORE_TEXTURE);
        if (this.storeTexture) {
            outputCapsule.write(this.image, "image", null);
        }
        outputCapsule.write(this.blendColor, "blendColor", null);
        outputCapsule.write(this.translation, "translation", null);
        outputCapsule.write(this.scale, "scale", null);
        outputCapsule.write(this.rotation, "rotation", null);
        outputCapsule.write(this.matrix, "matrix", null);
        outputCapsule.write(this.anisoLevel, "anisoLevel", 1.0f);
        outputCapsule.write(this.mipmapState, "mipmapState", 0);
        outputCapsule.write(this.apply, "apply", 2);
        outputCapsule.write(this.wrap, "wrap", 4);
        outputCapsule.write(this.filter, "filter", 0);
        outputCapsule.write(this.envMapMode, "envMapMode", 0);
        outputCapsule.write(this.rttSource, "rttSource", 1);
        outputCapsule.write(this.memReq, "memReq", 0);
        outputCapsule.write(this.combineFuncRGB, "combineFuncRGB", 0);
        outputCapsule.write(this.combineFuncAlpha, "combineFuncAlpha", 0);
        outputCapsule.write(this.combineSrc0RGB, "combineSrc0RGB", 0);
        outputCapsule.write(this.combineSrc1RGB, "combineSrc1RGB", 3);
        outputCapsule.write(this.combineSrc2RGB, "combineSrc2RGB", 2);
        outputCapsule.write(this.combineSrc0Alpha, "combineSrc0Alpha", 0);
        outputCapsule.write(this.combineSrc1Alpha, "combineSrc1Alpha", 0);
        outputCapsule.write(this.combineSrc2Alpha, "combineSrc2Alpha", 0);
        outputCapsule.write(this.combineOp0RGB, "combineOp0RGB", 0);
        outputCapsule.write(this.combineOp1RGB, "combineOp1RGB", 0);
        outputCapsule.write(this.combineOp2RGB, "combineOp2RGB", 2);
        outputCapsule.write(this.combineOp0Alpha, "combineOp0Alpha", 0);
        outputCapsule.write(this.combineOp1Alpha, "combineOp1Alpha", 0);
        outputCapsule.write(this.combineOp2Alpha, "combineOp2Alpha", 0);
        outputCapsule.write(this.combineScaleRGB, "combineScaleRGB", 1.0f);
        outputCapsule.write(this.combineScaleAlpha, "combineScaleAlpha", 1.0f);
        if (!this.storeTexture) {
            outputCapsule.write(this.key, "textureKey", null);
        }
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.imageLocation = inputCapsule.readString("imageLocation", null);
        this.storeTexture = inputCapsule.readBoolean("storeTexture", DEFAULT_STORE_TEXTURE);
        if (this.storeTexture) {
            this.image = (Image)inputCapsule.readSavable("image", null);
        } else {
            this.key = (TextureKey)inputCapsule.readSavable("textureKey", null);
            TextureManager.loadTexture(this, this.key);
        }
        this.blendColor = (ColorRGBA)inputCapsule.readSavable("blendColor", null);
        this.translation = (Vector3f)inputCapsule.readSavable("translation", null);
        this.scale = (Vector3f)inputCapsule.readSavable("scale", null);
        this.rotation = (Quaternion)inputCapsule.readSavable("rotation", null);
        this.matrix = (Matrix4f)inputCapsule.readSavable("matrix", null);
        this.anisoLevel = inputCapsule.readFloat("anisoLevel", 1.0f);
        this.mipmapState = inputCapsule.readInt("mipmapState", 0);
        this.apply = inputCapsule.readInt("apply", 2);
        this.wrap = inputCapsule.readInt("wrap", 4);
        this.filter = inputCapsule.readInt("filter", 0);
        this.envMapMode = inputCapsule.readInt("envMapMode", 0);
        this.rttSource = inputCapsule.readInt("rttSource", 1);
        this.memReq = inputCapsule.readInt("memReq", 0);
        this.combineFuncRGB = inputCapsule.readInt("combineFuncRGB", 0);
        this.combineFuncAlpha = inputCapsule.readInt("combineFuncAlpha", 0);
        this.combineSrc0RGB = inputCapsule.readInt("combineSrc0RGB", 0);
        this.combineSrc1RGB = inputCapsule.readInt("combineSrc1RGB", 3);
        this.combineSrc2RGB = inputCapsule.readInt("combineSrc2RGB", 2);
        this.combineSrc0Alpha = inputCapsule.readInt("combineSrc0Alpha", 0);
        this.combineSrc1Alpha = inputCapsule.readInt("combineSrc1Alpha", 0);
        this.combineSrc2Alpha = inputCapsule.readInt("combineSrc2Alpha", 0);
        this.combineOp0RGB = inputCapsule.readInt("combineOp0RGB", 0);
        this.combineOp1RGB = inputCapsule.readInt("combineOp1RGB", 0);
        this.combineOp2RGB = inputCapsule.readInt("combineOp2RGB", 2);
        this.combineOp0Alpha = inputCapsule.readInt("combineOp0Alpha", 0);
        this.combineOp1Alpha = inputCapsule.readInt("combineOp1Alpha", 0);
        this.combineOp2Alpha = inputCapsule.readInt("combineOp2Alpha", 0);
        this.combineScaleRGB = inputCapsule.readFloat("combineScaleRGB", 1.0f);
        this.combineScaleAlpha = inputCapsule.readFloat("combineScaleAlpha", 1.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void setTextureKey(TextureKey textureKey) {
        this.key = textureKey;
    }

    public TextureKey getTextureKey() {
        return this.key;
    }

    public boolean isStoreTexture() {
        return this.storeTexture;
    }

    public void setStoreTexture(boolean bl) {
        this.storeTexture = bl;
    }
}

