/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image.util;

import com.jme.image.Image;
import com.jme.math.FastMath;
import com.jme.system.JmeException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TGALoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    private TGALoader() {
    }

    public static Image loadImage(InputStream inputStream) throws IOException {
        return TGALoader.loadImage(inputStream, false);
    }

    public static Image loadImage(InputStream inputStream, boolean bl) throws IOException {
        return TGALoader.loadImage(inputStream, bl, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image loadImage(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl3 = false;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8192);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        int n5 = dataInputStream.readUnsignedByte();
        int n6 = dataInputStream.readUnsignedByte();
        int n7 = dataInputStream.readUnsignedByte();
        dataInputStream.readShort();
        int n8 = TGALoader.flipEndian(dataInputStream.readShort());
        int n9 = dataInputStream.readUnsignedByte();
        dataInputStream.readShort();
        dataInputStream.readShort();
        int n10 = TGALoader.flipEndian(dataInputStream.readShort());
        short s = TGALoader.flipEndian(dataInputStream.readShort());
        int n11 = dataInputStream.readUnsignedByte();
        int n12 = dataInputStream.readUnsignedByte();
        if ((n12 & 0x20) != 0) {
            boolean bl4 = bl = !bl;
        }
        if ((n12 & 0x10) != 0) {
            boolean bl5 = bl3 = !bl3;
        }
        if (n5 > 0) {
            bufferedInputStream.skip(n5);
        }
        ColorMapEntry[] colorMapEntryArray = null;
        if (n6 != 0) {
            int n13 = n9 * n8 >> 3;
            n4 = Math.min(n9 / 3, 8);
            byte[] byArray = new byte[n13];
            bufferedInputStream.read(byArray);
            if (n7 == 1 || n7 == 9) {
                colorMapEntryArray = new ColorMapEntry[n8];
                n3 = n9 - 3 * n4;
                float f = 255.0f / (FastMath.pow(2.0f, n4) - 1.0f);
                float f2 = 255.0f / (FastMath.pow(2.0f, n3) - 1.0f);
                for (n2 = 0; n2 < n8; ++n2) {
                    ColorMapEntry colorMapEntry = new ColorMapEntry();
                    n = n9 * n2;
                    colorMapEntry.red = (byte)((float)TGALoader.getBitsAsByte(byArray, n, n4) * f);
                    colorMapEntry.green = (byte)((float)TGALoader.getBitsAsByte(byArray, n + n4, n4) * f);
                    colorMapEntry.blue = (byte)((float)TGALoader.getBitsAsByte(byArray, n + 2 * n4, n4) * f);
                    colorMapEntry.alpha = n3 <= 0 ? (byte)-1 : (byte)((float)TGALoader.getBitsAsByte(byArray, n + 3 * n4, n3) * f2);
                    colorMapEntryArray[n2] = colorMapEntry;
                }
            }
        }
        byte[] byArray = null;
        if (n11 == 32 || bl2) {
            byArray = new byte[n10 * s * 4];
            n4 = 4;
        } else {
            byArray = new byte[n10 * s * 3];
            n4 = 3;
        }
        int n14 = 0;
        if (n7 == 2) {
            n3 = 0;
            byte by = 0;
            byte by2 = 0;
            n2 = 0;
            if (n11 == 16) {
                byte[] byArray2 = new byte[2];
                float f = 8.225806f;
                for (int i = 0; i <= s - 1; ++i) {
                    if (!bl) {
                        n14 = (s - 1 - i) * n10 * n4;
                    }
                    for (int j = 0; j < n10; ++j) {
                        byArray2[1] = dataInputStream.readByte();
                        byArray2[0] = dataInputStream.readByte();
                        byArray[n14++] = (byte)((float)TGALoader.getBitsAsByte(byArray2, 1, 5) * f);
                        byArray[n14++] = (byte)((float)TGALoader.getBitsAsByte(byArray2, 6, 5) * f);
                        byArray[n14++] = (byte)((float)TGALoader.getBitsAsByte(byArray2, 11, 5) * f);
                        if (n4 != 4) continue;
                        n2 = TGALoader.getBitsAsByte(byArray2, 0, 1);
                        if (n2 == 1) {
                            n2 = -1;
                        }
                        byArray[n14++] = n2;
                    }
                }
            } else if (n11 == 24) {
                void var23_36;
                boolean bl6 = false;
                while (var23_36 <= s - 1) {
                    if (!bl) {
                        n14 = (s - 1 - var23_36) * n10 * n4;
                    }
                    for (n = 0; n < n10; ++n) {
                        by2 = dataInputStream.readByte();
                        by = dataInputStream.readByte();
                        n3 = dataInputStream.readByte();
                        byArray[n14++] = n3;
                        byArray[n14++] = by;
                        byArray[n14++] = by2;
                        if (n4 != 4) continue;
                        byArray[n14++] = -1;
                    }
                    ++var23_36;
                }
            } else {
                void var23_38;
                if (n11 != 32) throw new JmeException("Unsupported TGA true color depth: " + n11);
                boolean bl7 = false;
                while (var23_38 <= s - 1) {
                    if (!bl) {
                        n14 = (s - 1 - var23_38) * n10 * n4;
                    }
                    for (n = 0; n < n10; ++n) {
                        by2 = dataInputStream.readByte();
                        by = dataInputStream.readByte();
                        n3 = dataInputStream.readByte();
                        n2 = dataInputStream.readByte();
                        byArray[n14++] = n3;
                        byArray[n14++] = by;
                        byArray[n14++] = by2;
                        byArray[n14++] = n2;
                    }
                    ++var23_38;
                }
            }
        } else if (n7 == 1) {
            n3 = n11 / 8;
            if (n3 == 1) {
                for (int i = 0; i <= s - 1; ++i) {
                    if (!bl) {
                        n14 = (s - 1 - i) * n10 * n4;
                    }
                    for (int j = 0; j < n10; ++j) {
                        n2 = dataInputStream.readUnsignedByte();
                        if (n2 >= colorMapEntryArray.length || n2 < 0) {
                            throw new JmeException("TGA: Invalid color map entry referenced: " + n2);
                        }
                        ColorMapEntry colorMapEntry = colorMapEntryArray[n2];
                        byArray[n14++] = colorMapEntry.red;
                        byArray[n14++] = colorMapEntry.green;
                        byArray[n14++] = colorMapEntry.blue;
                        if (n4 != 4) continue;
                        byArray[n14++] = colorMapEntry.alpha;
                    }
                }
            } else {
                if (n3 != 2) throw new JmeException("TGA: unknown colormap indexing size used: " + n3);
                for (int i = 0; i <= s - 1; ++i) {
                    if (!bl) {
                        n14 = (s - 1 - i) * n10 * n4;
                    }
                    for (int j = 0; j < n10; ++j) {
                        n2 = TGALoader.flipEndian(dataInputStream.readShort());
                        if (n2 >= colorMapEntryArray.length || n2 < 0) {
                            throw new JmeException("TGA: Invalid color map entry referenced: " + n2);
                        }
                        ColorMapEntry colorMapEntry = colorMapEntryArray[n2];
                        byArray[n14++] = colorMapEntry.red;
                        byArray[n14++] = colorMapEntry.green;
                        byArray[n14++] = colorMapEntry.blue;
                        if (n4 != 4) continue;
                        byArray[n14++] = colorMapEntry.alpha;
                    }
                }
            }
        }
        inputStream.close();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.clear();
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        Image image = new Image();
        if (n4 == 4) {
            image.setType(3);
        } else {
            image.setType(1);
        }
        image.setWidth(n10);
        image.setHeight(s);
        image.setData(byteBuffer);
        return image;
    }

    private static byte getBitsAsByte(byte[] byArray, int n, int n2) {
        int n3 = n / 8;
        int n4 = n % 8;
        int n5 = 0;
        int n6 = n2;
        while (--n6 >= 0) {
            int n7;
            byte by = byArray[n3];
            int n8 = n7 = n4 == 7 ? 1 : 2 << 6 - n4;
            if ((by & n7) != 0) {
                n5 = n6 == 0 ? ++n5 : (n5 += 2 << n6 - 1);
            }
            if (++n4 != 8) continue;
            n4 = 0;
            ++n3;
        }
        return (byte)n5;
    }

    private static short flipEndian(short s) {
        int n = s & 0xFFFF;
        return (short)(n << 8 | (n & 0xFF00) >>> 8);
    }

    static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }
}

