/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.keyboard;

import com.jme.input.ActionTrigger;
import com.jme.input.InputHandler;
import com.jme.input.InputHandlerDevice;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.keyboard.TriggersKeyboardInputListener;

public class KeyboardInputHandlerDevice
extends InputHandlerDevice {
    private TriggersKeyboardInputListener keyboardListener;

    public KeyboardInputHandlerDevice() {
        super("keyboard");
    }

    protected void createTriggers(InputActionInterface inputActionInterface, int n, int n2, boolean bl, InputHandler inputHandler) {
        new KeyTrigger(inputHandler, "key", inputActionInterface, n2, bl);
        if (n != -1) {
            // empty if block
        }
    }

    public synchronized TriggersKeyboardInputListener getKeyboardListener() {
        if (this.keyboardListener == null) {
            this.keyboardListener = new TriggersKeyboardInputListener();
            this.keyboardListener.activate();
        }
        return this.keyboardListener;
    }

    protected class KeyTrigger
    extends ActionTrigger {
        private final int keyCode;
        private int activations;
        private char[] chars;
        private int[] keyCodes;
        private boolean[] pressed;

        public KeyTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, int n, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.activations = 0;
            this.chars = new char[1];
            this.keyCodes = new int[1];
            this.pressed = new boolean[1];
            this.keyCode = n;
            KeyboardInputHandlerDevice.this.getKeyboardListener().add(this);
        }

        protected void remove() {
            super.remove();
            KeyboardInputHandlerDevice.this.getKeyboardListener().remove(this);
        }

        protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
            super.putTriggerInfo(inputActionEvent, n);
            inputActionEvent.setTriggerIndex(this.keyCodes[n]);
            inputActionEvent.setTriggerPressed(this.pressed[n]);
            inputActionEvent.setTriggerCharacter(this.chars[n]);
        }

        public synchronized void performAction(InputActionEvent inputActionEvent) {
            super.performAction(inputActionEvent);
            if (!this.allowRepeats) {
                this.activations = 0;
            }
        }

        protected int getActionInvocationCount() {
            return this.activations;
        }

        protected String getDeviceName() {
            return "keyboard";
        }

        public synchronized void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
            if (n == this.keyCode || this.keyCode == Integer.MIN_VALUE) {
                if (!this.inputHandler.isEnabled()) {
                    return;
                }
                int n2 = this.activations;
                char[] cArray = this.chars;
                if (bl || !this.allowRepeats) {
                    if (n2 == cArray.length) {
                        char[] cArray2 = new char[n2 + 3];
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        cArray = cArray2;
                        this.chars = cArray2;
                        int[] nArray = new int[n2 + 3];
                        System.arraycopy(this.keyCodes, 0, nArray, 0, n2);
                        this.keyCodes = nArray;
                        boolean[] blArray = new boolean[n2 + 3];
                        System.arraycopy(this.pressed, 0, blArray, 0, n2);
                        this.pressed = blArray;
                    }
                    cArray[n2] = c;
                    this.keyCodes[n2] = n;
                }
                if (this.allowRepeats) {
                    if (bl) {
                        this.pressed[n2] = true;
                        this.activate();
                        this.activations = n2 + 1;
                    } else if (n2 <= 1) {
                        this.pressed[0] = false;
                        this.activations = 0;
                        this.deactivate();
                    } else {
                        int n3 = 0;
                        for (int i = 0; i < this.keyCodes.length; ++i) {
                            if (this.keyCodes[i] != n) {
                                if (n3 != i) {
                                    this.keyCodes[n3] = this.keyCodes[i];
                                    cArray[n3] = cArray[i];
                                }
                                ++n3;
                                continue;
                            }
                            this.activations = n2 - 1;
                        }
                    }
                } else {
                    this.pressed[n2] = bl;
                    this.activate();
                    this.activations = n2 + 1;
                }
            }
        }
    }
}

