/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.lwjgl;

import com.jme.image.Image;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import com.jme.system.lwjgl.LWJGLStandardCursor;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.Hashtable;
import java.util.logging.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class LWJGLMouseInput
extends MouseInput {
    private static Hashtable<URL, Cursor> loadedCursors;
    private int dx;
    private int dy;
    private int lastX;
    private int lastY;
    private boolean virgin = true;
    private int dWheel;
    private int wheelRotation;

    protected LWJGLMouseInput() {
        try {
            Mouse.create();
            this.setCursorVisible(false);
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.WARNING, "Problem during creation of Mouse.", exception);
        }
    }

    public void destroy() {
        this.setCursorVisible(false);
        Mouse.destroy();
    }

    public int getButtonIndex(String string) {
        return Mouse.getButtonIndex((String)string);
    }

    public String getButtonName(int n) {
        return Mouse.getButtonName((int)n);
    }

    public boolean isButtonDown(int n) {
        return Mouse.isButtonDown((int)n);
    }

    public int getWheelDelta() {
        return this.dWheel;
    }

    public int getXDelta() {
        return this.dx;
    }

    public int getYDelta() {
        return this.dy;
    }

    public int getXAbsolute() {
        return Mouse.getX();
    }

    public int getYAbsolute() {
        return Mouse.getY();
    }

    public void update() {
        int n;
        int n2;
        boolean bl = Mouse.isGrabbed();
        if (bl) {
            this.dx = Mouse.getDX();
            this.dy = Mouse.getDY();
            n2 = Mouse.getX();
            n = Mouse.getY();
        } else {
            n2 = Mouse.getEventX();
            n = Mouse.getEventY();
            this.dx = n2 - this.lastX;
            this.dy = n - this.lastY;
            this.lastX = n2;
            this.lastY = n;
        }
        if (this.virgin && (this.dx != 0 || this.dy != 0)) {
            this.dy = 0;
            this.dx = 0;
            this.wheelRotation = 0;
            this.virgin = false;
        }
        this.dWheel = Mouse.getDWheel();
        this.wheelRotation += this.dWheel;
        if (this.listeners != null && this.listeners.size() > 0) {
            while (Mouse.next()) {
                int n3 = Mouse.getEventButton();
                boolean bl2 = n3 >= 0 && Mouse.getEventButtonState();
                int n4 = Mouse.getEventDWheel();
                int n5 = Mouse.getEventDX();
                int n6 = Mouse.getEventDY();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    MouseInputListener mouseInputListener = (MouseInputListener)this.listeners.get(i);
                    if (n3 >= 0) {
                        mouseInputListener.onButton(n3, bl2, n2, n);
                    }
                    if (n4 != 0) {
                        mouseInputListener.onWheel(n4, n2, n);
                    }
                    if (n5 == 0 && n6 == 0) continue;
                    mouseInputListener.onMove(n5, n6, n2, n);
                }
            }
        } else {
            while (Mouse.next()) {
            }
        }
    }

    public void setCursorVisible(boolean bl) {
        Mouse.setGrabbed((!bl ? 1 : 0) != 0);
        try {
            if (bl) {
                Mouse.setNativeCursor((Cursor)LWJGLStandardCursor.cursor);
            } else {
                Mouse.setNativeCursor(null);
            }
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.WARNING, "Problem showing mouse cursor.");
        }
    }

    public boolean isCursorVisible() {
        return Mouse.getNativeCursor() != null;
    }

    public void setHardwareCursor(URL uRL) {
        this.setHardwareCursor(uRL, -1, -1);
    }

    public void setHardwareCursor(URL uRL, int n, int n2) {
        Mouse.setGrabbed((boolean)false);
        if (loadedCursors == null) {
            loadedCursors = new Hashtable();
        }
        Cursor cursor = null;
        if (loadedCursors.containsKey(uRL)) {
            cursor = loadedCursors.get(uRL);
        } else {
            Image image = TextureManager.loadImage(uRL, true);
            IntBuffer intBuffer = image.getData().asIntBuffer();
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)intBuffer.remaining());
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = i * n3 + j;
                    int n6 = intBuffer.get(n5);
                    int n7 = n6 >> 24 & 0xFF;
                    n7 = n7 < 127 ? 0 : 255;
                    int n8 = n6 >> 16 & 0xFF;
                    int n9 = n6 >> 8 & 0xFF;
                    int n10 = n6 & 0xFF;
                    intBuffer2.put(n5, n7 << 24 | n10 << 16 | n9 << 8 | n8);
                }
            }
            if (n < 0 || n2 < 0 || n >= n3 || n2 >= n4) {
                n = 0;
                n2 = n4 - 1;
                LoggingSystem.getLogger().log(Level.WARNING, "Hotspot positions are outside image bounds!");
            }
            try {
                cursor = new Cursor(n3, n4, n, n2, 1, intBuffer2, null);
            }
            catch (LWJGLException lWJGLException) {
                LoggingSystem.getLogger().log(Level.WARNING, "Failed creating native cursor!", lWJGLException);
            }
            loadedCursors.put(uRL, cursor);
        }
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (LWJGLException lWJGLException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Failed setting native cursor!", lWJGLException);
        }
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    public int getButtonCount() {
        return Mouse.getButtonCount();
    }

    public void setCursorPosition(int n, int n2) {
        Mouse.setCursorPosition((int)n, (int)n2);
    }
}

