/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;

public class TransformMatrix
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private Matrix3f rot = new Matrix3f();
    private Vector3f translation = new Vector3f();
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public TransformMatrix() {
    }

    public TransformMatrix(TransformMatrix transformMatrix) {
        this.set(transformMatrix);
    }

    public TransformMatrix(Quaternion quaternion, Vector3f vector3f) {
        this.rot.set(quaternion);
        this.translation.set(vector3f);
    }

    public void set(TransformMatrix transformMatrix) {
        if (transformMatrix == null) {
            this.loadIdentity();
        } else {
            this.rot.copy(transformMatrix.rot);
            this.translation.set(transformMatrix.translation);
            this.scale.set(transformMatrix.scale);
        }
    }

    public void set(Quaternion quaternion) {
        this.rot.set(quaternion);
        this.translation.zero();
        this.scale.set(1.0f, 1.0f, 1.0f);
    }

    public void loadIdentity() {
        this.rot.loadIdentity();
        this.translation.zero();
        this.scale.set(1.0f, 1.0f, 1.0f);
    }

    public void mult(float f) {
        this.rot.multLocal(f);
        this.translation.mult(f);
        this.scale.multLocal(f);
    }

    public TransformMatrix multLocal(TransformMatrix transformMatrix, Vector3f vector3f) {
        this.scale.multLocal(transformMatrix.scale);
        this.translation.addLocal(this.rot.mult(transformMatrix.translation, vector3f).multLocal(transformMatrix.scale));
        this.rot.multLocal(transformMatrix.rot);
        return this;
    }

    public void interpolateTransforms(TransformMatrix transformMatrix, TransformMatrix transformMatrix2, float f) {
        this.translation.set(transformMatrix.translation).interpolate(transformMatrix2.translation, f);
        this.scale.set(transformMatrix.scale).interpolate(transformMatrix2.scale, f);
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        transformMatrix.getRotation(quaternion);
        transformMatrix2.getRotation(quaternion2);
        quaternion.slerp(quaternion2, f);
        this.setRotationQuaternion(quaternion);
    }

    public void interpolateTransforms(TransformMatrix transformMatrix, TransformMatrix transformMatrix2, float f, Quaternion quaternion, Quaternion quaternion2) {
        this.translation.set(transformMatrix.translation).interpolate(transformMatrix2.translation, f);
        this.scale.set(transformMatrix.scale).interpolate(transformMatrix2.scale, f);
        transformMatrix.getRotation(quaternion);
        transformMatrix2.getRotation(quaternion2);
        quaternion.slerp(quaternion2, f);
        this.setRotationQuaternion(quaternion);
    }

    public Vector3f multNormal(Vector3f vector3f) {
        if (null == vector3f) {
            LoggingSystem.getLogger().log(Level.WARNING, "Source vector is null, null result returned.");
            return null;
        }
        return this.rot.multLocal(vector3f);
    }

    public Vector3f multPoint(Vector3f vector3f) {
        if (null == vector3f) {
            LoggingSystem.getLogger().log(Level.WARNING, "Source vector is null, null result returned.");
            return null;
        }
        return this.rot.multLocal(vector3f).multLocal(this.scale).addLocal(this.translation);
    }

    public void setRotation(Matrix3f matrix3f) {
        this.rot.copy(matrix3f);
    }

    public void setTranslation(float[] fArray) {
        if (fArray == null || fArray.length != 3) {
            throw new JmeException("Translation size must be 3.");
        }
        this.translation.x = fArray[0];
        this.translation.y = fArray[1];
        this.translation.z = fArray[2];
    }

    public void setTranslation(Vector3f vector3f) {
        if (vector3f == null) {
            throw new JmeException("Vector3f translation must be non-null");
        }
        this.translation.set(vector3f);
    }

    public void setTranslation(float f, float f2, float f3) {
        this.translation.set(f, f2, f3);
    }

    public void setEulerRot(float f, float f2, float f3) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        double d3 = Math.cos(f2);
        double d4 = Math.sin(f2);
        double d5 = Math.cos(f3);
        double d6 = Math.sin(f3);
        double d7 = d * d4;
        double d8 = d2 * d4;
        this.rot.m00 = (float)(d3 * d5);
        this.rot.m01 = (float)(d8 * d5 + -(d * d6));
        this.rot.m02 = (float)(d7 * d5 + d2 * d6);
        this.rot.m10 = (float)(d3 * d6);
        this.rot.m11 = (float)(d8 * d6 + d * d5);
        this.rot.m12 = (float)(d7 * d6 + -(d2 * d5));
        this.rot.m20 = (float)(-d4);
        this.rot.m21 = (float)(d2 * d3);
        this.rot.m22 = (float)(d * d3);
    }

    public void setRotationQuaternion(Quaternion quaternion) {
        if (null == quaternion) {
            throw new JmeException("Quat may not be null.");
        }
        this.rot.set(quaternion);
    }

    private void invertRotInPlace() {
        float f = this.rot.m01;
        this.rot.m01 = this.rot.m10;
        this.rot.m10 = f;
        f = this.rot.m02;
        this.rot.m02 = this.rot.m20;
        this.rot.m20 = f;
        f = this.rot.m21;
        this.rot.m21 = this.rot.m12;
        this.rot.m12 = f;
    }

    public Matrix3f getRotation(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        matrix3f.copy(this.rot);
        return matrix3f;
    }

    public Vector3f getTranslation(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.translation);
        return vector3f;
    }

    public Quaternion getRotation(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        quaternion.fromRotationMatrix(this.rot);
        return quaternion;
    }

    public String toString() {
        return "com.jme.math.TransformMatrix\n[\n" + this.rot.toString() + ":" + this.translation.toString() + ":" + this.scale.toString();
    }

    public void inverse() {
        this.invertRotInPlace();
        this.rot.multLocal(this.translation);
        this.translation.multLocal(-1.0f);
        this.scale.set(1.0f / this.scale.x, 1.0f / this.scale.y, 1.0f / this.scale.z);
    }

    public void setEulerRot(Vector3f vector3f) {
        this.setEulerRot(vector3f.x, vector3f.y, vector3f.z);
    }

    public void set(Quaternion quaternion, Vector3f vector3f) {
        this.set(quaternion);
        this.setTranslation(vector3f);
    }

    public void setScale(Vector3f vector3f) {
        this.scale.set(vector3f);
    }

    public void setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
    }

    public Vector3f getScale(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        return vector3f.set(this.scale);
    }

    public void applyToSpatial(Spatial spatial) {
        spatial.setLocalTranslation(this.translation);
        spatial.setLocalRotation(this.rot);
        spatial.setLocalScale(this.scale);
    }

    public TransformMatrix combineWithParent(TransformMatrix transformMatrix) {
        this.scale.multLocal(transformMatrix.scale);
        this.rot.multLocal(transformMatrix.rot);
        transformMatrix.rot.multLocal(this.translation).multLocal(transformMatrix.scale).addLocal(transformMatrix.translation);
        return this;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.rot, "rot", new Matrix3f());
        outputCapsule.write(this.translation, "translation", Vector3f.ZERO);
        outputCapsule.write(this.scale, "scale", Vector3f.UNIT_XYZ);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.rot = (Matrix3f)inputCapsule.readSavable("rot", new Matrix3f());
        this.translation = (Vector3f)inputCapsule.readSavable("translation", new Vector3f(Vector3f.ZERO));
        this.scale = (Vector3f)inputCapsule.readSavable("scale", new Vector3f(Vector3f.UNIT_XYZ));
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

