/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.renderer.Renderer;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.lwjgl.records.StateRecord;

public class RenderContext {
    public RenderState[] enforcedStateList = new RenderState[17];
    public RenderState[] currentStates = new RenderState[17];
    StateRecord[] records = new StateRecord[17];
    StateRecord lineRecord = null;

    public void setupRecords(Renderer renderer) {
        for (int i = 0; i < 17; ++i) {
            this.records[i] = renderer.createState(i).createStateRecord();
        }
        this.lineRecord = renderer.createLineRecord();
    }

    public void invalidateStates() {
        for (int i = 0; i < 17; ++i) {
            this.records[i].invalidate();
        }
        this.lineRecord.invalidate();
        this.clearCurrentStates();
    }

    public StateRecord getStateRecord(int n) {
        return this.records[n];
    }

    public StateRecord getLineRecord() {
        return this.lineRecord;
    }

    public void enforceState(RenderState renderState) {
        this.enforcedStateList[renderState.getType()] = renderState;
    }

    public void clearEnforcedState(int n) {
        if (this.enforcedStateList != null) {
            this.enforcedStateList[n] = null;
        }
    }

    public void clearEnforcedStates() {
        for (int i = 0; i < this.enforcedStateList.length; ++i) {
            this.enforcedStateList[i] = null;
        }
    }

    public void clearCurrentStates() {
        for (int i = 0; i < this.currentStates.length; ++i) {
            this.currentStates[i] = null;
        }
    }

    public void clearCurrentState(int n) {
        this.currentStates[n] = null;
    }

    public RenderState getCurrentState(int n) {
        return this.currentStates[n];
    }
}

