/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer;

import com.jme.curve.Curve;
import com.jme.renderer.AbstractCamera;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderQueue;
import com.jme.renderer.RenderStatistics;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.LineBatch;
import com.jme.scene.batch.PointBatch;
import com.jme.scene.batch.QuadBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.AttributeState;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.ColorMaskState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.DitherState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.FragmentProgramState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ShadeState;
import com.jme.scene.state.StencilState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.VertexProgramState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.scene.state.lwjgl.records.StateRecord;
import java.nio.Buffer;
import java.nio.IntBuffer;

public abstract class Renderer {
    public static final int QUEUE_INHERIT = 0;
    public static final int QUEUE_SKIP = 1;
    public static final int QUEUE_OPAQUE = 2;
    public static final int QUEUE_TRANSPARENT = 3;
    public static final int QUEUE_ORTHO = 4;
    protected AbstractCamera camera;
    protected ColorRGBA backgroundColor;
    protected boolean processingQueue;
    protected RenderQueue queue;
    protected RenderStatistics stats;
    protected boolean statisticsOn;
    private boolean headless = false;
    protected int width;
    protected int height;
    public static final RenderState[] defaultStateList = new RenderState[17];

    public abstract void setCamera(Camera var1);

    public Camera getCamera() {
        return this.camera;
    }

    public abstract Camera createCamera(int var1, int var2);

    public abstract AlphaState createAlphaState();

    public abstract AttributeState createAttributeState();

    public abstract CullState createCullState();

    public abstract DitherState createDitherState();

    public abstract FogState createFogState();

    public abstract LightState createLightState();

    public abstract MaterialState createMaterialState();

    public abstract ShadeState createShadeState();

    public abstract TextureState createTextureState();

    public abstract WireframeState createWireframeState();

    public abstract ZBufferState createZBufferState();

    public abstract VertexProgramState createVertexProgramState();

    public abstract FragmentProgramState createFragmentProgramState();

    public abstract GLSLShaderObjectsState createGLSLShaderObjectsState();

    public abstract StencilState createStencilState();

    public abstract ClipState createClipState();

    public abstract ColorMaskState createColorMaskState();

    public void enableStatistics(boolean bl) {
        this.statisticsOn = bl;
        if (this.stats == null && this.statisticsOn) {
            this.stats = new RenderStatistics();
        }
    }

    public void clearStatistics() {
        if (this.stats != null) {
            this.stats.clearStatistics();
        }
    }

    public RenderStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(RenderStatistics renderStatistics) {
        this.stats = renderStatistics;
    }

    public StringBuffer getStatistics(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        if (this.stats != null) {
            this.stats.append(stringBuffer);
        }
        return stringBuffer;
    }

    public abstract void setBackgroundColor(ColorRGBA var1);

    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public abstract void clearZBuffer();

    public abstract void clearColorBuffer();

    public abstract void clearStencilBuffer();

    public abstract void clearBuffers();

    public abstract void clearStrictBuffers();

    public abstract void displayBackBuffer();

    public abstract void setOrtho();

    public void renderQueue() {
        this.processingQueue = true;
        this.queue.renderBuckets();
        this.processingQueue = false;
    }

    public void clearQueue() {
        this.queue.clearBuckets();
    }

    public abstract void setOrthoCenter();

    public abstract void unsetOrtho();

    public abstract boolean takeScreenShot(String var1);

    public abstract void grabScreenContents(IntBuffer var1, int var2, int var3, int var4, int var5);

    public abstract void draw(Spatial var1);

    public abstract void draw(TriangleBatch var1);

    public abstract void draw(QuadBatch var1);

    public abstract void draw(PointBatch var1);

    public abstract void draw(LineBatch var1);

    public abstract void draw(Curve var1);

    public abstract void draw(Text var1);

    public abstract void flush();

    public abstract void finish();

    public RenderQueue getQueue() {
        return this.queue;
    }

    public boolean isProcessingQueue() {
        return this.processingQueue;
    }

    public abstract boolean checkAndAdd(SceneElement var1);

    public abstract boolean supportsVBO();

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean bl) {
        this.headless = bl;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void reinit(int var1, int var2);

    public abstract int createDisplayList(GeomBatch var1);

    public abstract void releaseDisplayList(int var1);

    public abstract void setPolygonOffset(float var1, float var2);

    public abstract void clearPolygonOffset();

    public abstract void deleteVBO(Buffer var1);

    public abstract void deleteVBO(int var1);

    public abstract void clearVBOCache();

    public abstract Integer removeFromVBOCache(Buffer var1);

    public RenderState createState(int n) {
        switch (n) {
            case 0: {
                return this.createAlphaState();
            }
            case 12: {
                return this.createAttributeState();
            }
            case 16: {
                return this.createClipState();
            }
            case 15: {
                return this.createColorMaskState();
            }
            case 9: {
                return this.createCullState();
            }
            case 1: {
                return this.createDitherState();
            }
            case 2: {
                return this.createFogState();
            }
            case 11: {
                return this.createFragmentProgramState();
            }
            case 14: {
                return this.createGLSLShaderObjectsState();
            }
            case 3: {
                return this.createLightState();
            }
            case 4: {
                return this.createMaterialState();
            }
            case 5: {
                return this.createShadeState();
            }
            case 13: {
                return this.createStencilState();
            }
            case 6: {
                return this.createTextureState();
            }
            case 10: {
                return this.createVertexProgramState();
            }
            case 7: {
                return this.createWireframeState();
            }
            case 8: {
                return this.createZBufferState();
            }
        }
        return null;
    }

    public abstract StateRecord createLineRecord();
}

