/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.math.Matrix4f;
import com.jme.renderer.AbstractCamera;
import com.jme.renderer.lwjgl.LWJGLTextureRenderer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;

public class LWJGLCamera
extends AbstractCamera {
    private static final long serialVersionUID = 1L;
    private boolean frustumDirty;
    private boolean viewPortDirty;
    private boolean frameDirty;
    private static final FloatBuffer tmp_FloatBuffer = BufferUtils.createFloatBuffer((int)16);
    private Matrix4f projection;
    private Matrix4f modelView;

    public LWJGLCamera() {
    }

    public LWJGLCamera(int n, int n2, Object object) {
        this.width = n;
        this.height = n2;
        this.parent = object;
        this.parentClass = object.getClass();
        this.update();
        this.apply();
    }

    public LWJGLCamera(int n, int n2, Object object, boolean bl) {
        super(bl);
        this.width = n;
        this.height = n2;
        this.parent = object;
        this.parentClass = object.getClass();
        this.setDataOnly(bl);
        this.update();
        this.apply();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.onViewPortChange();
    }

    public void update() {
        super.update();
    }

    public void apply() {
        if (this.frustumDirty) {
            this.doFrustumChange();
            this.frustumDirty = false;
        }
        if (this.viewPortDirty) {
            this.doViewPortChange();
            this.viewPortDirty = false;
        }
        if (this.frameDirty) {
            this.doFrameChange();
            this.frameDirty = false;
        }
    }

    public void onFrustumChange() {
        super.onFrustumChange();
        this.frustumDirty = true;
    }

    public void onViewPortChange() {
        this.viewPortDirty = true;
    }

    public void onFrameChange() {
        super.onFrameChange();
        this.frameDirty = true;
    }

    public void doFrustumChange() {
        if (this.parentClass == LWJGLTextureRenderer.class && ((LWJGLTextureRenderer)this.parent).getParentRenderer().getCamera() != this) {
            return;
        }
        if (!this.isDataOnly()) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            if (!this.isParallelProjection()) {
                GL11.glFrustum((double)this.frustumLeft, (double)this.frustumRight, (double)this.frustumBottom, (double)this.frustumTop, (double)this.frustumNear, (double)this.frustumFar);
            } else {
                GL11.glOrtho((double)this.frustumLeft, (double)this.frustumRight, (double)this.frustumTop, (double)this.frustumBottom, (double)this.frustumNear, (double)this.frustumFar);
            }
            if (this.projection != null) {
                tmp_FloatBuffer.rewind();
                GL11.glGetFloat((int)2983, (FloatBuffer)tmp_FloatBuffer);
                tmp_FloatBuffer.rewind();
                this.projection.readFloatBuffer(tmp_FloatBuffer);
            }
        }
    }

    public void doViewPortChange() {
        if (this.parentClass == LWJGLTextureRenderer.class && ((LWJGLTextureRenderer)this.parent).getParentRenderer().getCamera() != this) {
            return;
        }
        if (!this.isDataOnly()) {
            int n = (int)(this.viewPortLeft * (float)this.width);
            int n2 = (int)(this.viewPortBottom * (float)this.height);
            int n3 = (int)((this.viewPortRight - this.viewPortLeft) * (float)this.width);
            int n4 = (int)((this.viewPortTop - this.viewPortBottom) * (float)this.height);
            GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
        }
    }

    public void doFrameChange() {
        super.onFrameChange();
        if (this.parentClass == LWJGLTextureRenderer.class && ((LWJGLTextureRenderer)this.parent).getParentRenderer().getCamera() != this) {
            return;
        }
        if (!this.isDataOnly()) {
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GLU.gluLookAt((float)this.location.x, (float)this.location.y, (float)this.location.z, (float)(this.location.x + this.direction.x), (float)(this.location.y + this.direction.y), (float)(this.location.z + this.direction.z), (float)this.up.x, (float)this.up.y, (float)this.up.z);
            if (this.modelView != null) {
                tmp_FloatBuffer.rewind();
                GL11.glGetFloat((int)2982, (FloatBuffer)tmp_FloatBuffer);
                tmp_FloatBuffer.rewind();
                this.modelView.readFloatBuffer(tmp_FloatBuffer);
            }
        }
    }

    public Matrix4f getProjectionMatrix() {
        if (this.projection == null) {
            this.projection = new Matrix4f();
            this.onFrustumChange();
        }
        this.apply();
        return this.projection;
    }

    public Matrix4f getModelViewMatrix() {
        if (this.modelView == null) {
            this.modelView = new Matrix4f();
            this.onFrameChange();
        }
        this.apply();
        return this.modelView;
    }
}

