/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.lwjgl.LWJGLCamera;
import com.jme.renderer.lwjgl.LWJGLRenderer;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.lwjgl.LWJGLDisplaySystem;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import com.jmex.awt.lwjgl.LWJGLCanvas;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWJGLPbufferTextureRenderer
implements TextureRenderer {
    private LWJGLCamera camera;
    private ColorRGBA backgroundColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private int pBufferWidth = 16;
    private int pBufferHeight = 16;
    private Pbuffer pbuffer;
    private int active;
    private int caps;
    private boolean useDirectRender = false;
    private boolean isSupported = true;
    private LWJGLRenderer parentRenderer;
    private RenderTexture texture;
    private LWJGLDisplaySystem display;
    private boolean headless = false;
    private int bpp;
    private int alpha;
    private int depth;
    private int stencil;
    private int samples;
    private Camera oldCamera;
    private int oldWidth;
    private int oldHeight;

    public LWJGLPbufferTextureRenderer(int n, int n2, LWJGLRenderer lWJGLRenderer, RenderTexture renderTexture) {
        this(n, n2, lWJGLRenderer, renderTexture, DisplaySystem.getDisplaySystem().getBitDepth(), DisplaySystem.getDisplaySystem().getMinAlphaBits(), DisplaySystem.getDisplaySystem().getMinDepthBits(), DisplaySystem.getDisplaySystem().getMinStencilBits(), DisplaySystem.getDisplaySystem().getMinSamples());
    }

    public LWJGLPbufferTextureRenderer(int n, int n2, LWJGLRenderer lWJGLRenderer, RenderTexture renderTexture, int n3, int n4, int n5, int n6, int n7) {
        this.bpp = n3;
        this.alpha = n4;
        this.depth = n5;
        this.stencil = n6;
        this.samples = n7;
        this.caps = Pbuffer.getCapabilities();
        if ((this.caps & 1) != 0) {
            int n8;
            this.isSupported = true;
            if (!FastMath.isPowerOfTwo(n)) {
                n8 = 2;
                while ((n8 <<= 1) < n) {
                }
                n = n8;
            }
            if (!FastMath.isPowerOfTwo(n2)) {
                n8 = 2;
                while ((n8 <<= 1) < n2) {
                }
                n2 = n8;
            }
            if (n > 0) {
                this.pBufferWidth = n;
            }
            if (n2 > 0) {
                this.pBufferHeight = n2;
            }
            this.texture = renderTexture;
            this.forceCopy(false);
            this.validateForCopy();
            if (this.pBufferWidth != this.pBufferHeight && (this.caps & 4) == 0) {
                this.pBufferWidth = this.pBufferHeight = Math.max(n, n2);
            }
            this.parentRenderer = lWJGLRenderer;
            this.display = (LWJGLDisplaySystem)DisplaySystem.getDisplaySystem();
            this.initPbuffer();
        } else {
            this.isSupported = false;
        }
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = (LWJGLCamera)camera;
    }

    @Override
    public void setBackgroundColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.backgroundColor.a = 1.0f;
            this.backgroundColor.b = 1.0f;
            this.backgroundColor.g = 1.0f;
            this.backgroundColor.r = 1.0f;
        } else {
            this.backgroundColor = colorRGBA;
        }
        if (!this.isSupported) {
            return;
        }
        this.activate();
        GL11.glClearColor((float)this.backgroundColor.r, (float)this.backgroundColor.g, (float)this.backgroundColor.b, (float)this.backgroundColor.a);
        this.deactivate();
    }

    @Override
    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setupTexture(Texture texture) {
        this.setupTexture(texture, this.pBufferWidth, this.pBufferHeight);
    }

    public void setupTexture(Texture texture, int n, int n2) {
        if (!this.isSupported) {
            return;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        if (texture.getTextureId() != 0) {
            intBuffer.put(texture.getTextureId());
            GL11.glDeleteTextures((IntBuffer)intBuffer);
            intBuffer.clear();
        }
        GL11.glGenTextures((IntBuffer)intBuffer);
        texture.setTextureId(intBuffer.get(0));
        TextureManager.registerForCleanup(texture.getTextureKey(), texture.getTextureId());
        GL11.glBindTexture((int)3553, (int)texture.getTextureId());
        int n3 = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n3 = 6407;
                break;
            }
            case 5: {
                n3 = 6406;
                break;
            }
            case 2: {
                n3 = 6402;
                break;
            }
            case 6: {
                n3 = 32841;
                break;
            }
            case 3: {
                n3 = 6409;
                break;
            }
            case 4: {
                n3 = 6410;
            }
        }
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)n3, (int)0, (int)0, (int)n, (int)n2, (int)0);
        LoggingSystem.getLogger().info("setup tex" + texture.getTextureId() + ": " + n + "," + n2);
    }

    @Override
    public void render(Spatial spatial, Texture texture) {
        this.render(spatial, texture, true);
    }

    @Override
    public void render(Spatial spatial, Texture texture, boolean bl) {
        if (!this.isSupported) {
            return;
        }
        try {
            if (this.pbuffer.isBufferLost()) {
                LoggingSystem.getLogger().log(Level.WARNING, "PBuffer contents lost - will recreate the buffer");
                this.deactivate();
                this.pbuffer.destroy();
                this.initPbuffer();
            }
            if (spatial.getParent() != null) {
                spatial.getParent().setLastFrustumIntersection(1);
            }
            if (this.useDirectRender && texture.getRTTSource() != 2) {
                this.pbuffer.releaseTexImage(8323);
                this.activate();
                this.switchCameraIn();
                this.doDraw(spatial);
                this.switchCameraOut();
                this.deactivate();
                GL11.glBindTexture((int)3553, (int)texture.getTextureId());
                this.pbuffer.bindTexImage(8323);
            } else {
                this.activate();
                this.switchCameraIn();
                this.doDraw(spatial);
                this.switchCameraOut();
                this.copyToTexture(texture, this.pBufferWidth, this.pBufferHeight);
                this.deactivate();
            }
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().throwing(this.getClass().toString(), "render(Spatial, Texture)", exception);
        }
    }

    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2) {
        this.render(arrayList, arrayList2, true);
    }

    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2, boolean bl) {
        if (!this.isSupported) {
            return;
        }
        try {
            if (this.pbuffer.isBufferLost()) {
                LoggingSystem.getLogger().log(Level.WARNING, "PBuffer contents lost - will recreate the buffer");
                this.deactivate();
                this.pbuffer.destroy();
                this.initPbuffer();
            }
            if (arrayList2.size() == 1 && this.useDirectRender && arrayList2.get(0).getRTTSource() != 2) {
                GL11.glBindTexture((int)3553, (int)arrayList2.get(0).getTextureId());
                this.activate();
                this.switchCameraIn();
                this.pbuffer.releaseTexImage(8323);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Spatial spatial = arrayList.get(i);
                    if (spatial.getParent() != null) {
                        spatial.getParent().setLastFrustumIntersection(1);
                    }
                    this.doDraw(spatial);
                }
                this.switchCameraOut();
                this.deactivate();
                this.pbuffer.bindTexImage(8323);
            } else {
                int n;
                this.activate();
                this.switchCameraIn();
                int n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    Spatial spatial = arrayList.get(n);
                    if (spatial.getParent() != null) {
                        spatial.getParent().setLastFrustumIntersection(1);
                    }
                    this.doDraw(spatial);
                }
                this.switchCameraOut();
                for (n = 0; n < arrayList2.size(); ++n) {
                    this.copyToTexture(arrayList2.get(n), this.pBufferWidth, this.pBufferHeight);
                }
                this.deactivate();
            }
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().throwing(this.getClass().toString(), "render(Spatial, Texture)", exception);
        }
    }

    @Override
    public void copyToTexture(Texture texture, int n, int n2) {
        GL11.glBindTexture((int)3553, (int)texture.getTextureId());
        int n3 = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n3 = 6407;
                break;
            }
            case 5: {
                n3 = 6406;
                break;
            }
            case 2: {
                n3 = 6402;
                break;
            }
            case 6: {
                n3 = 32841;
                break;
            }
            case 3: {
                n3 = 6409;
                break;
            }
            case 4: {
                n3 = 6410;
            }
        }
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)n3, (int)0, (int)0, (int)n, (int)n2, (int)0);
    }

    @Override
    public void copyBufferToTexture(Texture texture, int n, int n2, int n3) {
        GL11.glReadBuffer((int)1029);
        GL11.glBindTexture((int)3553, (int)texture.getTextureId());
        int n4 = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n4 = 6407;
                break;
            }
            case 5: {
                n4 = 6406;
                break;
            }
            case 2: {
                n4 = 6402;
                break;
            }
            case 6: {
                n4 = 32841;
                break;
            }
            case 3: {
                n4 = 6409;
                break;
            }
            case 4: {
                n4 = 6410;
            }
        }
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)n4, (int)0, (int)0, (int)n, (int)n2, (int)0);
    }

    private void switchCameraIn() {
        this.oldCamera = this.parentRenderer.getCamera();
        this.oldWidth = this.parentRenderer.getWidth();
        this.oldHeight = this.parentRenderer.getHeight();
        this.parentRenderer.setCamera(this.getCamera());
        this.parentRenderer.clearBuffers();
        this.parentRenderer.getQueue().swapBuckets();
        this.parentRenderer.reinit(this.pBufferWidth, this.pBufferHeight);
    }

    private void switchCameraOut() {
        this.parentRenderer.setCamera(this.oldCamera);
        this.parentRenderer.reinit(this.oldWidth, this.oldHeight);
        this.parentRenderer.getQueue().swapBuckets();
    }

    private void doDraw(Spatial spatial) {
        spatial.onDraw(this.parentRenderer);
        this.parentRenderer.renderQueue();
    }

    private void initPbuffer() {
        if (!this.isSupported) {
            return;
        }
        try {
            this.pbuffer = new Pbuffer(this.pBufferWidth, this.pBufferHeight, new PixelFormat(this.bpp, this.alpha, this.depth, this.stencil, this.samples), this.texture, null);
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().throwing(this.getClass().toString(), "initPbuffer()", exception);
            if (this.texture != null && this.useDirectRender) {
                LoggingSystem.getLogger().log(Level.WARNING, "LWJGL reports this card supports Render to Texture, but fails to enact it.  Please report this to the LWJGL team.");
                LoggingSystem.getLogger().log(Level.WARNING, "Attempting to fall back to Copy Texture.");
                this.texture = null;
                this.useDirectRender = false;
                this.initPbuffer();
                return;
            }
            LoggingSystem.getLogger().log(Level.WARNING, "Failed to create Pbuffer.", exception);
            this.isSupported = false;
            return;
        }
        try {
            this.activate();
            this.pBufferWidth = this.pbuffer.getWidth();
            this.pBufferHeight = this.pbuffer.getHeight();
            GL11.glClearColor((float)this.backgroundColor.r, (float)this.backgroundColor.g, (float)this.backgroundColor.b, (float)this.backgroundColor.a);
            if (this.camera == null) {
                this.initCamera();
            }
            this.camera.update();
            this.deactivate();
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.WARNING, "Failed to initialize created Pbuffer.", exception);
            this.isSupported = false;
            return;
        }
    }

    public void activate() {
        if (!this.isSupported) {
            return;
        }
        if (this.active == 0) {
            try {
                this.pbuffer.makeCurrent();
                this.display.switchContext(this.pbuffer);
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
                throw new JmeException();
            }
        }
        ++this.active;
    }

    public void deactivate() {
        if (!this.isSupported) {
            return;
        }
        if (this.active == 1) {
            try {
                if (!this.headless && Display.isCreated()) {
                    Display.makeCurrent();
                    this.display.switchContext(this.display);
                } else if (this.display.getCurrentCanvas() != null) {
                    ((LWJGLCanvas)this.display.getCurrentCanvas()).makeCurrent();
                    this.display.switchContext(this.display.getCurrentCanvas());
                } else if (this.display.getHeadlessDisplay() != null) {
                    this.display.getHeadlessDisplay().makeCurrent();
                    this.display.switchContext(this.display.getHeadlessDisplay());
                }
                ((LWJGLRenderer)this.display.getRenderer()).reset();
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
                throw new JmeException();
            }
        }
        --this.active;
    }

    private void initCamera() {
        if (!this.isSupported) {
            return;
        }
        this.camera = new LWJGLCamera(this.pBufferWidth, this.pBufferHeight, this);
        this.camera.setFrustum(1.0f, 1000.0f, -0.5f, 0.5f, 0.5f, -0.5f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
    }

    @Override
    public void updateCamera() {
        if (!this.isSupported) {
            return;
        }
        this.activate();
        this.camera.update();
        this.deactivate();
    }

    @Override
    public void cleanup() {
        if (!this.isSupported) {
            return;
        }
        this.pbuffer.destroy();
    }

    private void validateForCopy() {
        if (this.pBufferWidth > DisplaySystem.getDisplaySystem().getWidth()) {
            this.pBufferWidth = DisplaySystem.getDisplaySystem().getWidth();
        }
        if (this.pBufferHeight > DisplaySystem.getDisplaySystem().getHeight()) {
            this.pBufferHeight = DisplaySystem.getDisplaySystem().getHeight();
        }
    }

    @Override
    public int getWidth() {
        return this.pBufferWidth;
    }

    @Override
    public int getHeight() {
        return this.pBufferHeight;
    }

    public void forceCopy(boolean bl) {
        if (bl) {
            this.useDirectRender = false;
        } else if ((this.caps & 2) != 0) {
            LoggingSystem.getLogger().log(Level.INFO, "Render to Texture Pbuffer supported!");
            if (this.texture == null) {
                LoggingSystem.getLogger().log(Level.INFO, "No RenderTexture used in init, falling back to Copy Texture PBuffer.");
            } else {
                this.useDirectRender = true;
            }
        } else {
            LoggingSystem.getLogger().log(Level.INFO, "Copy Texture Pbuffer supported!");
            this.texture = null;
        }
    }
}

