/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class ImposterNode
extends Node {
    private static final float DEFAULT_DISTANCE = 10.0f;
    private static final float DEFAULT_RATE = 0.05f;
    private static final long serialVersionUID = 1L;
    protected TextureRenderer tRenderer;
    protected Texture texture;
    protected Node quadScene;
    static int inode_val = 0;
    protected Quad standIn;
    protected float redrawRate;
    protected float elapsed;
    protected float cameraDistance = 10.0f;
    protected float cameraThreshold;
    protected float oldAngle;
    protected float lastAngle;
    protected boolean haveDrawn;
    protected boolean byCamera;
    protected boolean byTime;
    protected Vector3f worldUpVector = new Vector3f(0.0f, 1.0f, 0.0f);

    public ImposterNode() {
    }

    public ImposterNode(String string, float f, int n, int n2) {
        super(string);
        this.tRenderer = DisplaySystem.getDisplaySystem().createTextureRenderer(n, n2, 2);
        this.tRenderer.getCamera().setLocation(new Vector3f(0.0f, 0.0f, 75.0f));
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        this.quadScene = new Node("imposter_scene_" + inode_val);
        this.quadScene.setCullMode(3);
        this.standIn = new Quad("imposter_quad_" + inode_val);
        this.standIn.initialize(f, f);
        this.standIn.setModelBound(new BoundingBox());
        this.standIn.updateModelBound();
        this.standIn.setParent(this);
        ++inode_val;
        this.resetTexture();
        this.elapsed = 0.05f;
        this.redrawRate = 0.05f;
        this.cameraThreshold = 0.0f;
        this.haveDrawn = false;
        this.standIn.updateRenderState();
    }

    public void draw(Renderer renderer) {
        if (!this.haveDrawn || this.shouldDoUpdate(renderer.getCamera())) {
            this.updateCamera(renderer.getCamera().getLocation());
            if (this.byTime) {
                this.updateScene(this.redrawRate);
                this.elapsed -= this.redrawRate;
            } else if (this.byCamera) {
                this.updateScene(0.0f);
            }
            this.renderTexture();
            this.haveDrawn = true;
        }
        this.standIn.onDraw(renderer);
    }

    public void updateCamera(Vector3f vector3f) {
        float f = vector3f.distance(this.standIn.getCenter());
        float f2 = this.cameraDistance / f;
        Vector3f vector3f2 = vector3f.subtract(this.standIn.getCenter()).multLocal(f2).addLocal(this.standIn.getCenter());
        this.tRenderer.getCamera().setLocation(vector3f2);
        this.tRenderer.getCamera().lookAt(this.standIn.getCenter(), this.worldUpVector);
    }

    private boolean shouldDoUpdate(Camera camera) {
        float f;
        this.byCamera = false;
        this.byTime = false;
        if (this.redrawRate > 0.0f && this.elapsed >= this.redrawRate) {
            this.byTime = true;
            return true;
        }
        if (this.cameraThreshold > 0.0f && (f = FastMath.abs(this.getCameraChange(camera))) >= this.cameraThreshold) {
            this.byCamera = true;
            this.oldAngle = this.lastAngle;
            return true;
        }
        return false;
    }

    private float getCameraChange(Camera camera) {
        Vector3f vector3f = camera.getLocation();
        Vector3f vector3f2 = this.standIn.getCenter();
        float f = vector3f.x - vector3f2.x;
        float f2 = vector3f.z - vector3f2.z;
        if (f2 == 0.0f) {
            return 0.0f;
        }
        this.lastAngle = FastMath.atan(f / f2);
        f = vector3f.y - vector3f2.y;
        this.lastAngle += FastMath.atan(f / f2);
        return this.oldAngle - this.lastAngle;
    }

    public int attachChild(Spatial spatial) {
        return this.quadScene.attachChild(spatial);
    }

    public void setTextureRenderer(TextureRenderer textureRenderer) {
        this.tRenderer = textureRenderer;
        this.resetTexture();
    }

    public TextureRenderer getTextureRenderer() {
        return this.tRenderer;
    }

    public float getCameraDistance() {
        return this.cameraDistance;
    }

    public void setCameraDistance(float f) {
        this.cameraDistance = f;
    }

    public float getRedrawRate() {
        return this.redrawRate;
    }

    public void setRedrawRate(float f) {
        this.redrawRate = f;
        this.elapsed = f;
    }

    public Quad getStandIn() {
        return this.standIn;
    }

    public void setCameraThreshold(float f) {
        this.cameraThreshold = f;
        this.oldAngle = this.cameraThreshold + f;
    }

    public float getCameraThreshold() {
        return this.cameraThreshold;
    }

    public void resetTexture() {
        if (this.texture == null) {
            this.texture = new Texture();
        }
        this.tRenderer.setupTexture(this.texture);
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(this.texture, 0);
        this.standIn.setRenderState(textureState);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        this.standIn.setRenderState(alphaState);
    }

    public void updateScene(float f) {
        this.quadScene.updateGeometricState(f, true);
    }

    public void renderTexture() {
        this.tRenderer.render(this.quadScene, this.texture);
    }

    public void updateWorldBound() {
        this.worldBound = this.standIn.getWorldBound().clone(this.worldBound);
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        this.standIn.updateGeometricState(f, false);
        this.elapsed += f;
    }

    public Vector3f getWorldUpVector() {
        return this.worldUpVector;
    }

    public void setWorldUpVector(Vector3f vector3f) {
        this.worldUpVector = vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.texture, "texture", null);
        outputCapsule.write(this.quadScene, "quadScene", new Node("imposter_scene_" + inode_val));
        outputCapsule.write(this.standIn, "standIn", new Quad("imposter_quad_" + inode_val));
        outputCapsule.write(this.redrawRate, "redrawRate", 0.05f);
        outputCapsule.write(this.cameraDistance, "cameraDistance", 10.0f);
        outputCapsule.write(this.cameraThreshold, "cameraThreshold", 0.0f);
        outputCapsule.write(this.worldUpVector, "worldUpVector", Vector3f.UNIT_Y);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.texture = (Texture)inputCapsule.readSavable("texture", null);
        this.quadScene = (Node)inputCapsule.readSavable("quadScene", new Node("imposter_scene_" + inode_val));
        this.standIn = (Quad)inputCapsule.readSavable("standIn", new Quad("imposter_quad_" + inode_val));
        this.redrawRate = inputCapsule.readFloat("redrawRate", 0.05f);
        this.cameraDistance = inputCapsule.readFloat("cameraDistance", 10.0f);
        this.cameraThreshold = inputCapsule.readFloat("cameraThreshold", 0.0f);
        this.worldUpVector = (Vector3f)inputCapsule.readSavable("worldUpVector", new Vector3f(Vector3f.UNIT_Y));
    }
}

