/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.intersection.CollisionResults;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.scene.batch.PointBatch;
import com.jme.util.LoggingSystem;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Level;

public class Point
extends Geometry {
    private static final long serialVersionUID = 1L;

    public Point() {
    }

    public Point(String string, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, ColorRGBA[] colorRGBAArray, Vector2f[] vector2fArray) {
        super(string, BufferUtils.createFloatBuffer(vector3fArray), BufferUtils.createFloatBuffer(vector3fArray2), BufferUtils.createFloatBuffer(colorRGBAArray), BufferUtils.createFloatBuffer(vector2fArray));
        this.generateIndices(0);
        LoggingSystem.getLogger().log(Level.INFO, "Point created.");
    }

    public Point(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        super(string, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.generateIndices(0);
        LoggingSystem.getLogger().log(Level.INFO, "Point created.");
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.generateIndices(0);
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, int n) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, n);
        this.generateIndices(n);
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        PointBatch pointBatch = new PointBatch();
        pointBatch.setParentGeom(this);
        this.batchList.add(pointBatch);
    }

    public PointBatch getBatch(int n) {
        return (PointBatch)this.batchList.get(n);
    }

    public void generateIndices(int n) {
        PointBatch pointBatch = this.getBatch(n);
        if (pointBatch.getIndexBuffer() == null || pointBatch.getIndexBuffer().limit() != pointBatch.getVertexCount()) {
            pointBatch.setIndexBuffer(BufferUtils.createIntBuffer(pointBatch.getVertexCount()));
        } else {
            pointBatch.getIndexBuffer().rewind();
        }
        for (int i = 0; i < pointBatch.getVertexCount(); ++i) {
            pointBatch.getIndexBuffer().put(i);
        }
    }

    public boolean isAntialiased() {
        return this.getBatch(0).isAntialiased();
    }

    public void setAntialiased(boolean bl) {
        this.getBatch(0).setAntialiased(bl);
    }

    public float getPointSize() {
        return this.getBatch(0).getPointSize();
    }

    public void setPointSize(float f) {
        this.getBatch(0).setPointSize(f);
    }

    public boolean isAntialiased(int n) {
        return this.getBatch(n).isAntialiased();
    }

    public void setAntialiased(boolean bl, int n) {
        this.getBatch(n).setAntialiased(bl);
    }

    public float getPointSize(int n) {
        return this.getBatch(n).getPointSize();
    }

    public void setPointSize(float f, int n) {
        this.getBatch(n).setPointSize(f);
    }

    public void draw(Renderer renderer) {
        PointBatch pointBatch;
        if (this.getBatchCount() == 1 && (pointBatch = this.getBatch(0)) != null && pointBatch.isEnabled()) {
            pointBatch.setLastFrustumIntersection(this.frustrumIntersects);
            pointBatch.draw(renderer);
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            pointBatch = this.getBatch(i);
            if (pointBatch == null || !pointBatch.isEnabled()) continue;
            pointBatch.onDraw(renderer);
        }
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }
}

