/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.batch;

import com.jme.bounding.BoundingVolume;
import com.jme.intersection.PickResults;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.SceneElement;
import com.jme.scene.VBOInfo;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomBatch
extends SceneElement
implements Serializable,
Savable {
    private static final long serialVersionUID = -6361186042554187448L;
    protected BoundingVolume bound;
    protected int vertQuantity = 0;
    protected transient FloatBuffer colorBuf;
    protected transient FloatBuffer normBuf;
    protected transient FloatBuffer vertBuf;
    protected transient ArrayList<FloatBuffer> texBuf;
    protected transient VBOInfo vboInfo;
    protected boolean enabled = true;
    protected transient Geometry parentGeom = null;
    protected boolean castsShadows = true;
    protected boolean hasDirtyVertices = false;
    public RenderState[] states = new RenderState[17];
    protected ColorRGBA defaultColor = new ColorRGBA(ColorRGBA.white);
    protected int displayListID = -1;
    protected static Vector3f compVect = new Vector3f();

    public GeomBatch() {
        this.texBuf = new ArrayList(1);
        this.texBuf.add(null);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FloatBuffer getColorBuffer() {
        return this.colorBuf;
    }

    public void setColorBuffer(FloatBuffer floatBuffer) {
        this.colorBuf = floatBuffer;
    }

    public int getDisplayListID() {
        return this.displayListID;
    }

    public void setDisplayListID(int n) {
        this.displayListID = n;
    }

    public FloatBuffer getNormalBuffer() {
        return this.normBuf;
    }

    public void setNormalBuffer(FloatBuffer floatBuffer) {
        this.normBuf = floatBuffer;
    }

    public ArrayList<FloatBuffer> getTextureBuffers() {
        return this.texBuf;
    }

    public void setTextureBuffers(ArrayList<FloatBuffer> arrayList) {
        this.texBuf = arrayList;
        this.checkTextureCoordinates();
    }

    public VBOInfo getVBOInfo() {
        return this.vboInfo;
    }

    public void setVBOInfo(VBOInfo vBOInfo) {
        this.vboInfo = vBOInfo;
        if (this.vboInfo != null) {
            this.vboInfo.resizeTextureIds(this.texBuf.size());
        }
    }

    public FloatBuffer getVertexBuffer() {
        return this.vertBuf;
    }

    public void setVertexBuffer(FloatBuffer floatBuffer) {
        this.vertBuf = floatBuffer;
        this.vertQuantity = floatBuffer != null ? floatBuffer.limit() / 3 : 0;
    }

    public int getVertexCount() {
        return this.vertQuantity;
    }

    public void setVertexCount(int n) {
        this.vertQuantity = n;
    }

    public void clearTextureBuffers() {
        if (this.texBuf != null) {
            this.texBuf.clear();
        }
    }

    public void addTextureCoordinates(FloatBuffer floatBuffer) {
        if (this.texBuf != null) {
            this.texBuf.add(floatBuffer);
        }
        this.checkTextureCoordinates();
    }

    public void resizeTextureIds(int n) {
        this.vboInfo.resizeTextureIds(n);
    }

    public void setSolidColor(ColorRGBA colorRGBA) {
        if (this.colorBuf == null) {
            this.colorBuf = BufferUtils.createColorBuffer(this.vertQuantity);
        }
        this.colorBuf.rewind();
        int n = this.colorBuf.remaining();
        for (int i = 0; i < n; i += 4) {
            this.colorBuf.put(colorRGBA.r);
            this.colorBuf.put(colorRGBA.g);
            this.colorBuf.put(colorRGBA.b);
            this.colorBuf.put(colorRGBA.a);
        }
        this.colorBuf.flip();
    }

    public void setRandomColors() {
        if (this.colorBuf == null) {
            this.colorBuf = BufferUtils.createColorBuffer(this.vertQuantity);
        }
        int n = this.colorBuf.limit();
        for (int i = 0; i < n; i += 4) {
            this.colorBuf.put(FastMath.nextRandomFloat());
            this.colorBuf.put(FastMath.nextRandomFloat());
            this.colorBuf.put(FastMath.nextRandomFloat());
            this.colorBuf.put(1.0f);
        }
        this.colorBuf.flip();
    }

    protected void checkTextureCoordinates() {
        int n = TextureState.getNumberOfFixedUnits();
        if (n == -1) {
            return;
        }
        if (this.texBuf.size() > n) {
            for (int i = n; i < this.texBuf.size(); ++i) {
                if (this.texBuf.get(i) == null) continue;
                LoggingSystem.getLogger().log(Level.WARNING, "Texture coordinates set for unit " + i + ". Only " + n + " units are available.");
            }
        }
    }

    public void copyTextureCoordinates(int n, int n2, float f) {
        if (this.texBuf == null) {
            return;
        }
        if (n < 0 || n >= this.texBuf.size() || this.texBuf.get(n) == null) {
            return;
        }
        if (n2 < 0 || n2 == n) {
            return;
        }
        if (n2 >= this.texBuf.size()) {
            while (n2 >= this.texBuf.size()) {
                this.texBuf.add(null);
            }
        }
        FloatBuffer floatBuffer = this.texBuf.get(n2);
        FloatBuffer floatBuffer2 = this.texBuf.get(n);
        if (floatBuffer == null || floatBuffer.capacity() != floatBuffer2.limit()) {
            floatBuffer = BufferUtils.createFloatBuffer(floatBuffer2.capacity());
            this.texBuf.set(n2, floatBuffer);
        }
        floatBuffer.clear();
        int n3 = floatBuffer2.limit();
        floatBuffer2.clear();
        int n4 = floatBuffer.capacity();
        for (int i = 0; i < n4; ++i) {
            floatBuffer.put(f * floatBuffer2.get());
        }
        floatBuffer2.limit(n3);
        floatBuffer.limit(n3);
        if (this.vboInfo != null) {
            this.vboInfo.resizeTextureIds(this.texBuf.size());
        }
        this.checkTextureCoordinates();
    }

    public void scaleTextureCoordinates(int n, float f) {
        this.scaleTextureCoordinates(n, new Vector2f(f, f));
    }

    public void scaleTextureCoordinates(int n, Vector2f vector2f) {
        if (this.texBuf == null) {
            return;
        }
        if (n < 0 || n >= this.texBuf.size() || this.texBuf.get(n) == null) {
            return;
        }
        FloatBuffer floatBuffer = this.texBuf.get(n);
        int n2 = floatBuffer.limit() / 2;
        for (int i = 0; i < n2; ++i) {
            BufferUtils.multInBuffer(vector2f, floatBuffer, i);
        }
        if (this.vboInfo != null) {
            this.vboInfo.resizeTextureIds(this.texBuf.size());
        }
    }

    public FloatBuffer getTextureBuffer(int n) {
        if (this.texBuf == null) {
            return null;
        }
        if (n >= this.texBuf.size()) {
            return null;
        }
        return this.texBuf.get(n);
    }

    public void setTextureBuffer(FloatBuffer floatBuffer, int n) {
        if (n >= this.texBuf.size()) {
            while (n >= this.texBuf.size()) {
                this.texBuf.add(null);
            }
        }
        this.texBuf.set(n, floatBuffer);
        if (this.vboInfo != null) {
            this.vboInfo.resizeTextureIds(this.texBuf.size());
        }
        this.checkTextureCoordinates();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int n2;
        objectOutputStream.defaultWriteObject();
        if (this.getVertexBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getVertexBuffer().limit());
            this.getVertexBuffer().rewind();
            n2 = this.getVertexBuffer().limit();
            for (n = 0; n < n2; ++n) {
                objectOutputStream.writeFloat(this.getVertexBuffer().get());
            }
        }
        if (this.getNormalBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getNormalBuffer().limit());
            this.getNormalBuffer().rewind();
            n2 = this.getNormalBuffer().limit();
            for (n = 0; n < n2; ++n) {
                objectOutputStream.writeFloat(this.getNormalBuffer().get());
            }
        }
        if (this.getColorBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getColorBuffer().limit());
            this.getColorBuffer().rewind();
            n2 = this.getColorBuffer().limit();
            for (n = 0; n < n2; ++n) {
                objectOutputStream.writeFloat(this.getColorBuffer().get());
            }
        }
        if (this.getTextureBuffers() == null || this.getTextureBuffers().size() == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getTextureBuffers().size());
            for (n = 0; n < this.getTextureBuffers().size(); ++n) {
                if (this.getTextureBuffers().get(n) == null) {
                    objectOutputStream.writeInt(0);
                    continue;
                }
                FloatBuffer floatBuffer = this.getTextureBuffers().get(n);
                objectOutputStream.writeInt(floatBuffer.limit());
                floatBuffer.rewind();
                int n3 = floatBuffer.limit();
                for (int i = 0; i < n3; ++i) {
                    objectOutputStream.writeFloat(floatBuffer.get());
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        FloatBuffer floatBuffer;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        if (n2 == 0) {
            this.setVertexBuffer(null);
        } else {
            floatBuffer = BufferUtils.createFloatBuffer(n2);
            for (n = 0; n < n2; ++n) {
                floatBuffer.put(objectInputStream.readFloat());
            }
            this.setVertexBuffer(floatBuffer);
        }
        n2 = objectInputStream.readInt();
        if (n2 == 0) {
            this.setNormalBuffer(null);
        } else {
            floatBuffer = BufferUtils.createFloatBuffer(n2);
            for (n = 0; n < n2; ++n) {
                floatBuffer.put(objectInputStream.readFloat());
            }
            this.setNormalBuffer(floatBuffer);
        }
        n2 = objectInputStream.readInt();
        if (n2 == 0) {
            this.setColorBuffer(null);
        } else {
            floatBuffer = BufferUtils.createFloatBuffer(n2);
            for (n = 0; n < n2; ++n) {
                floatBuffer.put(objectInputStream.readFloat());
            }
            this.setColorBuffer(floatBuffer);
        }
        n2 = objectInputStream.readInt();
        if (n2 == 0) {
            this.setTextureBuffers(null);
        } else {
            this.setTextureBuffers(new ArrayList<FloatBuffer>(1));
            for (int i = 0; i < n2; ++i) {
                n = objectInputStream.readInt();
                if (n == 0) {
                    this.setTextureBuffer(null, i);
                    continue;
                }
                FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(n);
                for (int j = 0; j < n; ++j) {
                    floatBuffer2.put(objectInputStream.readFloat());
                }
                this.setTextureBuffer(floatBuffer2, i);
            }
        }
    }

    public boolean removeFromParent() {
        return this.parentGeom.removeBatch(this);
    }

    public boolean isCastsShadows() {
        return this.castsShadows;
    }

    @Override
    public String toString() {
        if (this.parentGeom != null) {
            return this.parentGeom.getName() + ": Batch " + this.parentGeom.getBatchIndex(this);
        }
        return "orphaned batch";
    }

    public void setCastsShadows(boolean bl) {
        this.castsShadows = bl;
    }

    public Vector3f randomVertex(Vector3f vector3f) {
        if (this.getVertexBuffer() == null) {
            return null;
        }
        int n = (int)(FastMath.nextRandomFloat() * (float)this.getVertexCount());
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        BufferUtils.populateFromBuffer(vector3f, this.getVertexBuffer(), n);
        this.parentGeom.localToWorld(vector3f, vector3f);
        return vector3f;
    }

    public void findPick(Ray ray, PickResults pickResults) {
        if (this.getWorldBound() == null || !this.isCollidable) {
            return;
        }
        if (this.getWorldBound().intersects(ray)) {
            pickResults.addPick(ray, this);
        }
    }

    @Override
    public int getType() {
        return 256;
    }

    public int getNumberOfUnits() {
        if (this.texBuf == null) {
            return 0;
        }
        return this.texBuf.size();
    }

    @Override
    public void lockMeshes(Renderer renderer) {
        if (this.getDisplayListID() != -1) {
            LoggingSystem.getLogger().log(Level.WARNING, "This GeomBatch already has locked meshes. (Use unlockMeshes to clear)");
            return;
        }
        this.updateRenderState();
        this.lockedMode |= 2;
        this.setDisplayListID(renderer.createDisplayList(this));
    }

    @Override
    public void unlockMeshes(Renderer renderer) {
        this.lockedMode &= 0xFFFFFFFD;
        if (this.getDisplayListID() != -1) {
            renderer.releaseDisplayList(this.getDisplayListID());
            this.setDisplayListID(-1);
        }
    }

    public void setModelBound(BoundingVolume boundingVolume) {
        this.worldBound = null;
        this.bound = boundingVolume;
    }

    public void updateModelBound() {
        if (this.bound != null && this.getVertexBuffer() != null) {
            this.bound.computeFromPoints(this.getVertexBuffer());
            this.updateWorldBound();
        }
    }

    @Override
    public void updateWorldBound() {
        if (this.bound != null && this.parentGeom != null) {
            this.worldBound = this.bound.transform(this.parentGeom.getWorldRotation(), this.parentGeom.getWorldTranslation(), this.parentGeom.getWorldScale(), this.worldBound);
        }
    }

    @Override
    public void updateGeometricState(float f, boolean bl) {
        if ((this.lockedMode & 1) == 0) {
            this.updateWorldBound();
            if (bl) {
                this.propagateBoundToRoot();
            }
        }
    }

    @Override
    public void propagateBoundToRoot() {
        if (this.parentGeom != null) {
            this.parentGeom.updateWorldBound();
            this.parentGeom.propagateBoundToRoot();
        }
    }

    public boolean predraw(Renderer renderer) {
        return true;
    }

    public void postdraw(Renderer renderer) {
    }

    public void onDraw(Renderer renderer) {
        int n = this.getCullMode();
        if (n == 2) {
            this.frustrumIntersects = 0;
            return;
        }
        if (n == 3) {
            this.frustrumIntersects = 1;
            this.draw(renderer);
            return;
        }
        Camera camera = renderer.getCamera();
        int n2 = camera.getPlaneState();
        int n3 = this.frustrumIntersects = this.parentGeom != null ? this.parentGeom.getLastFrustumIntersection() : 1;
        if (n == 1 && this.frustrumIntersects == 1) {
            this.frustrumIntersects = camera.contains(this.worldBound);
        }
        if (this.frustrumIntersects != 0) {
            this.draw(renderer);
        }
        camera.setPlaneState(n2);
    }

    @Override
    public int getRenderQueueMode() {
        if (this.renderQueueMode != 0) {
            return this.renderQueueMode;
        }
        if (this.parentGeom != null) {
            return this.parentGeom.getRenderQueueMode();
        }
        return 1;
    }

    @Override
    public int getLightCombineMode() {
        if (this.lightCombineMode != 4) {
            return this.lightCombineMode;
        }
        if (this.parentGeom != null) {
            return this.parentGeom.getLightCombineMode();
        }
        return 1;
    }

    @Override
    public int getTextureCombineMode() {
        if (this.textureCombineMode != 4) {
            return this.textureCombineMode;
        }
        if (this.parentGeom != null) {
            return this.parentGeom.getTextureCombineMode();
        }
        return 2;
    }

    @Override
    public int getCullMode() {
        if (this.cullMode != 0) {
            return this.cullMode;
        }
        if (this.parentGeom != null) {
            return this.parentGeom.getCullMode();
        }
        return 1;
    }

    @Override
    public int getNormalsMode() {
        if (this.normalsMode != 0) {
            return this.normalsMode;
        }
        if (this.parentGeom != null) {
            return this.parentGeom.getNormalsMode();
        }
        return 3;
    }

    public FloatBuffer getWorldCoords(FloatBuffer floatBuffer) {
        if (floatBuffer == null || floatBuffer.capacity() != this.getVertexBuffer().limit()) {
            floatBuffer = BufferUtils.clone(this.getVertexBuffer());
        }
        int n = floatBuffer.capacity() / 3;
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVect, floatBuffer, i);
            this.parentGeom.getWorldRotation().multLocal(compVect).multLocal(this.parentGeom.getWorldScale()).addLocal(this.parentGeom.getWorldTranslation());
            BufferUtils.setInBuffer(compVect, floatBuffer, i);
        }
        floatBuffer.clear();
        return floatBuffer;
    }

    public FloatBuffer getWorldNormals(FloatBuffer floatBuffer) {
        if (floatBuffer == null || floatBuffer.capacity() != this.getNormalBuffer().limit()) {
            floatBuffer = BufferUtils.clone(this.getNormalBuffer());
        }
        int n = floatBuffer.capacity() / 3;
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVect, floatBuffer, i);
            this.parentGeom.getWorldRotation().multLocal(compVect);
            BufferUtils.setInBuffer(compVect, floatBuffer, i);
        }
        floatBuffer.clear();
        return floatBuffer;
    }

    @Override
    public void propagateStatesFromRoot(Stack[] stackArray) {
        if (this.parentGeom != null) {
            this.parentGeom.propagateStatesFromRoot(stackArray);
        }
        for (int i = 0; i < 17; ++i) {
            if (this.getRenderState(i) == null) continue;
            stackArray[i].push(this.getRenderState(i));
        }
    }

    @Override
    protected void applyRenderState(Stack[] stackArray) {
        for (int i = 0; i < stackArray.length; ++i) {
            this.states[i] = stackArray[i].size() > 0 ? ((RenderState)stackArray[i].peek()).extract(stackArray[i], this) : Renderer.defaultStateList[i];
        }
    }

    public void translatePoints(float f, float f2, float f3) {
        this.translatePoints(new Vector3f(f, f2, f3));
    }

    public void translatePoints(Vector3f vector3f) {
        for (int i = 0; i < this.vertQuantity; ++i) {
            BufferUtils.addInBuffer(vector3f, this.vertBuf, i);
        }
    }

    public void rotatePoints(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.vertQuantity; ++i) {
            BufferUtils.populateFromBuffer(vector3f, this.vertBuf, i);
            quaternion.mult(vector3f, vector3f);
            BufferUtils.setInBuffer(vector3f, this.vertBuf, i);
        }
    }

    public void rotateNormals(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.vertQuantity; ++i) {
            BufferUtils.populateFromBuffer(vector3f, this.normBuf, i);
            quaternion.mult(vector3f, vector3f);
            BufferUtils.setInBuffer(vector3f, this.normBuf, i);
        }
    }

    public ColorRGBA getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(ColorRGBA colorRGBA) {
        this.defaultColor = colorRGBA;
    }

    @Override
    public void draw(Renderer renderer) {
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.colorBuf, "colorBuf", null);
        outputCapsule.write(this.normBuf, "normBuf", null);
        outputCapsule.write(this.vertBuf, "vertBuf", null);
        outputCapsule.writeFloatBufferArrayList(this.texBuf, "texBuf", new ArrayList<FloatBuffer>(1));
        outputCapsule.write(this.enabled, "enabled", true);
        outputCapsule.write(this.castsShadows, "castsShadows", true);
        outputCapsule.write(this.bound, "bound", null);
        outputCapsule.write(this.defaultColor, "defaultColor", ColorRGBA.white);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.colorBuf = inputCapsule.readFloatBuffer("colorBuf", null);
        this.normBuf = inputCapsule.readFloatBuffer("normBuf", null);
        this.vertBuf = inputCapsule.readFloatBuffer("vertBuf", null);
        this.vertQuantity = this.vertBuf != null ? this.vertBuf.limit() / 3 : 0;
        this.texBuf = inputCapsule.readFloatBufferArrayList("texBuf", new ArrayList<FloatBuffer>(1));
        this.checkTextureCoordinates();
        this.enabled = inputCapsule.readBoolean("enabled", true);
        this.castsShadows = inputCapsule.readBoolean("castsShadows", true);
        this.bound = (BoundingVolume)inputCapsule.readSavable("bound", null);
        if (this.bound != null) {
            this.worldBound = this.bound.clone(null);
        }
        this.defaultColor = (ColorRGBA)inputCapsule.readSavable("defaultColor", new ColorRGBA(ColorRGBA.white));
    }

    public BoundingVolume getModelBound() {
        return this.bound;
    }

    public boolean hasDirtyVertices() {
        return this.hasDirtyVertices;
    }

    public void setHasDirtyVertices(boolean bl) {
        this.hasDirtyVertices = bl;
    }

    public Geometry getParentGeom() {
        return this.parentGeom;
    }

    public void setParentGeom(Geometry geometry) {
        this.parentGeom = geometry;
    }
}

