/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.batch;

import com.jme.bounding.BoundingVolume;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.VBOInfo;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.RenderState;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedBatch
extends TriangleBatch {
    private static final long serialVersionUID = 1L;
    private TriangleBatch target;
    private static TriMesh motherMesh = null;

    public SharedBatch() {
        this.defaultColor = null;
    }

    public SharedBatch(TriangleBatch triangleBatch) {
        this();
        if ((triangleBatch.getType() & 0x400) != 0) {
            this.setTarget(((SharedBatch)triangleBatch).getTarget());
        } else {
            this.setTarget(triangleBatch);
        }
    }

    @Override
    public int getType() {
        return 1792;
    }

    public void setTarget(TriangleBatch triangleBatch) {
        this.target = triangleBatch;
        for (int i = 0; i < 17; ++i) {
            RenderState renderState = this.target.getRenderState(i);
            if (renderState == null) continue;
            this.setRenderState(renderState);
        }
        this.setCullMode(triangleBatch.getLocalCullMode());
        this.setLightCombineMode(triangleBatch.getLocalLightCombineMode());
        this.setRenderQueueMode(triangleBatch.getLocalRenderQueueMode());
        this.setTextureCombineMode(triangleBatch.getLocalTextureCombineMode());
        this.setZOrder(triangleBatch.getZOrder());
    }

    public TriangleBatch getTarget() {
        return this.target;
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        LoggingSystem.getLogger().log(Level.INFO, "SharedBatch will ignore reconstruct.");
    }

    @Override
    public void setVBOInfo(VBOInfo vBOInfo) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public VBOInfo getVBOInfo() {
        return this.target.getVBOInfo();
    }

    @Override
    public void setSolidColor(ColorRGBA colorRGBA) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void setRandomColors() {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer getVertexBuffer() {
        return this.target.getVertexBuffer();
    }

    @Override
    public void setVertexBuffer(FloatBuffer floatBuffer) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer getNormalBuffer() {
        return this.target.getNormalBuffer();
    }

    @Override
    public void setNormalBuffer(FloatBuffer floatBuffer) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public FloatBuffer getColorBuffer() {
        return this.target.getColorBuffer();
    }

    @Override
    public void setColorBuffer(FloatBuffer floatBuffer) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public IntBuffer getIndexBuffer() {
        return this.target.getIndexBuffer();
    }

    @Override
    public void setIndexBuffer(IntBuffer intBuffer) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public int getVertexCount() {
        return this.target.getVertexCount();
    }

    @Override
    public int getTriangleCount() {
        return this.target.getTriangleCount();
    }

    @Override
    public void getTriangle(int n, int[] nArray) {
        this.target.getTriangle(n, nArray);
    }

    public void copyTextureCoords(int n, int n2) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public ArrayList<FloatBuffer> getTextureBuffers() {
        return this.target.getTextureBuffers();
    }

    @Override
    public FloatBuffer getTextureBuffer(int n) {
        return this.target.getTextureBuffer(n);
    }

    public void setTextureBuffer(FloatBuffer floatBuffer) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void setTextureBuffer(FloatBuffer floatBuffer, int n) {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    public void clearBuffers() {
        LoggingSystem.getLogger().log(Level.WARNING, "SharedBatch does not allow the manipulationof the the mesh data.");
    }

    @Override
    public void updateWorldBound() {
        if (this.target.getModelBound() != null) {
            this.worldBound = this.target.getModelBound().transform(this.parentGeom.getWorldRotation(), this.parentGeom.getWorldTranslation(), this.parentGeom.getWorldScale(), this.worldBound);
        }
    }

    @Override
    public void setModelBound(BoundingVolume boundingVolume) {
        this.target.bound = boundingVolume;
    }

    @Override
    public void updateModelBound() {
        if (this.target.getModelBound() != null) {
            this.target.updateModelBound();
            this.updateWorldBound();
        }
    }

    @Override
    public BoundingVolume getModelBound() {
        return this.target.getModelBound();
    }

    @Override
    public void draw(Renderer renderer) {
        if (!this.isEnabled()) {
            return;
        }
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        this.target.parentGeom.getWorldTranslation().set(this.parentGeom.getWorldTranslation());
        this.target.parentGeom.getWorldRotation().set(this.parentGeom.getWorldRotation());
        this.target.parentGeom.getWorldScale().set(this.parentGeom.getWorldScale());
        this.target.setDefaultColor(this.getDefaultColor());
        System.arraycopy(this.states, 0, this.target.states, 0, this.states.length);
        renderer.draw(this.target);
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.target, "target", null);
        super.write(jMEExporter);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.target = (TriangleBatch)inputCapsule.readSavable("target", null);
        if (this.target.parentGeom == null) {
            if (motherMesh == null) {
                motherMesh = new TriMesh("mother");
                motherMesh.clearBatches();
            }
            motherMesh.addBatch(this.target);
        }
        super.read(jMEImporter);
    }

    @Override
    public void lockMeshes(Renderer renderer) {
        this.target.lockMeshes(renderer);
    }

    @Override
    public boolean hasDirtyVertices() {
        return this.target.hasDirtyVertices;
    }

    @Override
    public String toString() {
        if (this.target.parentGeom != null) {
            return this.target.parentGeom.getName() + ": SharedBatch " + this.parentGeom.getBatchIndex(this);
        }
        return "orphaned batch";
    }

    @Override
    public ColorRGBA getDefaultColor() {
        ColorRGBA colorRGBA = this.defaultColor;
        if (colorRGBA == null) {
            return super.getDefaultColor();
        }
        return colorRGBA;
    }
}

