/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.batch;

import com.jme.bounding.CollisionTree;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.CollisionResults;
import com.jme.math.FastMath;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleBatch
extends GeomBatch
implements Serializable,
Savable {
    private static final long serialVersionUID = 1277007053054883892L;
    public static final int TRIANGLES = 1;
    public static final int TRIANGLE_STRIP = 2;
    public static final int TRIANGLE_FAN = 3;
    protected transient IntBuffer indexBuffer;
    private int mode = 1;
    private int triangleQuantity;

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public IntBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    public void setIndexBuffer(IntBuffer intBuffer) {
        this.indexBuffer = intBuffer;
        this.recalcTriangleQuantity();
    }

    protected void recalcTriangleQuantity() {
        if (this.indexBuffer == null) {
            this.triangleQuantity = 0;
            return;
        }
        switch (this.mode) {
            case 1: {
                this.triangleQuantity = this.indexBuffer.limit() / 3;
                break;
            }
            case 2: 
            case 3: {
                this.triangleQuantity = this.indexBuffer.limit() - 2;
            }
        }
    }

    public int getTriangleCount() {
        return this.triangleQuantity;
    }

    public void setTriangleQuantity(int n) {
        this.triangleQuantity = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getIndexBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getIndexBuffer().limit());
            this.getIndexBuffer().rewind();
            int n = this.getIndexBuffer().limit();
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeInt(this.getIndexBuffer().get());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.setIndexBuffer(null);
        } else {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
            for (int i = 0; i < n; ++i) {
                intBuffer.put(objectInputStream.readInt());
            }
            this.setIndexBuffer(intBuffer);
        }
    }

    public Vector3f randomPointOnTriangles(Vector3f vector3f, Vector3f vector3f2) {
        float f;
        if (this.getVertexBuffer() == null || this.getIndexBuffer() == null) {
            return null;
        }
        int n = (int)(FastMath.nextRandomFloat() * (float)this.getTriangleCount());
        int n2 = this.getIndexBuffer().get(this.getVertIndex(n, 0));
        int n3 = this.getIndexBuffer().get(this.getVertIndex(n, 1));
        int n4 = this.getIndexBuffer().get(this.getVertIndex(n, 2));
        float f2 = FastMath.nextRandomFloat();
        if (f2 + (f = FastMath.nextRandomFloat()) > 1.0f) {
            f2 = 1.0f - f2;
            f = 1.0f - f;
        }
        float f3 = 1.0f - f2 - f;
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        BufferUtils.populateFromBuffer(vector3f2, this.getVertexBuffer(), n2);
        vector3f2.multLocal(f3);
        vector3f.set(vector3f2);
        BufferUtils.populateFromBuffer(vector3f2, this.getVertexBuffer(), n3);
        vector3f2.multLocal(f2);
        vector3f.addLocal(vector3f2);
        BufferUtils.populateFromBuffer(vector3f2, this.getVertexBuffer(), n4);
        vector3f2.multLocal(f);
        vector3f.addLocal(vector3f2);
        this.parentGeom.localToWorld(vector3f, vector3f);
        return vector3f;
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.indexBuffer, "indexBuffer", null);
        outputCapsule.write(this.mode, "mode", 1);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.indexBuffer = inputCapsule.readIntBuffer("indexBuffer", null);
        this.recalcTriangleQuantity();
        this.mode = inputCapsule.readInt("mode", 1);
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }

    @Override
    public int getType() {
        return 768;
    }

    @Override
    public void draw(Renderer renderer) {
        if (!this.isEnabled()) {
            return;
        }
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        super.draw(renderer);
        renderer.draw(this);
    }

    public void getTriangle(int n, int[] nArray) {
        if (n < this.getTriangleCount() && nArray.length >= 3) {
            IntBuffer intBuffer = this.getIndexBuffer();
            nArray[0] = intBuffer.get(this.getVertIndex(n, 0));
            nArray[1] = intBuffer.get(this.getVertIndex(n, 1));
            nArray[2] = intBuffer.get(this.getVertIndex(n, 2));
        }
    }

    public void getTriangle(int n, Vector3f[] vector3fArray) {
        if (vector3fArray == null) {
            vector3fArray = new Vector3f[3];
        }
        if (n < this.getTriangleCount() && n >= 0) {
            for (int i = 0; i < 3; ++i) {
                if (vector3fArray[i] == null) {
                    vector3fArray[i] = new Vector3f();
                }
                BufferUtils.populateFromBuffer(vector3fArray[i], this.getVertexBuffer(), this.getIndexBuffer().get(this.getVertIndex(n, i)));
            }
        }
    }

    public void findTrianglePick(Ray ray, ArrayList<Integer> arrayList) {
        CollisionTree collisionTree;
        if (this.worldBound == null || !this.isCollidable) {
            return;
        }
        if (this.worldBound.intersects(ray) && (collisionTree = CollisionTreeManager.getInstance().getCollisionTree(this)) != null) {
            collisionTree.getBounds().transform(this.parentGeom.getWorldRotation(), this.parentGeom.getWorldTranslation(), this.parentGeom.getWorldScale(), collisionTree.getWorldBounds());
            collisionTree.intersect(ray, arrayList);
        }
    }

    public Vector3f[] getMeshAsTrianglesVertices(Vector3f[] vector3fArray) {
        int n = this.getTriangleCount() * 3;
        if (vector3fArray == null || vector3fArray.length != n) {
            vector3fArray = new Vector3f[n];
        }
        this.getIndexBuffer().rewind();
        for (int i = 0; i < n; ++i) {
            if (vector3fArray[i] == null) {
                vector3fArray[i] = new Vector3f();
            }
            int n2 = this.getVertIndex(i / 3, i % 3);
            BufferUtils.populateFromBuffer(vector3fArray[i], this.getVertexBuffer(), this.getIndexBuffer().get(n2));
        }
        return vector3fArray;
    }

    protected int getVertIndex(int n, int n2) {
        int n3 = 0;
        int n4 = n * 3 + n2;
        switch (this.mode) {
            case 1: {
                n3 = n4;
                break;
            }
            case 2: {
                n3 = n4 / 3 + n4 % 3;
                break;
            }
            case 3: {
                if (n4 % 3 == 0) {
                    n3 = 0;
                    break;
                }
                n3 = n4 % 3;
                n3 = (n4 - n3) / 3 + n3;
                break;
            }
            default: {
                throw new JmeException("mode is set to invalid type: " + this.mode);
            }
        }
        return n3;
    }

    public int[] getTriangleIndices(int[] nArray) {
        int n = this.getTriangleCount();
        if (nArray == null || nArray.length != n) {
            nArray = new int[n];
        }
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public Triangle[] getMeshAsTriangles(Triangle[] triangleArray) {
        int n = this.getTriangleCount();
        if (triangleArray == null || triangleArray.length != n) {
            triangleArray = new Triangle[n];
        }
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            Vector3f vector3f3 = new Vector3f();
            Triangle triangle = triangleArray[i];
            if (triangle == null) {
                triangleArray[i] = triangle = new Triangle(this.getVector(i * 3 + 0, vector3f), this.getVector(i * 3 + 1, vector3f2), this.getVector(i * 3 + 2, vector3f3));
            } else {
                triangle.set(0, this.getVector(i * 3 + 0, vector3f));
                triangle.set(1, this.getVector(i * 3 + 1, vector3f2));
                triangle.set(2, this.getVector(i * 3 + 2, vector3f3));
            }
            triangle.setIndex(i);
        }
        return triangleArray;
    }

    private Vector3f getVector(int n, Vector3f vector3f) {
        int n2 = this.getVertIndex(n / 3, n % 3);
        BufferUtils.populateFromBuffer(vector3f, this.getVertexBuffer(), this.getIndexBuffer().get(n2));
        return vector3f;
    }

    public int getMaxIndex() {
        if (this.indexBuffer == null) {
            return -1;
        }
        switch (this.mode) {
            case 1: {
                return this.triangleQuantity * 3;
            }
            case 2: 
            case 3: {
                this.triangleQuantity = this.indexBuffer.limit() - 2;
                return this.triangleQuantity + 2;
            }
        }
        return 0;
    }
}

