/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.lod;

import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.lod.CollapseRecord;
import com.jme.util.AreaUtils;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;

public class AreaClodMesh
extends ClodMesh {
    private static final long serialVersionUID = 1L;
    private float trisPerPixel = 1.0f;
    private float distTolerance = 1.0f;
    private float lastDistance = 0.0f;

    public AreaClodMesh() {
    }

    public AreaClodMesh(String string) {
        super(string);
    }

    public AreaClodMesh(String string, TriMesh triMesh, CollapseRecord[] collapseRecordArray) {
        super(string, triMesh, collapseRecordArray);
    }

    public AreaClodMesh(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer, CollapseRecord[] collapseRecordArray) {
        super(string, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer, collapseRecordArray);
    }

    public int chooseTargetRecord(Renderer renderer) {
        if (this.getWorldBound() == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "AreaClodMesh found with no Bounds.");
            return 0;
        }
        if (this.records == null || this.records.length == 0) {
            LoggingSystem.getLogger().log(Level.WARNING, "Records was null.");
            return 0;
        }
        float f = this.getWorldBound().distanceTo(renderer.getCamera().getLocation());
        if (Math.abs(f - this.lastDistance) <= this.distTolerance) {
            return this.targetRecord;
        }
        if (this.lastDistance > f && this.targetRecord == 0) {
            return this.targetRecord;
        }
        if (this.lastDistance < f && this.targetRecord == this.records.length - 1) {
            return this.targetRecord;
        }
        this.lastDistance = f;
        float f2 = AreaUtils.calcScreenArea(this.getWorldBound(), this.lastDistance, (float)renderer.getWidth());
        float f3 = f2 * this.trisPerPixel;
        this.targetRecord = this.records.length - 1;
        int n = this.records.length;
        while (--n >= 0 && !(f3 - (float)this.records[n].numbTriangles < 0.0f)) {
            this.targetRecord = n;
        }
        return this.targetRecord;
    }

    public void setTargetRecord(int n) {
    }

    public float getTrisPerPixel() {
        return this.trisPerPixel;
    }

    public void setTrisPerPixel(float f) {
        this.trisPerPixel = f;
    }

    public float getDistanceTolerance() {
        return this.distTolerance;
    }

    public void setDistanceTolerance(float f) {
        this.distTolerance = f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.trisPerPixel, "trisPerPixel", 1.0f);
        outputCapsule.write(this.distTolerance, "distTolerance", 1.0f);
        outputCapsule.write(this.lastDistance, "lastDistance", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.trisPerPixel = inputCapsule.readFloat("trisPerPixel", 1.0f);
        this.distTolerance = inputCapsule.readFloat("distTolerance", 1.0f);
        this.lastDistance = inputCapsule.readFloat("lastDistance", 0.0f);
    }
}

