/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.lod;

import com.jme.scene.lod.ExVector;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VETMesh {
    protected TreeMap<Integer, VertexAttribute> vertexMap = new TreeMap();
    protected TreeMap<Edge, EdgeAttribute> edgeMap = new TreeMap();
    protected TreeMap<Triangle, TriangleAttribute> triangleMap = new TreeMap();

    public int getVertexQuantity() {
        return this.vertexMap.size();
    }

    public int getEdgeQuantity() {
        return this.edgeMap.size();
    }

    public int getTriangleQuantity() {
        return this.triangleMap.size();
    }

    public VETMesh create() {
        return new VETMesh();
    }

    public void onVertexInsert(Integer n, boolean bl, VertexAttribute vertexAttribute) {
    }

    public void onVertexRemove(Integer n, boolean bl, VertexAttribute vertexAttribute) {
    }

    public void onEdgeInsert(Edge edge, boolean bl, EdgeAttribute edgeAttribute) {
    }

    public void onEdgeRemove(Edge edge, boolean bl, EdgeAttribute edgeAttribute) {
    }

    public void onTriangleInsert(Triangle triangle, boolean bl, TriangleAttribute triangleAttribute) {
    }

    public void onTriangleRemove(Triangle triangle, boolean bl, TriangleAttribute triangleAttribute) {
    }

    public void insertTriangle(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Integer n4 = new Integer(n);
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n3);
        Triangle triangle = new Triangle(n, n2, n3);
        Edge edge = new Edge(n, n2);
        Edge edge2 = new Edge(n2, n3);
        Edge edge3 = new Edge(n3, n);
        TriangleAttribute triangleAttribute = new TriangleAttribute();
        bl = this.triangleMap.get(triangle) != null;
        this.triangleMap.put(triangle, triangleAttribute);
        VertexAttribute vertexAttribute = this.vertexMap.get(n4);
        if (vertexAttribute == null) {
            vertexAttribute = new VertexAttribute();
        } else {
            bl2 = true;
        }
        vertexAttribute.edgeSet.add(edge);
        vertexAttribute.edgeSet.add(edge3);
        vertexAttribute.triangleSet.add(triangle);
        this.vertexMap.put(n4, vertexAttribute);
        VertexAttribute vertexAttribute2 = this.vertexMap.get(n5);
        if (vertexAttribute2 == null) {
            vertexAttribute2 = new VertexAttribute();
        } else {
            bl3 = true;
        }
        vertexAttribute2.edgeSet.add(edge);
        vertexAttribute2.edgeSet.add(edge2);
        vertexAttribute2.triangleSet.add(triangle);
        this.vertexMap.put(n5, vertexAttribute2);
        VertexAttribute vertexAttribute3 = this.vertexMap.get(n6);
        if (vertexAttribute3 == null) {
            vertexAttribute3 = new VertexAttribute();
        } else {
            bl4 = true;
        }
        vertexAttribute3.edgeSet.add(edge2);
        vertexAttribute3.edgeSet.add(edge3);
        vertexAttribute3.triangleSet.add(triangle);
        this.vertexMap.put(n6, vertexAttribute3);
        EdgeAttribute edgeAttribute = this.edgeMap.get(edge);
        if (edgeAttribute == null) {
            edgeAttribute = new EdgeAttribute();
        } else {
            bl5 = true;
        }
        edgeAttribute.triangleSet.add(triangle);
        this.edgeMap.put(edge, edgeAttribute);
        EdgeAttribute edgeAttribute2 = this.edgeMap.get(edge2);
        if (edgeAttribute2 == null) {
            edgeAttribute2 = new EdgeAttribute();
        } else {
            bl6 = true;
        }
        edgeAttribute2.triangleSet.add(triangle);
        this.edgeMap.put(edge2, edgeAttribute2);
        EdgeAttribute edgeAttribute3 = this.edgeMap.get(edge3);
        if (edgeAttribute3 == null) {
            edgeAttribute3 = new EdgeAttribute();
        } else {
            bl7 = true;
        }
        edgeAttribute3.triangleSet.add(triangle);
        this.edgeMap.put(edge3, edgeAttribute3);
        this.onVertexInsert(n4, !bl2, vertexAttribute);
        this.onVertexInsert(n5, !bl3, vertexAttribute2);
        this.onVertexInsert(n6, !bl4, vertexAttribute3);
        this.onEdgeInsert(edge, !bl5, edgeAttribute);
        this.onEdgeInsert(edge2, !bl6, edgeAttribute2);
        this.onEdgeInsert(edge3, !bl7, edgeAttribute3);
        this.onTriangleInsert(triangle, !bl, triangleAttribute);
    }

    public void insertTriangle(Triangle triangle) {
        this.insertTriangle(triangle.vert[0], triangle.vert[1], triangle.vert[2]);
    }

    public void removeTriangle(int n, int n2, int n3) {
        Triangle triangle = new Triangle(n, n2, n3);
        TriangleAttribute triangleAttribute = this.triangleMap.get(triangle);
        if (triangleAttribute == null) {
            return;
        }
        Integer n4 = new Integer(n);
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n3);
        Edge edge = new Edge(n, n2);
        Edge edge2 = new Edge(n2, n3);
        Edge edge3 = new Edge(n3, n);
        EdgeAttribute edgeAttribute = this.edgeMap.get(edge);
        edgeAttribute.triangleSet.remove(triangle);
        EdgeAttribute edgeAttribute2 = this.edgeMap.get(edge2);
        edgeAttribute2.triangleSet.remove(triangle);
        EdgeAttribute edgeAttribute3 = this.edgeMap.get(edge3);
        edgeAttribute3.triangleSet.remove(triangle);
        VertexAttribute vertexAttribute = this.vertexMap.get(n4);
        vertexAttribute.triangleSet.remove(triangle);
        VertexAttribute vertexAttribute2 = this.vertexMap.get(n5);
        vertexAttribute2.triangleSet.remove(triangle);
        VertexAttribute vertexAttribute3 = this.vertexMap.get(n6);
        vertexAttribute3.triangleSet.remove(triangle);
        if (edgeAttribute.triangleSet.size() == 0) {
            vertexAttribute.edgeSet.remove(edge);
            vertexAttribute2.edgeSet.remove(edge);
        }
        if (edgeAttribute2.triangleSet.size() == 0) {
            vertexAttribute2.edgeSet.remove(edge2);
            vertexAttribute3.edgeSet.remove(edge2);
        }
        if (edgeAttribute3.triangleSet.size() == 0) {
            vertexAttribute.edgeSet.remove(edge3);
            vertexAttribute3.edgeSet.remove(edge3);
        }
        boolean bl = vertexAttribute.edgeSet.size() == 0 && vertexAttribute.triangleSet.size() == 0;
        this.onVertexRemove(n4, bl, vertexAttribute);
        if (bl) {
            this.vertexMap.remove(n4);
        }
        bl = vertexAttribute2.edgeSet.size() == 0 && vertexAttribute2.triangleSet.size() == 0;
        this.onVertexRemove(n5, bl, vertexAttribute2);
        if (bl) {
            this.vertexMap.remove(n5);
        }
        bl = vertexAttribute3.edgeSet.size() == 0 && vertexAttribute3.triangleSet.size() == 0;
        this.onVertexRemove(n6, bl, vertexAttribute3);
        if (bl) {
            this.vertexMap.remove(n6);
        }
        bl = edgeAttribute.triangleSet.size() == 0;
        this.onEdgeRemove(edge, bl, edgeAttribute);
        if (bl) {
            this.edgeMap.remove(edge);
        }
        bl = edgeAttribute2.triangleSet.size() == 0;
        this.onEdgeRemove(edge2, bl, edgeAttribute2);
        if (bl) {
            this.edgeMap.remove(edge2);
        }
        bl = edgeAttribute3.triangleSet.size() == 0;
        this.onEdgeRemove(edge3, bl, edgeAttribute3);
        if (bl) {
            this.edgeMap.remove(edge3);
        }
        this.onTriangleRemove(triangle, true, triangleAttribute);
        this.triangleMap.remove(triangle);
    }

    public void removeTriangle(Triangle triangle) {
        this.removeTriangle(triangle.vert[0], triangle.vert[1], triangle.vert[2]);
    }

    public void removeAllTriangles() {
        Object[] objectArray = this.triangleMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Triangle triangle = (Triangle)objectArray[i];
            int n = triangle.vert[0];
            int n2 = triangle.vert[1];
            int n3 = triangle.vert[2];
            this.removeTriangle(n, n2, n3);
        }
    }

    public TreeMap getVertexMap() {
        return this.vertexMap;
    }

    public TreeMap getEdgeMap() {
        return this.edgeMap;
    }

    public ExVector getTriangles(int n, int n2) {
        EdgeAttribute edgeAttribute = this.edgeMap.get(new Edge(n, n2));
        return edgeAttribute != null ? edgeAttribute.triangleSet : null;
    }

    public TreeMap getTriangleMap() {
        return this.triangleMap;
    }

    public boolean isManifold() {
        for (EdgeAttribute edgeAttribute : this.edgeMap.values()) {
            if (edgeAttribute.triangleSet.size() <= 2) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        for (EdgeAttribute edgeAttribute : this.edgeMap.values()) {
            if (edgeAttribute.triangleSet.size() == 2) continue;
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        int n = this.triangleMap.size();
        if (n == 0) {
            return true;
        }
        TreeMap<Triangle, Boolean> treeMap = new TreeMap<Triangle, Boolean>();
        Iterator<Triangle> iterator = this.triangleMap.keySet().iterator();
        while (iterator.hasNext()) {
            treeMap.put(iterator.next(), Boolean.FALSE);
        }
        Stack<Triangle> stack = new Stack<Triangle>();
        stack.push((Triangle)this.triangleMap.keySet().toArray()[0]);
        treeMap.put((Triangle)stack.get(0), Boolean.TRUE);
        --n;
        while (!stack.empty()) {
            Triangle triangle = (Triangle)stack.pop();
            for (int i = 0; i < 3; ++i) {
                EdgeAttribute edgeAttribute = this.edgeMap.get(new Edge(triangle.vert[i], triangle.vert[(i + 1) % 3]));
                ExVector exVector = (ExVector)edgeAttribute.triangleSet.clone();
                for (Triangle triangle2 : exVector) {
                    if (!Boolean.FALSE.equals(treeMap.get(triangle2))) continue;
                    stack.push(triangle2);
                    treeMap.put(triangle2, Boolean.TRUE);
                    --n;
                }
            }
        }
        return n == 0;
    }

    public void getComponents(Vector<VETMesh> vector) {
        int n = this.triangleMap.size();
        if (n == 0) {
            return;
        }
        TreeMap<Object, Boolean> treeMap = new TreeMap<Object, Boolean>();
        Iterator<Triangle> iterator = this.triangleMap.keySet().iterator();
        while (iterator.hasNext()) {
            treeMap.put(iterator.next(), Boolean.FALSE);
        }
        while (n > 0) {
            Object object2;
            Stack<Object> stack = new Stack<Object>();
            for (Object object2 : treeMap.keySet()) {
                if (!Boolean.FALSE.equals(treeMap.get(object2))) continue;
                stack.push(object2);
                treeMap.put(object2, Boolean.TRUE);
                --n;
                break;
            }
            object2 = this.create();
            while (!stack.empty()) {
                Triangle triangle = (Triangle)stack.pop();
                ((VETMesh)object2).insertTriangle(triangle);
                for (int i = 0; i < 3; ++i) {
                    Edge edge = new Edge(triangle.vert[i], triangle.vert[(i + 1) % 3]);
                    EdgeAttribute edgeAttribute = this.edgeMap.get(edge);
                    ExVector exVector = (ExVector)edgeAttribute.triangleSet.clone();
                    for (Triangle triangle2 : exVector) {
                        if (!Boolean.FALSE.equals(treeMap.get(triangle2))) continue;
                        stack.push(triangle2);
                        treeMap.put(triangle2, Boolean.TRUE);
                        --n;
                    }
                }
            }
            vector.add((VETMesh)object2);
        }
    }

    public void getComponents(Vector<Integer> vector, int[] nArray) {
        vector.clear();
        int n = this.triangleMap.size();
        if (n == 0) {
            nArray = null;
            return;
        }
        int n2 = 3 * n;
        int n3 = 0;
        nArray = new int[n2];
        TreeMap<Object, Boolean> treeMap = new TreeMap<Object, Boolean>();
        Iterator<Triangle> iterator = this.triangleMap.keySet().iterator();
        while (iterator.hasNext()) {
            treeMap.put(iterator.next(), Boolean.FALSE);
        }
        while (n > 0) {
            Comparable comparable;
            Object object;
            Object object22;
            Stack<Object> stack = new Stack<Object>();
            for (Object object22 : treeMap.keySet()) {
                if (!Boolean.FALSE.equals(treeMap.get(object22))) continue;
                stack.push(object22);
                treeMap.put(object22, Boolean.TRUE);
                --n;
                break;
            }
            object22 = this.create();
            while (!stack.empty()) {
                object = (Triangle)stack.pop();
                ((VETMesh)object22).insertTriangle((Triangle)object);
                for (int i = 0; i < 3; ++i) {
                    comparable = new Edge(((Triangle)object).vert[i], ((Triangle)object).vert[(i + 1) % 3]);
                    EdgeAttribute edgeAttribute = this.edgeMap.get(comparable);
                    ExVector exVector = (ExVector)edgeAttribute.triangleSet.clone();
                    for (Triangle triangle : exVector) {
                        if (!Boolean.FALSE.equals(treeMap.get(triangle))) continue;
                        stack.push(triangle);
                        treeMap.put(triangle, Boolean.TRUE);
                        --n;
                    }
                }
            }
            object = new TreeSet();
            ((VETMesh)object22).getTriangles((Set<Triangle>)object);
            object22 = null;
            vector.add(new Integer(n3));
            Iterator iterator2 = ((TreeSet)object).iterator();
            while (iterator2.hasNext()) {
                comparable = (Triangle)iterator2.next();
                nArray[n3++] = comparable.vert[0];
                nArray[n3++] = comparable.vert[1];
                nArray[n3++] = comparable.vert[2];
            }
        }
        vector.add(new Integer(n2));
    }

    public int removeComponent(int[] nArray) {
        int n = 0;
        int n2 = this.triangleMap.size();
        if (n2 == 0) {
            return n;
        }
        TreeSet<Triangle> treeSet = new TreeSet<Triangle>();
        treeSet.add((Triangle)this.triangleMap.keySet().toArray()[0]);
        while (!treeSet.isEmpty()) {
            Triangle triangle = (Triangle)treeSet.toArray()[0];
            for (int i = 0; i < 3; ++i) {
                Edge edge = new Edge(triangle.vert[i], triangle.vert[(i + 1) % 3]);
                EdgeAttribute edgeAttribute = this.edgeMap.get(edge);
                ExVector exVector = (ExVector)edgeAttribute.triangleSet.clone();
                for (Triangle triangle2 : exVector) {
                    if (triangle2.equals(triangle)) continue;
                    treeSet.add(triangle2);
                }
            }
            nArray[n++] = triangle.vert[0];
            nArray[n++] = triangle.vert[1];
            nArray[n++] = triangle.vert[2];
            treeSet.remove(triangle);
            this.removeTriangle(triangle);
        }
        return n;
    }

    public boolean getConsistentComponents(Vector<VETMesh> vector) {
        if (!this.isManifold()) {
            return false;
        }
        int n = this.triangleMap.size();
        if (n == 0) {
            return true;
        }
        TreeMap<Object, Boolean> treeMap = new TreeMap<Object, Boolean>();
        Iterator<Triangle> iterator = this.triangleMap.keySet().iterator();
        while (iterator.hasNext()) {
            treeMap.put(iterator.next(), Boolean.FALSE);
        }
        while (n > 0) {
            Object object2;
            Stack<Object> stack = new Stack<Object>();
            for (Object object2 : treeMap.keySet()) {
                if (!Boolean.FALSE.equals(treeMap.get(object2))) continue;
                stack.push(object2);
                treeMap.put(object2, Boolean.TRUE);
                --n;
                break;
            }
            object2 = this.create();
            while (!stack.empty()) {
                Triangle triangle = (Triangle)stack.pop();
                ((VETMesh)object2).insertTriangle(triangle);
                for (int i = 0; i < 3; ++i) {
                    int n2 = triangle.vert[i];
                    int n3 = triangle.vert[(i + 1) % 3];
                    Edge edge = new Edge(n2, n3);
                    EdgeAttribute edgeAttribute = this.edgeMap.get(edge);
                    int n4 = edgeAttribute.triangleSet.size();
                    Triangle triangle2 = (Triangle)edgeAttribute.triangleSet.toArray()[0];
                    if (n4 != 2) continue;
                    if (triangle2.equals(triangle)) {
                        triangle2 = (Triangle)edgeAttribute.triangleSet.toArray()[1];
                    }
                    if (!Boolean.FALSE.equals(treeMap.get(triangle2))) continue;
                    if (triangle2.vert[0] == n2 && triangle2.vert[1] == n3 || triangle2.vert[1] == n2 && triangle2.vert[2] == n3 || triangle2.vert[2] == n2 && triangle2.vert[0] == n3) {
                        n2 = triangle2.vert[0];
                        n3 = triangle2.vert[1];
                        int n5 = triangle2.vert[2];
                        treeMap.remove(triangle2);
                        this.removeTriangle(n2, n3, n5);
                        this.insertTriangle(n3, n2, n5);
                        treeMap.put(new Triangle(n3, n2, n5), Boolean.FALSE);
                        edgeAttribute = this.edgeMap.get(edge);
                        triangle2 = (Triangle)edgeAttribute.triangleSet.toArray()[0];
                        if (triangle2 == triangle) {
                            triangle2 = (Triangle)edgeAttribute.triangleSet.toArray()[1];
                        }
                    }
                    stack.push(triangle2);
                    treeMap.put(triangle2, Boolean.TRUE);
                    --n;
                }
            }
            vector.add((VETMesh)object2);
        }
        return true;
    }

    public VETMesh getReversedOrderMesh() {
        VETMesh vETMesh = this.create();
        for (Triangle triangle : this.triangleMap.keySet()) {
            vETMesh.insertTriangle(triangle.vert[0], triangle.vert[2], triangle.vert[1]);
        }
        return vETMesh;
    }

    public void getVertices(Set<Integer> set) {
        set.clear();
        Iterator<Integer> iterator = this.vertexMap.keySet().iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
    }

    public Object getData(int n) {
        VertexAttribute vertexAttribute = this.vertexMap.get(new Integer(n));
        return vertexAttribute != null ? vertexAttribute.data : null;
    }

    public ExVector getEdges(int n) {
        VertexAttribute vertexAttribute = this.vertexMap.get(new Integer(n));
        return vertexAttribute != null ? vertexAttribute.edgeSet : null;
    }

    public ExVector getTriangles(int n) {
        VertexAttribute vertexAttribute = this.vertexMap.get(new Integer(n));
        return vertexAttribute != null ? vertexAttribute.triangleSet : null;
    }

    public void getEdges(Set<Edge> set) {
        set.clear();
        Iterator<Edge> iterator = this.edgeMap.keySet().iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
    }

    public Object getData(int n, int n2) {
        EdgeAttribute edgeAttribute = this.edgeMap.get(new Edge(n, n2));
        return edgeAttribute != null ? edgeAttribute.data : null;
    }

    public Object getData(Edge edge) {
        return this.getData(edge.vert[0], edge.vert[1]);
    }

    public void getTriangles(Set<Triangle> set) {
        set.clear();
        Iterator<Triangle> iterator = this.triangleMap.keySet().iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
    }

    public Object getData(int n, int n2, int n3) {
        TriangleAttribute triangleAttribute = this.triangleMap.get(new Triangle(n, n2, n3));
        return triangleAttribute != null ? triangleAttribute.data : null;
    }

    public void setData(int n, int n2, int n3, Object object) {
        TriangleAttribute triangleAttribute = this.triangleMap.get(new Triangle(n, n2, n3));
        if (triangleAttribute != null) {
            triangleAttribute.data = object;
        }
    }

    public Object getData(Triangle triangle) {
        return this.getData(triangle.vert[0], triangle.vert[1], triangle.vert[2]);
    }

    public void setData(Triangle triangle, Object object) {
        this.setData(triangle.vert[0], triangle.vert[1], triangle.vert[2], object);
    }

    public class TriangleAttribute {
        public Object data = null;
    }

    public class EdgeAttribute {
        public ExVector triangleSet = new ExVector(2, 2);
        public Object data = null;
    }

    public class VertexAttribute {
        public ExVector edgeSet = new ExVector(8, 8);
        public ExVector triangleSet = new ExVector(8, 8);
        public Object data = null;
    }

    public class Triangle
    implements Comparable {
        public int[] vert = new int[3];

        public Triangle(int n, int n2, int n3) {
            if (n < n2) {
                if (n < n3) {
                    this.vert[0] = n;
                    this.vert[1] = n2;
                    this.vert[2] = n3;
                } else {
                    this.vert[0] = n3;
                    this.vert[1] = n;
                    this.vert[2] = n2;
                }
            } else if (n2 < n3) {
                this.vert[0] = n2;
                this.vert[1] = n3;
                this.vert[2] = n;
            } else {
                this.vert[0] = n3;
                this.vert[1] = n;
                this.vert[2] = n2;
            }
        }

        public boolean lessThan(Triangle triangle) {
            if (this.vert[2] < triangle.vert[2]) {
                return true;
            }
            if (this.vert[2] == triangle.vert[2]) {
                if (this.vert[1] < triangle.vert[1]) {
                    return true;
                }
                if (this.vert[1] == triangle.vert[1]) {
                    return this.vert[0] < triangle.vert[0];
                }
            }
            return false;
        }

        public boolean equals(Object object) {
            Triangle triangle = (Triangle)object;
            return this.vert[0] == triangle.vert[0] && (this.vert[1] == triangle.vert[1] && this.vert[2] == triangle.vert[2] || this.vert[1] == triangle.vert[2] && this.vert[2] == triangle.vert[1]);
        }

        public int compareTo(Object object) {
            Triangle triangle = (Triangle)object;
            if (this.lessThan(triangle)) {
                return -1;
            }
            if (this.equals(triangle)) {
                return 0;
            }
            return 1;
        }
    }

    public class Edge
    implements Comparable {
        int[] vert = new int[2];

        public Edge(int n, int n2) {
            if (n < n2) {
                this.vert[0] = n;
                this.vert[1] = n2;
            } else {
                this.vert[0] = n2;
                this.vert[1] = n;
            }
        }

        public boolean lessThan(Edge edge) {
            if (this.vert[1] < edge.vert[1]) {
                return true;
            }
            if (this.vert[1] == edge.vert[1]) {
                return this.vert[0] < edge.vert[0];
            }
            return false;
        }

        public boolean equals(Object object) {
            Edge edge = (Edge)object;
            return this.vert[0] == edge.vert[0] && this.vert[1] == edge.vert[1];
        }

        public int compareTo(Object object) {
            Edge edge = (Edge)object;
            if (this.lessThan(edge)) {
                return -1;
            }
            if (this.equals(edge)) {
                return 0;
            }
            return 1;
        }
    }
}

