/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.bounding.BoundingVolume;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Arrow;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class AxisRods
extends Node {
    private static final long serialVersionUID = 1L;
    protected static final ColorRGBA xAxisColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.4f);
    protected static final ColorRGBA yAxisColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.25f);
    protected static final ColorRGBA zAxisColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 0.4f);
    protected float baseScale = 1.0f;
    protected boolean rightHanded = true;
    protected Arrow xAxis;
    protected Arrow yAxis;
    protected Arrow zAxis;

    public AxisRods() {
    }

    public AxisRods(String string) {
        super(string);
    }

    public AxisRods(String string, boolean bl, float f) {
        super(string);
        this.rightHanded = bl;
        this.baseScale = f;
        this.setLightCombineMode(0);
        this.setTextureCombineMode(0);
        this.buildAxis();
    }

    protected void buildAxis() {
        this.xAxis = new Arrow("xAxis", this.baseScale, this.baseScale * 0.125f);
        this.xAxis.setSolidColor(xAxisColor);
        this.xAxis.getLocalRotation().fromAngles(0.0f, 0.0f, -1.5707964f);
        this.xAxis.getLocalTranslation().addLocal(this.baseScale * 0.5f, 0.0f, 0.0f);
        this.attachChild(this.xAxis);
        this.yAxis = new Arrow("yAxis", this.baseScale, this.baseScale * 0.125f);
        this.yAxis.setSolidColor(yAxisColor);
        this.yAxis.getLocalTranslation().addLocal(0.0f, this.baseScale * 0.5f, 0.0f);
        this.attachChild(this.yAxis);
        this.zAxis = new Arrow("zAxis", this.baseScale, this.baseScale * 0.125f);
        this.zAxis.setSolidColor(zAxisColor);
        if (this.rightHanded) {
            this.zAxis.getLocalRotation().fromAngles(1.5707964f, 0.0f, 0.0f);
            this.zAxis.getLocalTranslation().addLocal(0.0f, 0.0f, this.baseScale * 0.5f);
        } else {
            this.zAxis.getLocalRotation().fromAngles(-1.5707964f, 0.0f, 0.0f);
            this.zAxis.getLocalTranslation().addLocal(0.0f, 0.0f, -this.baseScale * 0.5f);
        }
        this.attachChild(this.zAxis);
    }

    public void setModelBound(BoundingVolume boundingVolume) {
        this.xAxis.setModelBound(boundingVolume);
        this.yAxis.setModelBound(boundingVolume);
        this.zAxis.setModelBound(boundingVolume);
    }

    public void updateModelBound() {
        this.xAxis.updateModelBound();
        this.yAxis.updateModelBound();
        this.zAxis.updateModelBound();
    }

    public float getBaseScale() {
        return this.baseScale;
    }

    public void setBaseScale(float f) {
        this.baseScale = f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.baseScale, "baseScale", 1.0f);
        outputCapsule.write(this.rightHanded, "rightHanded", true);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.baseScale = inputCapsule.readFloat("baseScale", 1.0f);
        this.rightHanded = inputCapsule.readBoolean("rightHanded", true);
        this.buildAxis();
    }
}

