/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Capsule
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int axisSamples;
    private int radialSamples;
    private int sphereSamples;
    private float radius;
    private float height;

    public Capsule() {
    }

    public Capsule(String string, int n, int n2, int n3, float f, float f2) {
        super(string);
        this.axisSamples = n;
        this.sphereSamples = n3;
        this.radialSamples = n2;
        this.radius = f;
        this.height = f2;
        this.recreateBuffers();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
        this.recreateBuffers();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.setGeometryData();
    }

    private void recreateBuffers() {
        TriangleBatch triangleBatch = this.getBatch(0);
        int n = 2 * this.sphereSamples - 1 + this.axisSamples;
        int n2 = (this.radialSamples + 1) * n + 2;
        triangleBatch.setVertexCount(n2);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        int n3 = 2 * this.radialSamples * n;
        triangleBatch.setTriangleQuantity(n3);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), 3 * triangleBatch.getTriangleCount()));
        this.setGeometryData();
        this.setIndexData();
        this.setDefaultColor(ColorRGBA.white);
    }

    private void setGeometryData() {
        float f;
        float f2;
        float f3;
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        FloatBuffer floatBuffer2 = triangleBatch.getNormalBuffer();
        FloatBuffer floatBuffer3 = triangleBatch.getTextureBuffer(0);
        floatBuffer.rewind();
        floatBuffer2.rewind();
        floatBuffer3.rewind();
        float f4 = 1.0f / (float)this.radialSamples;
        float f5 = 1.0f / (float)this.sphereSamples;
        float f6 = 0.5f * this.height;
        float[] fArray = new float[this.radialSamples + 1];
        float[] fArray2 = new float[this.radialSamples + 1];
        for (int i = 0; i < this.radialSamples; ++i) {
            float f7 = (float)Math.PI * 2 * f4 * (float)i;
            fArray2[i] = FastMath.cos(f7);
            fArray[i] = FastMath.sin(f7);
        }
        fArray[this.radialSamples] = fArray[0];
        fArray2[this.radialSamples] = fArray2[0];
        Vector3f vector3f = new Vector3f();
        floatBuffer.put(0.0f).put(this.radius + f6).put(0.0f);
        floatBuffer2.put(0.0f).put(1.0f).put(0.0f);
        floatBuffer3.put(1.0f).put(1.0f);
        for (n = 0; n < this.sphereSamples; ++n) {
            f3 = this.radius * (1.0f - (float)(n + 1) * f5);
            f2 = (f3 + this.height + this.radius) / (this.height + 2.0f * this.radius);
            float f8 = FastMath.sqrt(FastMath.abs(this.radius * this.radius - f3 * f3));
            for (int i = 0; i <= this.radialSamples; ++i) {
                Vector3f vector3f2 = vector3f.set(fArray2[i], 0.0f, fArray[i]);
                vector3f2.multLocal(f8);
                floatBuffer.put(vector3f2.x).put(f3 + f6).put(vector3f2.z);
                vector3f2.y = f3;
                vector3f2.normalizeLocal();
                floatBuffer2.put(vector3f2.x).put(vector3f2.y).put(vector3f2.z);
                f = 1.0f - (float)i * f4;
                floatBuffer3.put(f).put(f2);
            }
        }
        for (n = 1; n < this.axisSamples; ++n) {
            f3 = f6 - (float)n * this.height / (float)this.axisSamples;
            f2 = (f3 + f6 + this.radius) / (this.height + 2.0f * this.radius);
            for (int i = 0; i <= this.radialSamples; ++i) {
                Vector3f vector3f3 = vector3f.set(fArray2[i], 0.0f, fArray[i]);
                vector3f3.multLocal(this.radius);
                floatBuffer.put(vector3f3.x).put(f3).put(vector3f3.z);
                vector3f3.normalizeLocal();
                floatBuffer2.put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                float f9 = 1.0f - (float)i * f4;
                floatBuffer3.put(f9).put(f2);
            }
        }
        for (n = 0; n < this.sphereSamples; ++n) {
            f3 = (float)n * (this.radius / (float)this.sphereSamples);
            f2 = (this.radius - f3) / (this.height + 2.0f * this.radius);
            float f10 = FastMath.sqrt(FastMath.abs(this.radius * this.radius - f3 * f3));
            for (int i = 0; i <= this.radialSamples; ++i) {
                Vector3f vector3f4 = vector3f.set(fArray2[i], 0.0f, fArray[i]);
                vector3f4.multLocal(f10);
                floatBuffer.put(vector3f4.x).put(-f3 - f6).put(vector3f4.z);
                vector3f4.y = -f3;
                vector3f4.normalizeLocal();
                floatBuffer2.put(vector3f4.x).put(vector3f4.y).put(vector3f4.z);
                f = 1.0f - (float)i * f4;
                floatBuffer3.put(f).put(f2);
            }
        }
        floatBuffer.put(0.0f).put(-this.radius - f6).put(0.0f);
        floatBuffer2.put(0.0f).put(-1.0f).put(0.0f);
        floatBuffer3.put(0.0f).put(0.0f);
    }

    private void setIndexData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        TriangleBatch triangleBatch = this.getBatch(0);
        for (n5 = 1; n5 <= this.radialSamples; ++n5) {
            triangleBatch.getIndexBuffer().put(n5 + 1);
            triangleBatch.getIndexBuffer().put(n5);
            triangleBatch.getIndexBuffer().put(0);
        }
        for (n5 = 1; n5 < this.sphereSamples; ++n5) {
            n4 = n5 * (this.radialSamples + 1);
            n3 = (n5 - 1) * (this.radialSamples + 1);
            for (n2 = 1; n2 <= this.radialSamples; ++n2) {
                triangleBatch.getIndexBuffer().put(n3 + n2);
                triangleBatch.getIndexBuffer().put(n3 + n2 + 1);
                triangleBatch.getIndexBuffer().put(n4 + n2);
                triangleBatch.getIndexBuffer().put(n3 + n2 + 1);
                triangleBatch.getIndexBuffer().put(n4 + n2 + 1);
                triangleBatch.getIndexBuffer().put(n4 + n2);
            }
        }
        n5 = this.sphereSamples * (this.radialSamples + 1);
        for (n4 = 0; n4 < this.axisSamples; ++n4) {
            n3 = n5 + n4 * (this.radialSamples + 1);
            n2 = n5 + (n4 - 1) * (this.radialSamples + 1);
            for (n = 1; n <= this.radialSamples; ++n) {
                triangleBatch.getIndexBuffer().put(n2 + n);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n);
            }
        }
        n5 += (this.axisSamples - 1) * (this.radialSamples + 1);
        for (n4 = 1; n4 < this.sphereSamples; ++n4) {
            n3 = n5 + n4 * (this.radialSamples + 1);
            n2 = n5 + (n4 - 1) * (this.radialSamples + 1);
            for (n = 1; n <= this.radialSamples; ++n) {
                triangleBatch.getIndexBuffer().put(n2 + n);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n + 1);
                triangleBatch.getIndexBuffer().put(n3 + n);
            }
        }
        n5 += (this.sphereSamples - 1) * (this.radialSamples + 1);
        for (n4 = 1; n4 <= this.radialSamples; ++n4) {
            triangleBatch.getIndexBuffer().put(n5 + n4);
            triangleBatch.getIndexBuffer().put(n5 + n4 + 1);
            triangleBatch.getIndexBuffer().put(n5 + this.radialSamples + 2);
        }
    }

    public void reconstruct(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.height = vector3f.distance(vector3f2);
        this.radius = f;
        this.setGeometryData();
        vector3f.add(vector3f2, this.localTranslation).multLocal(0.5f);
        Vector3f vector3f3 = vector3f.subtract(this.localTranslation).normalizeLocal();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.fromStartEndVectors(Vector3f.UNIT_Y, vector3f3);
        this.localRotation.fromRotationMatrix(matrix3f);
        this.updateWorldVectors();
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.axisSamples, "axisSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.sphereSamples, "sphereSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.height, "height", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.axisSamples = inputCapsule.readInt("circleSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.sphereSamples = inputCapsule.readInt("sphereSamples", 0);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.height = inputCapsule.readFloat("height", 0.0f);
    }
}

