/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CompositeMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class CompositeSphere
extends CompositeMesh {
    private static final long serialVersionUID = 1L;
    private int zSamples;
    private int radialSamples;
    public float radius;
    public Vector3f center;
    private static Vector3f tempVa = new Vector3f();
    private static Vector3f tempVb = new Vector3f();
    private static Vector3f tempVc = new Vector3f();

    public CompositeSphere() {
    }

    public CompositeSphere(String string) {
        super(string);
    }

    public CompositeSphere(String string, int n, int n2, float f) {
        this(string, new Vector3f(0.0f, 0.0f, 0.0f), n, n2, f);
    }

    public CompositeSphere(String string, Vector3f vector3f, int n, int n2, float f) {
        super(string);
        this.setData(vector3f, n, n2, f, true);
    }

    public void setData(Vector3f vector3f, int n, int n2, float f, boolean bl) {
        this.center = vector3f != null ? vector3f : new Vector3f(0.0f, 0.0f, 0.0f);
        this.zSamples = n;
        this.radialSamples = n2;
        this.radius = f;
        if (bl) {
            this.setGeometryData();
            this.setIndexData();
            this.setDefaultColor(ColorRGBA.white);
        }
    }

    private void setGeometryData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount((this.zSamples - 2) * (this.radialSamples + 1) + 2);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        float f = 1.0f / (float)this.radialSamples;
        float f2 = 2.0f / (float)(this.zSamples - 1);
        float[] fArray = new float[this.radialSamples + 1];
        float[] fArray2 = new float[this.radialSamples + 1];
        for (n = 0; n < this.radialSamples; ++n) {
            float f3 = (float)Math.PI * 2 * f * (float)n;
            fArray2[n] = FastMath.cos(f3);
            fArray[n] = FastMath.sin(f3);
        }
        fArray[this.radialSamples] = fArray[0];
        fArray2[this.radialSamples] = fArray2[0];
        n = 0;
        for (int i = 1; i < this.zSamples - 1; ++i) {
            float f4 = -1.0f + f2 * (float)i;
            float f5 = this.radius * f4;
            Vector3f vector3f = tempVb.set(this.center);
            vector3f.z += f5;
            float f6 = FastMath.sqrt(FastMath.abs(this.radius * this.radius - f5 * f5));
            int n2 = n;
            for (int j = 0; j < this.radialSamples; ++j) {
                float f7 = (float)j * f;
                Vector3f vector3f2 = tempVc.set(fArray2[j], fArray[j], 0.0f);
                vector3f2.mult(f6, tempVa);
                triangleBatch.getVertexBuffer().put(vector3f.x + CompositeSphere.tempVa.x).put(vector3f.y + CompositeSphere.tempVa.y).put(vector3f.z + CompositeSphere.tempVa.z);
                BufferUtils.populateFromBuffer(tempVa, triangleBatch.getVertexBuffer(), n);
                Vector3f vector3f3 = tempVa.subtractLocal(this.center);
                vector3f3.normalizeLocal();
                triangleBatch.getNormalBuffer().put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                triangleBatch.getTextureBuffers().get(0).put(f7).put(0.5f * (f4 + 1.0f));
                ++n;
            }
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n2, n);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n2, n);
            triangleBatch.getTextureBuffers().get(0).put(1.0f).put(0.5f * (f4 + 1.0f));
            ++n;
        }
        triangleBatch.getVertexBuffer().position(n * 3);
        triangleBatch.getVertexBuffer().put(this.center.x).put(this.center.y).put(this.center.z - this.radius);
        triangleBatch.getNormalBuffer().position(n * 3);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
        triangleBatch.getTextureBuffers().get(0).position(n * 2);
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(0.0f);
        ++n;
        triangleBatch.getVertexBuffer().put(this.center.x).put(this.center.y).put(this.center.z + this.radius);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(1.0f);
    }

    private void setIndexData() {
        int n;
        int n2;
        TriangleBatch triangleBatch = this.getBatch(0);
        int n3 = this.zSamples - 3;
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(n3 * 2 * (this.radialSamples + 1) + 2 * (this.radialSamples + 2)));
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n4;
            int n5 = n4 += this.radialSamples + 1;
            for (int i = 0; i <= this.radialSamples; ++i) {
                triangleBatch.getIndexBuffer().put(n + i);
                triangleBatch.getIndexBuffer().put(n5 + i);
            }
        }
        triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 2);
        for (n2 = 0; n2 <= this.radialSamples; ++n2) {
            triangleBatch.getIndexBuffer().put(n2);
        }
        n2 = (this.zSamples - 3) * (this.radialSamples + 1);
        triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 1);
        for (n4 = 0; n4 <= this.radialSamples; ++n4) {
            triangleBatch.getIndexBuffer().put(n4 + n2);
        }
        CompositeMesh.IndexRange[] indexRangeArray = new CompositeMesh.IndexRange[n3 + 2];
        for (n = 0; n < indexRangeArray.length - 2; ++n) {
            indexRangeArray[n] = CompositeMesh.createTriangleStrip(2 * (this.radialSamples + 1));
        }
        indexRangeArray[indexRangeArray.length - 2] = CompositeMesh.createTriangleFan(this.radialSamples + 2);
        indexRangeArray[indexRangeArray.length - 1] = CompositeMesh.createTriangleFan(this.radialSamples + 2);
        this.setIndexRanges(indexRangeArray);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.zSamples, "zSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.zSamples = inputCapsule.readInt("zSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.center = (Vector3f)inputCapsule.readSavable("center", new Vector3f(Vector3f.ZERO));
    }
}

