/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Hexagon
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private static final int NUM_POINTS = 7;
    private static final int NUM_TRIS = 6;
    private float sideLength;

    public Hexagon(String string, float f) {
        super(string);
        this.sideLength = f;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(7);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity(6);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.setVertexData();
        this.setIndexData();
        this.setTextureData();
        this.setNormalData();
        this.setDefaultColor(ColorRGBA.white);
    }

    private void setVertexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getVertexBuffer().put(-(this.sideLength / 2.0f)).put(this.sideLength * 0.866f).put(0.0f);
        triangleBatch.getVertexBuffer().put(this.sideLength / 2.0f).put(this.sideLength * 0.866f).put(0.0f);
        triangleBatch.getVertexBuffer().put(this.sideLength).put(0.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(this.sideLength / 2.0f).put(-this.sideLength * 0.866f).put(0.0f);
        triangleBatch.getVertexBuffer().put(-(this.sideLength / 2.0f)).put(-this.sideLength * 0.866f).put(0.0f);
        triangleBatch.getVertexBuffer().put(-this.sideLength).put(0.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(0.0f).put(0.0f).put(0.0f);
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getIndexBuffer().rewind();
        triangleBatch.getIndexBuffer().put(0);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(1);
        triangleBatch.getIndexBuffer().put(1);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(2);
        triangleBatch.getIndexBuffer().put(2);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(3);
        triangleBatch.getIndexBuffer().put(3);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(4);
        triangleBatch.getIndexBuffer().put(4);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(5);
        triangleBatch.getIndexBuffer().put(5);
        triangleBatch.getIndexBuffer().put(6);
        triangleBatch.getIndexBuffer().put(0);
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getTextureBuffers().get(0).put(0.25f).put(0.0f);
        triangleBatch.getTextureBuffers().get(0).put(0.75f).put(0.0f);
        triangleBatch.getTextureBuffers().get(0).put(1.0f).put(0.5f);
        triangleBatch.getTextureBuffers().get(0).put(0.75f).put(1.0f);
        triangleBatch.getTextureBuffers().get(0).put(0.25f).put(1.0f);
        triangleBatch.getTextureBuffers().get(0).put(0.0f).put(0.5f);
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(0.5f);
    }

    private void setNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
        for (int i = 0; i < 7; ++i) {
            BufferUtils.setInBuffer(vector3f, triangleBatch.getNormalBuffer(), i);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.sideLength, "sideLength", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.sideLength = inputCapsule.readInt("sideLength", 0);
    }
}

