/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Sphere
extends TriMesh {
    private static final long serialVersionUID = 1L;
    public static final int TEX_ORIGINAL = 0;
    public static final int TEX_PROJECTED = 1;
    protected int zSamples;
    protected int radialSamples;
    public float radius;
    public Vector3f center;
    private static Vector3f tempVa = new Vector3f();
    private static Vector3f tempVb = new Vector3f();
    private static Vector3f tempVc = new Vector3f();
    protected int textureMode = 0;

    public Sphere() {
    }

    public Sphere(String string) {
        super(string);
    }

    public Sphere(String string, int n, int n2, float f) {
        this(string, new Vector3f(0.0f, 0.0f, 0.0f), n, n2, f);
    }

    public Sphere(String string, Vector3f vector3f, int n, int n2, float f) {
        super(string);
        this.setData(vector3f, n, n2, f);
    }

    public void setData(Vector3f vector3f, int n, int n2, float f) {
        this.center = vector3f != null ? vector3f : new Vector3f(0.0f, 0.0f, 0.0f);
        this.zSamples = n;
        this.radialSamples = n2;
        this.radius = f;
        this.setGeometryData();
        this.setIndexData();
        this.setDefaultColor(ColorRGBA.white);
    }

    private void setGeometryData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount((this.zSamples - 2) * (this.radialSamples + 1) + 2);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount()));
        float f = 1.0f / (float)this.radialSamples;
        float f2 = 2.0f / (float)(this.zSamples - 1);
        float[] fArray = new float[this.radialSamples + 1];
        float[] fArray2 = new float[this.radialSamples + 1];
        for (n = 0; n < this.radialSamples; ++n) {
            float f3 = (float)Math.PI * 2 * f * (float)n;
            fArray2[n] = FastMath.cos(f3);
            fArray[n] = FastMath.sin(f3);
        }
        fArray[this.radialSamples] = fArray[0];
        fArray2[this.radialSamples] = fArray2[0];
        n = 0;
        for (int i = 1; i < this.zSamples - 1; ++i) {
            float f4 = -1.0f + f2 * (float)i;
            float f5 = this.radius * f4;
            Vector3f vector3f = tempVb.set(this.center);
            vector3f.z += f5;
            float f6 = FastMath.sqrt(FastMath.abs(this.radius * this.radius - f5 * f5));
            int n2 = n;
            for (int j = 0; j < this.radialSamples; ++j) {
                float f7 = (float)j * f;
                Vector3f vector3f2 = tempVc.set(fArray2[j], fArray[j], 0.0f);
                vector3f2.mult(f6, tempVa);
                triangleBatch.getVertexBuffer().put(vector3f.x + Sphere.tempVa.x).put(vector3f.y + Sphere.tempVa.y).put(vector3f.z + Sphere.tempVa.z);
                BufferUtils.populateFromBuffer(tempVa, triangleBatch.getVertexBuffer(), n);
                Vector3f vector3f3 = tempVa.subtractLocal(this.center);
                vector3f3.normalizeLocal();
                triangleBatch.getNormalBuffer().put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                if (this.textureMode == 0) {
                    triangleBatch.getTextureBuffers().get(0).put(f7).put(0.5f * (f4 + 1.0f));
                } else if (this.textureMode == 1) {
                    triangleBatch.getTextureBuffers().get(0).put(f7).put(0.31830987f * (1.5707964f + FastMath.asin(f4)));
                }
                ++n;
            }
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n2, n);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n2, n);
            if (this.textureMode == 0) {
                triangleBatch.getTextureBuffers().get(0).put(1.0f).put(0.5f * (f4 + 1.0f));
            } else if (this.textureMode == 1) {
                triangleBatch.getTextureBuffers().get(0).put(1.0f).put(0.31830987f * (1.5707964f + FastMath.asin(f4)));
            }
            ++n;
        }
        triangleBatch.getVertexBuffer().position(n * 3);
        triangleBatch.getVertexBuffer().put(this.center.x).put(this.center.y).put(this.center.z - this.radius);
        triangleBatch.getNormalBuffer().position(n * 3);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
        triangleBatch.getTextureBuffers().get(0).position(n * 2);
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(0.0f);
        ++n;
        triangleBatch.getVertexBuffer().put(this.center.x).put(this.center.y).put(this.center.z + this.radius);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(1.0f);
    }

    private void setIndexData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setTriangleQuantity(2 * (this.zSamples - 2) * this.radialSamples);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.zSamples - 3; ++n) {
            int n4 = n3;
            int n5 = n4 + 1;
            int n6 = n3 += this.radialSamples + 1;
            int n7 = n6 + 1;
            int n8 = 0;
            while (n8 < this.radialSamples) {
                triangleBatch.getIndexBuffer().put(n4++);
                triangleBatch.getIndexBuffer().put(n5);
                triangleBatch.getIndexBuffer().put(n6);
                triangleBatch.getIndexBuffer().put(n5++);
                triangleBatch.getIndexBuffer().put(n7++);
                triangleBatch.getIndexBuffer().put(n6++);
                ++n8;
                n2 += 6;
            }
        }
        n = 0;
        while (n < this.radialSamples) {
            triangleBatch.getIndexBuffer().put(n);
            triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 2);
            triangleBatch.getIndexBuffer().put(n + 1);
            ++n;
            n2 += 3;
        }
        n = (this.zSamples - 3) * (this.radialSamples + 1);
        n3 = 0;
        while (n3 < this.radialSamples) {
            triangleBatch.getIndexBuffer().put(n3 + n);
            triangleBatch.getIndexBuffer().put(n3 + 1 + n);
            triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 1);
            ++n3;
            n2 += 3;
        }
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public int getTextureMode() {
        return this.textureMode;
    }

    public void setTextureMode(int n) {
        this.textureMode = n;
        this.setGeometryData();
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.zSamples, "zSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
        outputCapsule.write(this.textureMode, "textureMode", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.zSamples = inputCapsule.readInt("zSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.center = (Vector3f)inputCapsule.readSavable("center", new Vector3f(Vector3f.ZERO));
        this.textureMode = inputCapsule.readInt("textureMode", 0);
    }
}

