/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public abstract class ClipState
extends RenderState {
    public static final int CLIP_PLANE0 = 0;
    public static final int CLIP_PLANE1 = 1;
    public static final int CLIP_PLANE2 = 2;
    public static final int CLIP_PLANE3 = 3;
    public static final int CLIP_PLANE4 = 4;
    public static final int CLIP_PLANE5 = 5;
    public static final int MAX_CLIP_PLANES = 6;
    protected boolean[] enabledClipPlanes = new boolean[6];
    protected double[][] planeEquations = new double[6][4];

    public int getType() {
        return 16;
    }

    public void setEnableClipPlane(int n, boolean bl) {
        if (n < 0 || n >= 6) {
            return;
        }
        this.enabledClipPlanes[n] = bl;
        this.setNeedsRefresh(true);
    }

    public void setClipPlaneEquation(int n, double d, double d2, double d3, double d4) {
        if (n < 0 || n >= 6) {
            return;
        }
        this.planeEquations[n][0] = d;
        this.planeEquations[n][1] = d2;
        this.planeEquations[n][2] = d3;
        this.planeEquations[n][3] = d4;
        this.setNeedsRefresh(true);
    }

    public boolean getPlaneEnabled(int n) {
        return this.enabledClipPlanes[n];
    }

    public double getPlaneEq(int n, int n2) {
        return this.planeEquations[n][n2];
    }

    public void setPlaneEq(int n, int n2, double d) {
        this.planeEquations[n][n2] = d;
        this.setNeedsRefresh(true);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.enabledClipPlanes, "enabledClipPlanes", new boolean[6]);
        outputCapsule.write(this.planeEquations, "planeEquations", new double[6][4]);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.enabledClipPlanes = inputCapsule.readBooleanArray("enabledClipPlanes", new boolean[6]);
        this.planeEquations = inputCapsule.readDoubleArray2D("planeEquations", new double[6][4]);
    }

    public Class getClassTag() {
        return ClipState.class;
    }
}

