/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public abstract class MaterialState
extends RenderState {
    public static final int CM_NONE = 0;
    public static final int CM_AMBIENT = 1;
    public static final int CM_DIFFUSE = 2;
    public static final int CM_AMBIENT_AND_DIFFUSE = 3;
    public static final int CM_SPECULAR = 4;
    public static final int CM_EMISSIVE = 5;
    public static final int MF_FRONT = 0;
    public static final int MF_BACK = 1;
    public static final int MF_FRONT_AND_BACK = 2;
    public static final ColorRGBA defaultAmbient = new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f);
    public static final ColorRGBA defaultDiffuse = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    public static final ColorRGBA defaultSpecular = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA defaultEmissive = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final float defaultShininess = 0.0f;
    public static final int defaultColorMaterial = 0;
    public static final int defaultMaterialFace = 0;
    protected ColorRGBA ambient;
    protected ColorRGBA diffuse;
    protected ColorRGBA specular;
    protected ColorRGBA emissive = defaultEmissive.clone();
    protected float shininess = 0.0f;
    protected int colorMaterial = 0;
    protected int materialFace = 0;

    public MaterialState() {
        this.ambient = defaultAmbient.clone();
        this.diffuse = defaultDiffuse.clone();
        this.specular = defaultSpecular.clone();
    }

    public ColorRGBA getAmbient() {
        return this.ambient;
    }

    public void setAmbient(ColorRGBA colorRGBA) {
        this.ambient.set(colorRGBA);
        this.setNeedsRefresh(true);
    }

    public ColorRGBA getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(ColorRGBA colorRGBA) {
        this.diffuse.set(colorRGBA);
        this.setNeedsRefresh(true);
    }

    public ColorRGBA getEmissive() {
        return this.emissive;
    }

    public void setEmissive(ColorRGBA colorRGBA) {
        this.emissive.set(colorRGBA);
        this.setNeedsRefresh(true);
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setShininess(float f) {
        this.shininess = f;
        this.setNeedsRefresh(true);
    }

    public ColorRGBA getSpecular() {
        return this.specular;
    }

    public void setSpecular(ColorRGBA colorRGBA) {
        this.specular.set(colorRGBA);
        this.setNeedsRefresh(true);
    }

    public int getColorMaterial() {
        return this.colorMaterial;
    }

    public void setColorMaterial(int n) {
        this.colorMaterial = n;
        this.setNeedsRefresh(true);
    }

    public int getMaterialFace() {
        return this.materialFace;
    }

    public void setMaterialFace(int n) {
        this.materialFace = n;
        this.setNeedsRefresh(true);
    }

    public int getType() {
        return 4;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.ambient, "ambient", ColorRGBA.black);
        outputCapsule.write(this.diffuse, "diffuse", ColorRGBA.black);
        outputCapsule.write(this.specular, "specular", ColorRGBA.black);
        outputCapsule.write(this.emissive, "emissive", ColorRGBA.black);
        outputCapsule.write(this.shininess, "shininess", 0.0f);
        outputCapsule.write(this.colorMaterial, "colorMaterial", 0);
        outputCapsule.write(this.materialFace, "materialFace", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.ambient = (ColorRGBA)inputCapsule.readSavable("ambient", new ColorRGBA(ColorRGBA.black));
        this.diffuse = (ColorRGBA)inputCapsule.readSavable("diffuse", new ColorRGBA(ColorRGBA.black));
        this.specular = (ColorRGBA)inputCapsule.readSavable("specular", new ColorRGBA(ColorRGBA.black));
        this.emissive = (ColorRGBA)inputCapsule.readSavable("emissive", new ColorRGBA(ColorRGBA.black));
        this.shininess = inputCapsule.readFloat("shininess", 0.0f);
        this.colorMaterial = inputCapsule.readInt("colorMaterial", 0);
        this.materialFace = inputCapsule.readInt("materialFace", 0);
    }

    public Class getClassTag() {
        return MaterialState.class;
    }
}

