/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.image.Texture;
import com.jme.scene.state.RenderState;
import com.jme.util.TextureManager;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;

public abstract class TextureState
extends RenderState {
    public static Texture defaultTexture = null;
    public static final int OFF = 0;
    public static final int COMBINE_FIRST = 1;
    public static final int COMBINE_CLOSEST = 2;
    public static final int COMBINE_RECENT_ENABLED = 3;
    public static final int INHERIT = 4;
    public static final int REPLACE = 5;
    public static final int CM_AFFINE = 0;
    public static final int CM_PERSPECTIVE = 1;
    protected transient ArrayList<Texture> texture;
    protected static int numTotalTexUnits = -1;
    protected static int numFixedTexUnits = -1;
    protected static int numVertexTexUnits = -1;
    protected static int numFragmentTexUnits = -1;
    protected static float maxAnisotropic = -1.0f;
    protected static boolean supportsMultiTexture = false;
    protected static boolean supportsEnvDot3 = false;
    protected static boolean supportsAniso = false;
    protected static boolean supportsNonPowerTwo = false;
    protected static boolean supportsS3TCCompression = false;
    protected transient int firstTexture = 0;
    protected transient int lastTexture = 0;
    private int correction = 1;
    protected int offset = 0;
    protected transient int[] idCache = new int[0];

    public TextureState() {
        if (defaultTexture == null) {
            try {
                defaultTexture = TextureManager.loadTexture(TextureState.class.getResource("notloaded.png"), 2, 1, 1.0f, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getType() {
        return 6;
    }

    public void setTexture(Texture texture) {
        if (this.texture.size() == 0) {
            this.texture.add(texture);
        } else {
            this.texture.set(0, texture);
        }
        this.setNeedsRefresh(true);
        this.resetFirstLast();
    }

    public Texture getTexture() {
        if (this.texture.size() > 0) {
            return this.texture.get(0);
        }
        return null;
    }

    public void setTexture(Texture texture, int n) {
        if (n >= 0 && n < numTotalTexUnits) {
            while (n >= this.texture.size()) {
                this.texture.add(null);
            }
            this.texture.set(n, texture);
            this.resetFirstLast();
        }
        this.setNeedsRefresh(true);
    }

    public Texture getTexture(int n) {
        if (n < this.texture.size() && n >= 0) {
            return this.texture.get(n);
        }
        return null;
    }

    public boolean removeTexture(Texture texture) {
        int n = this.texture.indexOf(texture);
        if (n == -1) {
            return false;
        }
        this.texture.set(n, null);
        this.idCache[n] = 0;
        return true;
    }

    public boolean removeTexture(int n) {
        if (n >= 0 && n < numTotalTexUnits && n < this.texture.size()) {
            return false;
        }
        Texture texture = this.getTexture(n);
        if (texture == null) {
            return false;
        }
        return this.removeTexture(texture);
    }

    public void setCorrection(int n) {
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.correction = n;
        this.setNeedsRefresh(true);
    }

    public int getCorrection() {
        return this.correction;
    }

    public static int getTotalNumberOfUnits() {
        return numTotalTexUnits;
    }

    @Deprecated
    public static int getNumberOfUnits() {
        return TextureState.getNumberOfFixedUnits();
    }

    public static int getNumberOfFixedUnits() {
        return numFixedTexUnits;
    }

    public static int getNumberOfVertexUnits() {
        return numVertexTexUnits;
    }

    public static int getNumberOfFragmentUnits() {
        return numFragmentTexUnits;
    }

    public static int getNumberOfTotalUnits() {
        return numTotalTexUnits;
    }

    public int getNumberOfSetTextures() {
        return this.texture.size();
    }

    public final int getTextureID(int n) {
        if (n < this.idCache.length && n >= 0) {
            return this.idCache[n];
        }
        return 0;
    }

    public void setTextureCoordinateOffset(int n) {
        this.offset = n;
        this.setNeedsRefresh(true);
    }

    public int getTextureCoordinateOffset() {
        return this.offset;
    }

    public void load() {
        for (int i = 0; i < numTotalTexUnits; ++i) {
            if (this.getTexture(i) == null) continue;
            this.load(i);
        }
    }

    public abstract void load(int var1);

    public abstract void delete(int var1);

    public abstract void deleteAll();

    public abstract void deleteAll(boolean var1);

    public float getMaxAnisotropic() {
        return maxAnisotropic;
    }

    public boolean isS3TCAvailable() {
        return supportsS3TCCompression;
    }

    protected void resetFirstLast() {
        boolean bl = false;
        for (int i = 0; i < this.texture.size(); ++i) {
            if (this.texture.get(i) == null) continue;
            if (!bl) {
                this.firstTexture = i;
                bl = true;
            }
            this.lastTexture = i;
        }
        if (this.idCache == null || this.idCache.length <= this.lastTexture) {
            if (this.idCache == null || this.idCache.length == 0) {
                this.idCache = new int[this.lastTexture + 2];
            } else {
                int[] nArray = new int[this.lastTexture + 2];
                System.arraycopy(this.idCache, 0, nArray, 0, this.idCache.length);
                this.idCache = nArray;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readShort();
        this.texture = new ArrayList(1);
        for (int i = 0; i < n; ++i) {
            if (!objectInputStream.readBoolean()) continue;
            this.texture.add(TextureManager.loadTexture(new URL(objectInputStream.readUTF()), objectInputStream.readInt(), objectInputStream.readInt()));
        }
        this.resetFirstLast();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(this.texture.size());
        for (int i = 0; i < this.texture.size(); ++i) {
            if (this.texture.get(i) == null) {
                objectOutputStream.writeBoolean(false);
                continue;
            }
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(this.texture.get(i).getImageLocation());
            objectOutputStream.writeInt(this.texture.get(i).getMipmapState());
            objectOutputStream.writeInt(this.texture.get(i).getFilter());
        }
    }

    public static boolean isSupportingNonPowerOfTwoTextureSize() {
        return supportsNonPowerTwo;
    }

    public static void forceNonPowerOfTwoTextureSizeUsage() {
        supportsNonPowerTwo = true;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.texture, "texture", new ArrayList(1));
        outputCapsule.write(this.offset, "offset", 0);
        outputCapsule.write(this.correction, "correction", 1);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.texture = inputCapsule.readSavableArrayList("texture", new ArrayList(1));
        this.offset = inputCapsule.readInt("offset", 0);
        this.correction = inputCapsule.readInt("correction", 1);
        this.resetFirstLast();
    }

    public Class getClassTag() {
        return TextureState.class;
    }

    public void deleteTextureId(int n) {
    }
}

