/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.lwjgl.records.ShaderObjectsStateRecord;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.system.DisplaySystem;
import com.jme.util.LoggingSystem;
import com.jme.util.ShaderAttribute;
import com.jme.util.ShaderUniform;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.GLContext;

public class LWJGLShaderObjectsState
extends GLSLShaderObjectsState {
    private static final long serialVersionUID = 1L;
    private int programID = -1;
    private int vertexShaderID = -1;
    private int fragmentShaderID = -1;

    public boolean isSupported() {
        return GLContext.getCapabilities().GL_ARB_shader_objects && GLContext.getCapabilities().GL_ARB_fragment_shader && GLContext.getCapabilities().GL_ARB_vertex_shader && GLContext.getCapabilities().GL_ARB_shading_language_100;
    }

    public void relinkProgram() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)64);
        int n = this.attribs.size();
        for (int i = 0; i < n; ++i) {
            ShaderAttribute shaderAttribute = (ShaderAttribute)this.attribs.get(i);
            byteBuffer.clear();
            byteBuffer.put(shaderAttribute.name.getBytes());
            byteBuffer.rewind();
            shaderAttribute.attributeID = i + 1;
            ARBVertexShader.glBindAttribLocationARB((int)this.programID, (int)(i + 1), (ByteBuffer)byteBuffer);
        }
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
    }

    private int getUniLoc(ShaderUniform shaderUniform) {
        if (shaderUniform.uniformID == -1) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(shaderUniform.name.getBytes().length + 1));
            byteBuffer.clear();
            byteBuffer.put(shaderUniform.name.getBytes());
            byteBuffer.rewind();
            shaderUniform.uniformID = ARBShaderObjects.glGetUniformLocationARB((int)this.programID, (ByteBuffer)byteBuffer);
        }
        return shaderUniform.uniformID;
    }

    private ByteBuffer load(URL uRL) {
        try {
            byte[] byArray = null;
            ByteBuffer byteBuffer = null;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            byArray = new byte[bufferedInputStream.available()];
            dataInputStream.readFully(byArray);
            bufferedInputStream.close();
            dataInputStream.close();
            byteBuffer = BufferUtils.createByteBuffer((int)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            return byteBuffer;
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Could not load shader object: " + exception);
            LoggingSystem.getLogger().throwing(this.getClass().getName(), "load(URL)", exception);
            return null;
        }
    }

    private ByteBuffer load(String string) {
        try {
            byte[] byArray = string.getBytes();
            System.out.println("bytes length " + byArray.length);
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            return byteBuffer;
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Could not load fragment program: " + exception);
            LoggingSystem.getLogger().throwing(this.getClass().getName(), "load(URL)", exception);
            return null;
        }
    }

    public void load(URL uRL, URL uRL2) {
        ByteBuffer byteBuffer = uRL != null ? this.load(uRL) : null;
        ByteBuffer byteBuffer2 = uRL2 != null ? this.load(uRL2) : null;
        this.load(byteBuffer, byteBuffer2);
    }

    public void load(String string, String string2) {
        ByteBuffer byteBuffer = string != null ? this.load(string) : null;
        ByteBuffer byteBuffer2 = string2 != null ? this.load(string2) : null;
        this.load(byteBuffer, byteBuffer2);
    }

    private void load(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        IntBuffer intBuffer;
        if (byteBuffer == null && byteBuffer2 == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not find shader resources! (both inputbuffers are null)");
            return;
        }
        if (this.programID == -1) {
            this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        }
        if (byteBuffer != null) {
            if (this.vertexShaderID != -1) {
                this.removeVertShader();
            }
            this.vertexShaderID = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
            ARBShaderObjects.glShaderSourceARB((int)this.vertexShaderID, (ByteBuffer)byteBuffer);
            intBuffer = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glCompileShaderARB((int)this.vertexShaderID);
            ARBShaderObjects.glGetObjectParameterARB((int)this.vertexShaderID, (int)35713, (IntBuffer)intBuffer);
            this.checkProgramError(intBuffer, this.vertexShaderID);
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.vertexShaderID);
        } else if (this.vertexShaderID != -1) {
            this.removeVertShader();
            this.vertexShaderID = -1;
        }
        if (byteBuffer2 != null) {
            if (this.fragmentShaderID != -1) {
                this.removeFragShader();
            }
            this.fragmentShaderID = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
            ARBShaderObjects.glShaderSourceARB((int)this.fragmentShaderID, (ByteBuffer)byteBuffer2);
            intBuffer = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glCompileShaderARB((int)this.fragmentShaderID);
            ARBShaderObjects.glGetObjectParameterARB((int)this.fragmentShaderID, (int)35713, (IntBuffer)intBuffer);
            this.checkProgramError(intBuffer, this.fragmentShaderID);
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.fragmentShaderID);
        } else if (this.fragmentShaderID != -1) {
            this.removeFragShader();
            this.fragmentShaderID = -1;
        }
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        this.setNeedsRefresh(true);
    }

    private void removeFragShader() {
        if (this.fragmentShaderID != -1) {
            ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.fragmentShaderID);
            ARBShaderObjects.glDeleteObjectARB((int)this.fragmentShaderID);
        }
    }

    private void removeVertShader() {
        if (this.vertexShaderID != -1) {
            ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.vertexShaderID);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertexShaderID);
        }
    }

    private void checkProgramError(IntBuffer intBuffer, int n) {
        if (intBuffer.get(0) == 0) {
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer((int)1);
            ARBShaderObjects.glGetObjectParameterARB((int)n, (int)35716, (IntBuffer)intBuffer2);
            int n2 = intBuffer2.get();
            String string = null;
            if (n2 > 0) {
                ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)n2);
                intBuffer2.flip();
                ARBShaderObjects.glGetInfoLogARB((int)n, (IntBuffer)intBuffer2, (ByteBuffer)byteBuffer);
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                string = new String(byArray);
            }
            LoggingSystem.getLogger().log(Level.SEVERE, string);
        }
    }

    public void apply() {
        if (this.isSupported()) {
            RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
            ShaderObjectsStateRecord shaderObjectsStateRecord = (ShaderObjectsStateRecord)renderContext.getStateRecord(14);
            renderContext.currentStates[14] = this;
            if (!shaderObjectsStateRecord.isValid() || shaderObjectsStateRecord.getReference() != this || this.needsRefresh()) {
                shaderObjectsStateRecord.setReference(this);
                if (this.isEnabled()) {
                    if (this.programID != -1) {
                        Object object;
                        int n;
                        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
                        if (!this.attribs.isEmpty()) {
                            n = this.attribs.size();
                            while (--n >= 0) {
                                object = (ShaderAttribute)this.attribs.get(n);
                                switch (((ShaderAttribute)object).type) {
                                    case 0: {
                                        ARBVertexProgram.glVertexAttrib1sARB((int)((ShaderAttribute)object).attributeID, (short)((ShaderAttribute)object).s1);
                                        break;
                                    }
                                    case 1: {
                                        ARBVertexProgram.glVertexAttrib2sARB((int)((ShaderAttribute)object).attributeID, (short)((ShaderAttribute)object).s1, (short)((ShaderAttribute)object).s2);
                                        break;
                                    }
                                    case 2: {
                                        ARBVertexProgram.glVertexAttrib3sARB((int)((ShaderAttribute)object).attributeID, (short)((ShaderAttribute)object).s1, (short)((ShaderAttribute)object).s2, (short)((ShaderAttribute)object).s3);
                                        break;
                                    }
                                    case 3: {
                                        ARBVertexProgram.glVertexAttrib4sARB((int)((ShaderAttribute)object).attributeID, (short)((ShaderAttribute)object).s1, (short)((ShaderAttribute)object).s2, (short)((ShaderAttribute)object).s3, (short)((ShaderAttribute)object).s4);
                                        break;
                                    }
                                    case 4: {
                                        ARBVertexProgram.glVertexAttrib1fARB((int)((ShaderAttribute)object).attributeID, (float)((ShaderAttribute)object).f1);
                                        break;
                                    }
                                    case 5: {
                                        ARBVertexProgram.glVertexAttrib2fARB((int)((ShaderAttribute)object).attributeID, (float)((ShaderAttribute)object).f1, (float)((ShaderAttribute)object).f2);
                                        break;
                                    }
                                    case 6: {
                                        ARBVertexProgram.glVertexAttrib3fARB((int)((ShaderAttribute)object).attributeID, (float)((ShaderAttribute)object).f1, (float)((ShaderAttribute)object).f2, (float)((ShaderAttribute)object).f3);
                                        break;
                                    }
                                    case 7: {
                                        ARBVertexProgram.glVertexAttrib4fARB((int)((ShaderAttribute)object).attributeID, (float)((ShaderAttribute)object).f1, (float)((ShaderAttribute)object).f2, (float)((ShaderAttribute)object).f3, (float)((ShaderAttribute)object).f4);
                                        break;
                                    }
                                    case 8: {
                                        ARBVertexProgram.glVertexAttrib4NubARB((int)((ShaderAttribute)object).attributeID, (byte)((ShaderAttribute)object).b1, (byte)((ShaderAttribute)object).b2, (byte)((ShaderAttribute)object).b3, (byte)((ShaderAttribute)object).b4);
                                        break;
                                    }
                                    case 10: {
                                        ARBVertexProgram.glVertexAttribPointerARB((int)((ShaderAttribute)object).attributeID, (int)((ShaderAttribute)object).size, (boolean)((ShaderAttribute)object).normalized, (int)((ShaderAttribute)object).stride, (FloatBuffer)((FloatBuffer)((ShaderAttribute)object).data));
                                        ARBVertexProgram.glEnableVertexAttribArrayARB((int)((ShaderAttribute)object).attributeID);
                                        break;
                                    }
                                    case 9: {
                                        ARBVertexProgram.glVertexAttribPointerARB((int)((ShaderAttribute)object).attributeID, (int)((ShaderAttribute)object).size, (boolean)((ShaderAttribute)object).unsigned, (boolean)((ShaderAttribute)object).normalized, (int)((ShaderAttribute)object).stride, (ByteBuffer)((ByteBuffer)((ShaderAttribute)object).data));
                                        ARBVertexProgram.glEnableVertexAttribArrayARB((int)((ShaderAttribute)object).attributeID);
                                        break;
                                    }
                                    case 12: {
                                        ARBVertexProgram.glVertexAttribPointerARB((int)((ShaderAttribute)object).attributeID, (int)((ShaderAttribute)object).size, (boolean)((ShaderAttribute)object).unsigned, (boolean)((ShaderAttribute)object).normalized, (int)((ShaderAttribute)object).stride, (IntBuffer)((IntBuffer)((ShaderAttribute)object).data));
                                        ARBVertexProgram.glEnableVertexAttribArrayARB((int)((ShaderAttribute)object).attributeID);
                                        break;
                                    }
                                    case 11: {
                                        ARBVertexProgram.glVertexAttribPointerARB((int)((ShaderAttribute)object).attributeID, (int)((ShaderAttribute)object).size, (boolean)((ShaderAttribute)object).unsigned, (boolean)((ShaderAttribute)object).normalized, (int)((ShaderAttribute)object).stride, (ShortBuffer)((ShortBuffer)((ShaderAttribute)object).data));
                                        ARBVertexProgram.glEnableVertexAttribArrayARB((int)((ShaderAttribute)object).attributeID);
                                        break;
                                    }
                                }
                            }
                        }
                        if (!this.uniforms.isEmpty()) {
                            n = this.uniforms.size();
                            while (--n >= 0) {
                                object = (ShaderUniform)this.uniforms.get(n);
                                switch (((ShaderUniform)object).type) {
                                    case 0: {
                                        ARBShaderObjects.glUniform1iARB((int)this.getUniLoc((ShaderUniform)object), (int)((ShaderUniform)object).vint[0]);
                                        break;
                                    }
                                    case 1: {
                                        ARBShaderObjects.glUniform2iARB((int)this.getUniLoc((ShaderUniform)object), (int)((ShaderUniform)object).vint[0], (int)((ShaderUniform)object).vint[1]);
                                        break;
                                    }
                                    case 2: {
                                        ARBShaderObjects.glUniform3iARB((int)this.getUniLoc((ShaderUniform)object), (int)((ShaderUniform)object).vint[0], (int)((ShaderUniform)object).vint[1], (int)((ShaderUniform)object).vint[2]);
                                        break;
                                    }
                                    case 3: {
                                        ARBShaderObjects.glUniform4iARB((int)this.getUniLoc((ShaderUniform)object), (int)((ShaderUniform)object).vint[0], (int)((ShaderUniform)object).vint[1], (int)((ShaderUniform)object).vint[2], (int)((ShaderUniform)object).vint[3]);
                                        break;
                                    }
                                    case 4: {
                                        ARBShaderObjects.glUniform1fARB((int)this.getUniLoc((ShaderUniform)object), (float)((ShaderUniform)object).vfloat[0]);
                                        break;
                                    }
                                    case 5: {
                                        ARBShaderObjects.glUniform2fARB((int)this.getUniLoc((ShaderUniform)object), (float)((ShaderUniform)object).vfloat[0], (float)((ShaderUniform)object).vfloat[1]);
                                        break;
                                    }
                                    case 6: {
                                        ARBShaderObjects.glUniform3fARB((int)this.getUniLoc((ShaderUniform)object), (float)((ShaderUniform)object).vfloat[0], (float)((ShaderUniform)object).vfloat[1], (float)((ShaderUniform)object).vfloat[2]);
                                        break;
                                    }
                                    case 7: {
                                        ARBShaderObjects.glUniform4fARB((int)this.getUniLoc((ShaderUniform)object), (float)((ShaderUniform)object).vfloat[0], (float)((ShaderUniform)object).vfloat[1], (float)((ShaderUniform)object).vfloat[2], (float)((ShaderUniform)object).vfloat[3]);
                                        break;
                                    }
                                    case 8: {
                                        if (((ShaderUniform)object).matrixBuffer == null) {
                                            ((ShaderUniform)object).matrixBuffer = BufferUtils.createFloatBuffer((int)4);
                                        }
                                        ((ShaderUniform)object).matrixBuffer.clear();
                                        ((ShaderUniform)object).matrixBuffer.put(((ShaderUniform)object).matrix2f);
                                        ((ShaderUniform)object).matrixBuffer.rewind();
                                        ARBShaderObjects.glUniformMatrix2ARB((int)this.getUniLoc((ShaderUniform)object), (boolean)((ShaderUniform)object).transpose, (FloatBuffer)((ShaderUniform)object).matrixBuffer);
                                        break;
                                    }
                                    case 9: {
                                        if (((ShaderUniform)object).matrixBuffer == null) {
                                            ((ShaderUniform)object).matrixBuffer = ((ShaderUniform)object).matrix3f.toFloatBuffer();
                                        } else {
                                            ((ShaderUniform)object).matrix3f.fillFloatBuffer(((ShaderUniform)object).matrixBuffer);
                                        }
                                        ARBShaderObjects.glUniformMatrix3ARB((int)this.getUniLoc((ShaderUniform)object), (boolean)((ShaderUniform)object).transpose, (FloatBuffer)((ShaderUniform)object).matrixBuffer);
                                        break;
                                    }
                                    case 10: {
                                        if (((ShaderUniform)object).matrixBuffer == null) {
                                            ((ShaderUniform)object).matrixBuffer = ((ShaderUniform)object).matrix4f.toFloatBuffer();
                                        } else {
                                            ((ShaderUniform)object).matrix4f.fillFloatBuffer(((ShaderUniform)object).matrixBuffer);
                                        }
                                        ARBShaderObjects.glUniformMatrix4ARB((int)this.getUniLoc((ShaderUniform)object), (boolean)((ShaderUniform)object).transpose, (FloatBuffer)((ShaderUniform)object).matrixBuffer);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    ARBShaderObjects.glUseProgramObjectARB((int)0);
                }
            }
            if (!shaderObjectsStateRecord.isValid()) {
                shaderObjectsStateRecord.validate();
            }
        }
    }

    public StateRecord createStateRecord() {
        return new ShaderObjectsStateRecord();
    }
}

