/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.system.GameSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;

public class PreferencesGameSettings
implements GameSettings {
    private static final String DEFAULT_RENDERER = "LWJGL";
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final int DEFAULT_DEPTH = 16;
    private static final int DEFAULT_FREQUENCY = 60;
    private static final boolean DEFAULT_VERTICAL_SYNC = true;
    private static final boolean DEFAULT_FULLSCREEN = false;
    private static final int DEFAULT_DEPTH_BITS = 8;
    private static final int DEFAULT_ALPHA_BITS = 0;
    private static final int DEFAULT_STENCIL_BITS = 0;
    private static final int DEFAULT_SAMPLES = 0;
    private static final boolean DEFAULT_MUSIC = true;
    private static final boolean DEFAULT_SFX = true;
    private static final int DEFAULT_FRAMERATE = -1;
    private Preferences preferences;

    public PreferencesGameSettings(Preferences preferences) {
        this.preferences = preferences;
    }

    public String getRenderer() {
        return this.preferences.get("GameRenderer", DEFAULT_RENDERER);
    }

    public void setRenderer(String string) {
        this.preferences.put("GameRenderer", string);
    }

    public int getWidth() {
        return this.preferences.getInt("GameWidth", 640);
    }

    public void setWidth(int n) {
        this.preferences.putInt("GameWidth", n);
    }

    public int getHeight() {
        return this.preferences.getInt("GameHeight", 480);
    }

    public void setHeight(int n) {
        this.preferences.putInt("GameHeight", n);
    }

    public int getDepth() {
        return this.preferences.getInt("GameDepth", 16);
    }

    public void setDepth(int n) {
        this.preferences.putInt("GameDepth", n);
    }

    public int getFrequency() {
        return this.preferences.getInt("GameFrequency", 60);
    }

    public void setFrequency(int n) {
        this.preferences.putInt("GameFrequency", n);
    }

    public boolean isVerticalSync() {
        return this.preferences.getBoolean("GameVerticalSync", true);
    }

    public void setVerticalSync(boolean bl) {
        this.preferences.putBoolean("GameVerticalSync", bl);
    }

    public boolean isFullscreen() {
        return this.preferences.getBoolean("GameFullscreen", false);
    }

    public void setFullscreen(boolean bl) {
        this.preferences.putBoolean("GameFullscreen", bl);
    }

    public int getDepthBits() {
        return this.preferences.getInt("GameDepthBits", 8);
    }

    public void setDepthBits(int n) {
        this.preferences.putInt("GameDepthBits", n);
    }

    public int getAlphaBits() {
        return this.preferences.getInt("GameAlphaBits", 0);
    }

    public void setAlphaBits(int n) {
        this.preferences.putInt("GameAlphaBits", n);
    }

    public int getStencilBits() {
        return this.preferences.getInt("GameStencilBits", 0);
    }

    public void setStencilBits(int n) {
        this.preferences.putInt("GameStencilBits", n);
    }

    public int getSamples() {
        return this.preferences.getInt("GameSamples", 0);
    }

    public void setSamples(int n) {
        this.preferences.putInt("GameSamples", n);
    }

    public boolean isMusic() {
        return this.preferences.getBoolean("GameMusic", true);
    }

    public void setMusic(boolean bl) {
        this.preferences.putBoolean("GameMusic", bl);
    }

    public boolean isSFX() {
        return this.preferences.getBoolean("GameSFX", true);
    }

    public void setSFX(boolean bl) {
        this.preferences.putBoolean("GameSFX", bl);
    }

    public int getFramerate() {
        return this.preferences.getInt("GameFramerate", -1);
    }

    public void setFramerate(int n) {
        this.preferences.putInt("GameFramerate", n);
    }

    public void clear() throws Exception {
        this.preferences.clear();
    }

    public String get(String string, String string2) {
        return this.preferences.get(string, string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.preferences.getBoolean(string, bl);
    }

    public double getDouble(String string, double d) {
        return this.preferences.getDouble(string, d);
    }

    public float getFloat(String string, float f) {
        return this.preferences.getFloat(string, f);
    }

    public int getInt(String string, int n) {
        return this.preferences.getInt(string, n);
    }

    public long getLong(String string, long l) {
        return this.preferences.getLong(string, l);
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        return this.preferences.getByteArray(string, byArray);
    }

    public Object getObject(String string, Object object) {
        try {
            byte[] byArray = this.preferences.getByteArray(string, null);
            if (byArray == null) {
                return object;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void set(String string, String string2) {
        this.preferences.put(string, string2);
    }

    public void setBoolean(String string, boolean bl) {
        this.preferences.putBoolean(string, bl);
    }

    public void setDouble(String string, double d) {
        this.preferences.putDouble(string, d);
    }

    public void setFloat(String string, float f) {
        this.preferences.putFloat(string, f);
    }

    public void setInt(String string, int n) {
        this.preferences.putInt(string, n);
    }

    public void setLong(String string, long l) {
        this.preferences.putLong(string, l);
    }

    public void setByteArray(String string, byte[] byArray) {
        this.preferences.putByteArray(string, byArray);
    }

    public void setObject(String string, Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.preferences.putByteArray(string, byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

