/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public class PropertiesIO {
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    public static final int DEFAULT_DEPTH = 16;
    public static final int DEFAULT_FREQ = 60;
    public static final boolean DEFAULT_FULLSCREEN = true;
    public static final String DEFAULT_RENDERER = "LWJGL";
    private Properties prop;
    private String filename;

    public PropertiesIO(String string) {
        if (null == string) {
            throw new JmeException("Must give a valid filename");
        }
        this.filename = string;
        this.prop = new Properties();
        LoggingSystem.getLogger().log(Level.INFO, "PropertiesIO created");
    }

    public boolean load() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load properties. Creating a new one.");
            return false;
        }
        try {
            if (fileInputStream != null) {
                this.prop.load(fileInputStream);
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load properties. Creating a new one.");
            return false;
        }
        if (null == this.prop.getProperty("WIDTH") || null == this.prop.getProperty("HEIGHT") || null == this.prop.getProperty("DEPTH") || null == this.prop.getProperty("FULLSCREEN")) {
            LoggingSystem.getLogger().log(Level.WARNING, "Properties file not complete.");
            return false;
        }
        LoggingSystem.getLogger().log(Level.INFO, "Read properties");
        return true;
    }

    public boolean save(int n, int n2, int n3, int n4, boolean bl, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            this.prop.clear();
            this.prop.put("WIDTH", "" + n);
            this.prop.put("HEIGHT", "" + n2);
            this.prop.put("DEPTH", "" + n3);
            this.prop.put("FREQ", "" + n4);
            this.prop.put("FULLSCREEN", "" + bl);
            this.prop.put("RENDERER", string);
            this.prop.store(fileOutputStream, "Properties");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not save properties: " + iOException.toString());
            return false;
        }
        LoggingSystem.getLogger().log(Level.INFO, "Saved properties");
        return true;
    }

    public int getWidth() {
        String string = this.prop.getProperty("WIDTH");
        if (null == string) {
            return 640;
        }
        return Integer.parseInt(string);
    }

    public int getHeight() {
        String string = this.prop.getProperty("HEIGHT");
        if (null == string) {
            return 480;
        }
        return Integer.parseInt(string);
    }

    public int getDepth() {
        String string = this.prop.getProperty("DEPTH");
        if (null == string) {
            return 16;
        }
        return Integer.parseInt(string);
    }

    public int getFreq() {
        String string = this.prop.getProperty("FREQ");
        if (null == string) {
            return 60;
        }
        return Integer.parseInt(string);
    }

    public boolean getFullscreen() {
        String string = this.prop.getProperty("FULLSCREEN");
        if (null == string) {
            return true;
        }
        return new Boolean(this.prop.getProperty("FULLSCREEN"));
    }

    public String getRenderer() {
        String string = this.prop.getProperty("RENDERER");
        if (null == string) {
            return DEFAULT_RENDERER;
        }
        return string;
    }

    public String get(String string) {
        return this.prop.getProperty(string);
    }

    public void set(String string, String string2) {
        this.prop.setProperty(string, string2);
    }
}

