/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class BinaryFileReader {
    private byte[] fileContents;
    private int fileIndex = 0;
    private int markedPos = 0;

    public BinaryFileReader(String string) {
        try {
            URL uRL = new URL(string);
            this.open(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not open: " + string);
        }
    }

    public BinaryFileReader(URL uRL) {
        this.open(uRL);
    }

    public BinaryFileReader(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.fileContents = new byte[dataInputStream.available()];
            dataInputStream.readFully(this.fileContents);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new JmeException("Could not read InputStream ");
        }
    }

    public void open(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.fileContents = new byte[dataInputStream.available()];
            dataInputStream.readFully(this.fileContents);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new JmeException("Could not read: " + uRL);
        }
    }

    public int readByte() {
        int n = this.fileContents[this.fileIndex] & 0xFF;
        ++this.fileIndex;
        return n;
    }

    public int readShort() {
        int n = this.fileContents[this.fileIndex] & 0xFF;
        int n2 = (this.fileContents[this.fileIndex + 1] & 0xFF) << 8;
        this.fileIndex += 2;
        return n | n2;
    }

    public int readShort2() {
        int n = this.fileContents[this.fileIndex + 1] & 0xFF;
        int n2 = (this.fileContents[this.fileIndex] & 0xFF) << 8;
        this.fileIndex += 2;
        return n | n2;
    }

    public int readInt() {
        int n = this.fileContents[this.fileIndex] & 0xFF;
        int n2 = (this.fileContents[this.fileIndex + 1] & 0xFF) << 8;
        int n3 = (this.fileContents[this.fileIndex + 2] & 0xFF) << 16;
        int n4 = (this.fileContents[this.fileIndex + 3] & 0xFF) << 24;
        this.fileIndex += 4;
        return n | n2 | n3 | n4;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString(int n) {
        for (int i = this.fileIndex; i < this.fileIndex + n; ++i) {
            if (this.fileContents[i] != 0) continue;
            String string = new String(this.fileContents, this.fileIndex, i - this.fileIndex);
            this.fileIndex += n;
            return string;
        }
        String string = new String(this.fileContents, this.fileIndex, n);
        this.fileIndex += n;
        return string;
    }

    public void setOffset(int n) {
        if (n < 0 || n > this.fileContents.length) {
            throw new JmeException("Illegal offset value. " + n);
        }
        this.fileIndex = n;
    }

    public void markPos() {
        this.markedPos = this.fileIndex;
    }

    public void seekMarkOffset(int n) {
        this.fileIndex = this.markedPos + n;
        if (this.fileIndex < 0 || this.fileIndex > this.fileContents.length) {
            throw new JmeException("Illegal offset value. " + n);
        }
    }

    public short readSignedShort() {
        return (short)this.readShort();
    }
}

