/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GameTask<V>
implements Future<V> {
    private Callable<V> callable;
    private boolean cancelled;
    private V result;
    private ExecutionException exc;

    public GameTask(Callable<V> callable) {
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.result != null) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        while (this.result == null && this.exc == null) {
            this.wait();
        }
        if (this.exc != null) {
            throw this.exc;
        }
        return this.result;
    }

    @Override
    public synchronized V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result == null && this.exc == null) {
            timeUnit.timedWait(this, l);
        }
        if (this.exc != null) {
            throw this.exc;
        }
        if (this.result == null) {
            throw new TimeoutException("Object not returned in time allocated.");
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public synchronized void invoke() {
        try {
            this.result = this.callable.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exc = new ExecutionException(exception);
        }
        this.notifyAll();
    }
}

