/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingSystem {
    private static LoggingSystem logSystem = null;
    private static final Logger logger = Logger.getLogger("jme");
    private Handler handler;
    private static String logToFile = "debug.txt";

    public static String getLogToFile() {
        return logToFile;
    }

    public static void setLogToFile(String string) {
        if (logSystem != null) {
            throw new IllegalStateException("cannot change log file when LoggingSystem is already created.");
        }
        logToFile = string;
    }

    private LoggingSystem() {
        this.loggerOn(true);
        String string = LoggingSystem.getLogToFile();
        if (string != null) {
            try {
                this.handler = new FileHandler(string);
                this.handler.setFormatter(new SimpleFormatter());
                logger.addHandler(this.handler);
            }
            catch (IOException iOException) {
                System.err.println("Could not start Logging System with logging to file '" + string + "': ");
                iOException.printStackTrace();
            }
        }
    }

    public static Logger getLogger() {
        if (null == logSystem) {
            logSystem = new LoggingSystem();
        }
        return logger;
    }

    public void loggerOn(boolean bl) {
        if (bl) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.OFF);
        }
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
        logger.addHandler(handler);
    }

    public void setLevel(Level level) {
        logger.setLevel(level);
    }

    public void setFormatter(Formatter formatter) {
        this.handler.setFormatter(formatter);
    }

    public static LoggingSystem getLoggingSystem() {
        if (null == logSystem) {
            logSystem = new LoggingSystem();
            return logSystem;
        }
        return logSystem;
    }
}

