/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public final class TextureKey
implements Savable {
    protected URL m_location = null;
    protected int m_minFilter;
    protected int m_maxFilter;
    protected float m_anisoLevel = 1.0f;
    protected boolean m_flipped;
    protected int code = Integer.MAX_VALUE;
    protected int imageType = -1;
    protected String fileType;
    private static LocationOverride locationOverride;

    public TextureKey() {
    }

    public TextureKey(URL uRL, int n, int n2, float f, boolean bl, int n3) {
        this.m_location = uRL;
        this.m_minFilter = n;
        this.m_maxFilter = n2;
        this.m_flipped = bl;
        this.m_anisoLevel = f;
        this.imageType = n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextureKey)) {
            return false;
        }
        TextureKey textureKey = (TextureKey)object;
        if (this.m_location == null ? textureKey.m_location != null : !this.m_location.equals(textureKey.m_location)) {
            return false;
        }
        if (this.m_minFilter != textureKey.m_minFilter) {
            return false;
        }
        if (this.m_maxFilter != textureKey.m_maxFilter) {
            return false;
        }
        if (this.m_anisoLevel != textureKey.m_anisoLevel) {
            return false;
        }
        if (this.m_flipped != textureKey.m_flipped) {
            return false;
        }
        if (this.imageType != textureKey.imageType) {
            return false;
        }
        if (this.fileType == null && textureKey.fileType != null) {
            return false;
        }
        return this.fileType == null || this.fileType.equals(textureKey.fileType);
    }

    public int hashCode() {
        if (this.code == Integer.MAX_VALUE) {
            this.code = 37;
            if (this.m_location != null) {
                this.code += 37 * this.m_location.hashCode();
            }
            if (this.fileType != null) {
                this.code += 37 * this.fileType.hashCode();
            }
            this.code += 37 * (int)(this.m_anisoLevel * 100.0f);
            this.code += 37 * this.m_maxFilter;
            this.code += 37 * this.m_minFilter;
            this.code += 37 * this.imageType;
            this.code += 37 * (this.m_flipped ? 1 : 0);
        }
        return this.code;
    }

    public void resetHashCode() {
        this.code = Integer.MAX_VALUE;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        if (this.m_location != null) {
            outputCapsule.write(this.m_location.getProtocol(), "protocol", null);
            outputCapsule.write(this.m_location.getHost(), "host", null);
            outputCapsule.write(this.m_location.getFile(), "file", null);
        }
        outputCapsule.write(this.m_minFilter, "minFilter", 0);
        outputCapsule.write(this.m_maxFilter, "maxFilter", 0);
        outputCapsule.write(this.m_anisoLevel, "anisoLevel", 1.0f);
        outputCapsule.write(this.m_flipped, "flipped", false);
        outputCapsule.write(this.imageType, "imageType", -1);
        outputCapsule.write(this.fileType, "fileType", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        String string = inputCapsule.readString("protocol", null);
        String string2 = inputCapsule.readString("host", null);
        String string3 = inputCapsule.readString("file", null);
        if (locationOverride != null && "file".equals(string)) {
            int n = string3.lastIndexOf(47);
            if (n == -1) {
                n = string3.lastIndexOf(92);
            }
            string3 = string3.substring(++n);
            this.m_location = new URL(locationOverride.getLocation(string3), string3);
        } else if (string != null && string2 != null && string3 != null) {
            this.m_location = new URL(string, string2, string3);
        }
        this.m_minFilter = inputCapsule.readInt("minFilter", 0);
        this.m_maxFilter = inputCapsule.readInt("maxFilter", 0);
        this.m_anisoLevel = inputCapsule.readFloat("anisoLevel", 1.0f);
        this.m_flipped = inputCapsule.readBoolean("flipped", false);
        this.imageType = inputCapsule.readInt("imageType", -1);
        this.fileType = inputCapsule.readString("fileType", null);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    public static LocationOverride getLocationOverride() {
        return locationOverride;
    }

    public static void setLocationOverride(LocationOverride locationOverride) {
        TextureKey.locationOverride = locationOverride;
    }

    public static URL getOverridingLocation() {
        try {
            if (locationOverride != null) {
                return locationOverride.getLocation(null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static void setOverridingLocation(final URL uRL) {
        TextureKey.setLocationOverride(new LocationOverride(){

            public URL getLocation(String string) throws MalformedURLException {
                if (string == null) {
                    return uRL;
                }
                int n = string.lastIndexOf(47);
                if (n == -1) {
                    n = string.lastIndexOf(92);
                }
                return new URL(uRL, string.substring(n + 1));
            }
        });
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public float getAnisoLevel() {
        return this.m_anisoLevel;
    }

    public void setAnisoLevel(float f) {
        this.m_anisoLevel = f;
    }

    public boolean isFlipped() {
        return this.m_flipped;
    }

    public void setFlipped(boolean bl) {
        this.m_flipped = bl;
    }

    public URL getLocation() {
        return this.m_location;
    }

    public void setLocation(URL uRL) {
        this.m_location = uRL;
    }

    public int getMaxFilter() {
        return this.m_maxFilter;
    }

    public void setMaxFilter(int n) {
        this.m_maxFilter = n;
    }

    public int getMinFilter() {
        return this.m_minFilter;
    }

    public void setMinFilter(int n) {
        this.m_minFilter = n;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public String toString() {
        String string = "tkey: loc:" + this.m_location + " min: " + this.m_minFilter + " max: " + this.m_maxFilter + " flip: " + this.m_flipped + " code: " + this.hashCode() + " imageType: " + this.imageType + " fileType: " + this.fileType;
        return string;
    }

    public static interface LocationOverride {
        public URL getLocation(String var1) throws MalformedURLException;
    }
}

