/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.image.BitmapHeader;
import com.jme.image.Texture;
import com.jme.image.util.DDSLoader;
import com.jme.image.util.TGALoader;
import com.jme.renderer.Renderer;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.ImageLoader;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureKey;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public final class TextureManager {
    private static HashMap<TextureKey, Texture> m_tCache = new HashMap();
    private static HashMap<String, ImageLoader> loaders = new HashMap();
    private static ArrayList<Integer> cleanupStore = new ArrayList();
    public static boolean COMPRESS_BY_DEFAULT = true;

    private TextureManager() {
    }

    public static Texture loadTexture(String string, int n, int n2) {
        return TextureManager.loadTexture(string, n, n2, 1.0f, true);
    }

    public static Texture loadTexture(String string, int n, int n2, float f, boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return TextureManager.loadTexture(uRL, n, n2, COMPRESS_BY_DEFAULT ? -1 : -2, f, bl);
    }

    public static Texture loadTexture(String string, int n, int n2, int n3, float f, boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return TextureManager.loadTexture(uRL, n, n2, n3, f, bl);
    }

    public static Texture loadTexture(URL uRL, int n, int n2) {
        return TextureManager.loadTexture(uRL, n, n2, COMPRESS_BY_DEFAULT ? -1 : -2, 1.0f, true);
    }

    public static Texture loadTexture(URL uRL, int n, int n2, float f, boolean bl) {
        return TextureManager.loadTexture(uRL, n, n2, COMPRESS_BY_DEFAULT ? -1 : -2, f, bl);
    }

    public static Texture loadTexture(URL uRL, int n, int n2, int n3, float f, boolean bl) {
        if (null == uRL) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load image...  URL was null. defaultTexture used.");
            return TextureState.defaultTexture;
        }
        String string = uRL.getFile();
        if (string == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load image...  fileName was null. defaultTexture used.");
            return TextureState.defaultTexture;
        }
        TextureKey textureKey = new TextureKey(uRL, n, n2, f, bl, n3);
        return TextureManager.loadTexture(textureKey);
    }

    public static Texture loadTexture(TextureKey textureKey) {
        return TextureManager.loadTexture(null, textureKey, null);
    }

    public static Texture loadTexture(Texture texture, TextureKey textureKey) {
        return TextureManager.loadTexture(texture, textureKey, null);
    }

    public static Texture loadTexture(Texture texture, TextureKey textureKey, com.jme.image.Image image) {
        if (textureKey == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "TextureKey is null, cannot load");
            return TextureState.defaultTexture;
        }
        Texture texture2 = TextureManager.findCachedTexture(textureKey);
        if (texture2 != null) {
            if (texture == null) {
                Texture texture3 = texture2.createSimpleClone();
                if (texture3.getTextureKey() == null) {
                    texture3.setTextureKey(textureKey);
                }
                return texture3;
            }
            texture2.createSimpleClone(texture);
            return texture;
        }
        if (texture == null) {
            texture = new Texture(textureKey.m_anisoLevel);
        }
        if (image == null) {
            image = TextureManager.loadImage(textureKey);
        }
        if (null == image) {
            LoggingSystem.getLogger().log(Level.WARNING, "(image null) Could not load: " + (textureKey.getLocation() != null ? textureKey.getLocation().getFile() : textureKey.getFileType()));
            return TextureState.defaultTexture;
        }
        TextureState textureState = null;
        if (DisplaySystem.getDisplaySystem() != null && DisplaySystem.getDisplaySystem().getRenderer() != null) {
            textureState = (TextureState)Renderer.defaultStateList[6];
        }
        if (textureKey.imageType != -2 && textureKey.imageType != -1) {
            image.setType(textureKey.imageType);
        } else if (textureKey.imageType == -1 && textureState != null && textureState.isS3TCAvailable()) {
            if (image.getType() == 1) {
                image.setType(5);
            } else if (image.getType() == 3) {
                image.setType(8);
            }
        }
        texture.setTextureKey(textureKey);
        texture.setFilter(textureKey.m_maxFilter);
        texture.setImage(image);
        texture.setMipmapState(textureKey.m_minFilter);
        if (textureKey.m_location != null) {
            texture.setImageLocation(textureKey.m_location.toString());
        }
        TextureManager.addToCache(texture);
        return texture;
    }

    public static void addToCache(Texture texture) {
        m_tCache.put(texture.getTextureKey(), texture);
    }

    public static Texture loadTexture(Image image, int n, int n2, boolean bl) {
        return TextureManager.loadTexture(image, n, n2, 1.0f, COMPRESS_BY_DEFAULT ? -1 : -2, bl);
    }

    public static Texture loadTexture(Image image, int n, int n2, float f, boolean bl) {
        return TextureManager.loadTexture(image, n, n2, f, COMPRESS_BY_DEFAULT ? -1 : -2, bl);
    }

    public static Texture loadTexture(Image image, int n, int n2, float f, int n3, boolean bl) {
        com.jme.image.Image image2 = TextureManager.loadImage(image, bl);
        TextureKey textureKey = new TextureKey(null, n, n2, f, bl, n3);
        if (image != null) {
            textureKey.setFileType("" + image.hashCode());
        }
        return TextureManager.loadTexture(null, textureKey, image2);
    }

    public static com.jme.image.Image loadImage(TextureKey textureKey) {
        if (textureKey == null) {
            return null;
        }
        if ("savable".equalsIgnoreCase(textureKey.fileType)) {
            Savable savable;
            try {
                savable = BinaryImporter.getInstance().load(textureKey.m_location);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                LoggingSystem.getLogger().log(Level.WARNING, "Could not load Savable.", iOException);
                return null;
            }
            if (savable instanceof com.jme.image.Image) {
                return (com.jme.image.Image)savable;
            }
            LoggingSystem.getLogger().log(Level.WARNING, "Savable not of type Image.");
            return TextureState.defaultTexture.getImage();
        }
        return TextureManager.loadImage(textureKey.m_location, textureKey.m_flipped);
    }

    public static com.jme.image.Image loadImage(URL uRL, boolean bl) {
        InputStream inputStream;
        if (uRL == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "loadImage(URL file, boolean flipped): file is null, defaultTexture used.");
            return TextureState.defaultTexture.getImage();
        }
        String string = uRL.getFile();
        if (string == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "loadImage(URL file, boolean flipped): fileName is null, defaultTexture used.");
            return TextureState.defaultTexture.getImage();
        }
        String string2 = string.substring(string.lastIndexOf(46));
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LoggingSystem.getLogger().log(Level.WARNING, "loadImage(URL file, boolean flipped): defaultTexture used because - " + iOException.getMessage());
            return TextureState.defaultTexture.getImage();
        }
        return TextureManager.loadImage(string2, inputStream, bl);
    }

    public static com.jme.image.Image loadImage(String string, InputStream inputStream, boolean bl) {
        com.jme.image.Image image = null;
        try {
            ImageLoader imageLoader = loaders.get(string.toLowerCase());
            if (imageLoader != null) {
                image = imageLoader.load(inputStream);
            } else if (".TGA".equalsIgnoreCase(string)) {
                image = TGALoader.loadImage(inputStream, bl);
            } else if (".DDS".equalsIgnoreCase(string)) {
                image = DDSLoader.loadImage(inputStream, bl);
            } else if (".BMP".equalsIgnoreCase(string)) {
                Image image2 = TextureManager.loadBMPImage(inputStream);
                image = TextureManager.loadImage(image2, bl);
            } else {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                image = TextureManager.loadImage(bufferedImage, bl);
            }
            if (image == null) {
                LoggingSystem.getLogger().log(Level.WARNING, "loadImage(String fileExt, InputStream stream, boolean flipped): no imageData found.  defaultTexture used.");
                image = TextureState.defaultTexture.getImage();
            }
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load Image.   (" + iOException.getClass() + ")");
            iOException.printStackTrace();
            image = TextureState.defaultTexture.getImage();
        }
        return image;
    }

    public static com.jme.image.Image loadImage(Image image, boolean bl) {
        Object object;
        Object object2;
        if (image == null) {
            return null;
        }
        boolean bl2 = TextureManager.hasAlpha(image);
        BufferedImage bufferedImage = null;
        if (bl || !(image instanceof BufferedImage) || (bl2 ? ((BufferedImage)image).getType() != 6 : ((BufferedImage)image).getType() != 5)) {
            try {
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), bl2 ? 6 : 5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LoggingSystem.getLogger().log(Level.WARNING, "Problem creating buffered Image: " + illegalArgumentException.getMessage());
                return TextureState.defaultTexture.getImage();
            }
            image.getWidth(null);
            image.getHeight(null);
            object2 = null;
            if (bl) {
                object2 = AffineTransform.getScaleInstance(1.0, -1.0);
                ((AffineTransform)object2).translate(0.0, -image.getHeight(null));
            }
            object = (Graphics2D)bufferedImage.getGraphics();
            ((Graphics2D)object).drawImage(image, (AffineTransform)object2, null);
            ((Graphics)object).dispose();
        } else {
            bufferedImage = (BufferedImage)image;
        }
        object2 = BufferUtils.createByteBuffer(4 * bufferedImage.getWidth() * bufferedImage.getHeight());
        object = (byte[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        ((ByteBuffer)object2).clear();
        ((ByteBuffer)object2).put((byte[])object);
        ((ByteBuffer)object2).flip();
        com.jme.image.Image image2 = new com.jme.image.Image();
        image2.setType(bl2 ? 3 : 1);
        image2.setWidth(bufferedImage.getWidth());
        image2.setHeight(bufferedImage.getHeight());
        image2.setData((ByteBuffer)object2);
        return image2;
    }

    private static Image loadBMPImage(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            BitmapHeader bitmapHeader = new BitmapHeader();
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            bitmapHeader.read(byArray);
            if (bitmapHeader.bitcount == 24) {
                return bitmapHeader.readMap24(byArray);
            }
            if (bitmapHeader.bitcount == 32) {
                return bitmapHeader.readMap32(byArray);
            }
            if (bitmapHeader.bitcount == 8) {
                return bitmapHeader.readMap8(byArray);
            }
        }
        catch (IOException iOException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Error while loading bitmap texture.");
        }
        return null;
    }

    public static boolean hasAlpha(Image image) {
        if (null == image) {
            return false;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
            ColorModel colorModel = pixelGrabber.getColorModel();
            if (colorModel != null) {
                return colorModel.hasAlpha();
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            LoggingSystem.getLogger().warning("Unable to determine alpha of image: " + image);
            return false;
        }
    }

    public static boolean releaseTexture(Texture texture) {
        Set<TextureKey> set = m_tCache.keySet();
        for (TextureKey textureKey : set) {
            Texture texture2 = m_tCache.get(textureKey);
            if (!texture.equals(texture2)) continue;
            return TextureManager.releaseTexture(textureKey);
        }
        return false;
    }

    public static boolean releaseTexture(TextureKey textureKey) {
        return m_tCache.remove(textureKey) != null;
    }

    public static void clearCache() {
        m_tCache.clear();
    }

    public static void registerHandler(String string, ImageLoader imageLoader) {
        loaders.put(string.toLowerCase(), imageLoader);
    }

    public static void unregisterHandler(String string) {
        loaders.remove(string.toLowerCase());
    }

    public static void registerForCleanup(TextureKey textureKey, int n) {
        Texture texture = m_tCache.get(textureKey);
        if (texture != null) {
            texture.setTextureId(n);
        }
        cleanupStore.add(n);
    }

    public static void doTextureCleanup() {
        if (DisplaySystem.getDisplaySystem() == null || DisplaySystem.getDisplaySystem().getRenderer() == null) {
            return;
        }
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        for (Integer n : cleanupStore) {
            if (n == null) continue;
            try {
                textureState.deleteTextureId(n);
            }
            catch (Exception exception) {}
        }
    }

    public static Texture findCachedTexture(TextureKey textureKey) {
        return m_tCache.get(textureKey);
    }

    public static void preloadCache(Renderer renderer) {
        TextureState textureState = renderer.createTextureState();
        for (Texture texture : m_tCache.values()) {
            if (texture.getTextureKey().m_location == null) continue;
            textureState.setTexture(texture);
            textureState.load(0);
        }
    }
}

