/*
 * Decompiled with CFR 0.152.
 */
package jmetest.unit.com.jme.math;

import com.jme.math.LineSegment;
import com.jme.math.Vector3f;
import org.junit.Assert;
import org.junit.Test;

public class TestLineSegment {
    @Test
    public void testGetPositiveEnd() {
        LineSegment ls = new LineSegment();
        ls.setDirection(new Vector3f(1.0f, 1.0f, 0.0f));
        ls.setOrigin(new Vector3f(0.5f, 1.0f, 9.0f));
        ls.setExtent(4.5f);
        Vector3f store = new Vector3f();
        ls.getPositiveEnd(store);
        Assert.assertTrue((boolean)store.equals(new Vector3f(5.0f, 5.5f, 9.0f)));
    }

    @Test
    public void testGetNegativeEnd() {
        LineSegment ls = new LineSegment();
        ls.setDirection(new Vector3f(1.0f, 1.0f, 0.0f));
        ls.setOrigin(new Vector3f(0.5f, 1.0f, 9.0f));
        ls.setExtent(4.5f);
        Vector3f store = new Vector3f();
        ls.getNegativeEnd(store);
        Assert.assertTrue((boolean)store.equals(new Vector3f(-4.0f, -3.5f, 9.0f)));
    }

    @Test
    public void testDistanceSquaredPoint() {
        LineSegment ls = new LineSegment();
        ls.setDirection(new Vector3f(-1.0f, 0.0f, 1.0f));
        ls.setOrigin(new Vector3f(1.0f, 2.0f, 3.0f));
        ls.setExtent(2.0f);
        Vector3f point = new Vector3f(10.0f, 34.0f, 9.0f);
        float distance = ls.distanceSquared(point);
        Assert.assertTrue((distance == 1137.0f ? 1 : 0) != 0);
    }

    @Test
    public void testDistanceSquaredSegment() {
        LineSegment ls = new LineSegment();
        ls.setDirection(new Vector3f(-1.0f, 0.0f, 1.0f));
        ls.setOrigin(new Vector3f(1.0f, 2.0f, 3.0f));
        ls.setExtent(2.0f);
        LineSegment ls2 = new LineSegment();
        ls2.setDirection(new Vector3f(0.0f, -0.5f, 0.345f));
        ls2.setOrigin(new Vector3f(-100.0f, 0.0f, -1.0f));
        ls2.setExtent(16.0f);
        float distance = ls.distanceSquared(ls2);
        Assert.assertTrue((distance == 9835.855f ? 1 : 0) != 0);
    }
}

