/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class BinaryToXML {
    private DataInputStream myIn;
    private Writer XMLFile;
    private short tabCount;
    private StringBuffer currentLine;
    private static final boolean DEBUG = false;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Correct way to use is: <FormatFile> <XMLoutputout>");
            System.err.println("For example: runner.jme runner.xml");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (!file.canRead()) {
            System.err.println("Cannot read input file " + file);
            return;
        }
        try {
            System.out.println("Converting file " + file + " to " + file2);
            new BinaryToXML().sendBinarytoXML(new FileInputStream(file), new FileWriter(file2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to convert:" + iOException);
            return;
        }
        System.out.println("Conversion complete!");
    }

    public void sendBinarytoXML(InputStream inputStream, Writer writer) throws IOException {
        this.myIn = new DataInputStream(inputStream);
        this.XMLFile = writer;
        this.tabCount = 0;
        this.currentLine = new StringBuffer();
        this.readHeader();
        while (this.readPart()) {
        }
        writer.close();
    }

    private boolean readPart() throws IOException {
        byte by = this.myIn.readByte();
        if (by == 0) {
            String string = this.myIn.readUTF();
            this.currentLine.append('<').append(string).append(' ');
            int n = this.myIn.readByte();
            for (int i = 0; i < n; ++i) {
                String string2 = this.myIn.readUTF();
                this.currentLine.append(string2).append("=\"");
                this.readData();
                this.currentLine.append("\" ");
            }
            this.currentLine.append('>');
            this.writeLine();
            this.tabCount = (short)(this.tabCount + 1);
            return true;
        }
        if (by == 1) {
            this.tabCount = (short)(this.tabCount - 1);
            this.currentLine.append("</").append(this.myIn.readUTF()).append('>');
            this.writeLine();
            return true;
        }
        if (by == 2) {
            return false;
        }
        throw new IOException("Unknown flag read: " + by);
    }

    private void readData() throws IOException {
        byte by = this.myIn.readByte();
        switch (by) {
            case 3: {
                this.currentLine.append(this.myIn.readUTF());
                break;
            }
            case 2: {
                this.readColorArray();
                break;
            }
            case 4: {
                this.readIntArray();
                break;
            }
            case 1: {
                this.readVec2fArray();
                break;
            }
            case 0: {
                this.readVec3fArray();
                break;
            }
            case 7: {
                this.currentLine.append(this.myIn.readFloat());
                break;
            }
            case 6: {
                this.readQuat();
                break;
            }
            case 8: {
                this.readColor();
                break;
            }
            case 9: {
                this.currentLine.append(this.myIn.readUTF());
                break;
            }
            case 5: {
                this.readVec3f();
                break;
            }
            case 10: {
                this.currentLine.append(this.myIn.readInt());
                break;
            }
            case 11: {
                this.currentLine.append(this.myIn.readBoolean());
                break;
            }
            case 12: {
                this.readQuatArray();
                break;
            }
            case 13: {
                this.readByteArray();
                break;
            }
            case 14: {
                this.readShortArray();
                break;
            }
            case 15: {
                this.readVec2f();
                break;
            }
            case 16: {
                this.readMatrix3f();
                break;
            }
            default: {
                throw new IOException("Unknown data type:" + by);
            }
        }
    }

    private void readMatrix3f() throws IOException {
        for (int i = 0; i < 9; ++i) {
            this.currentLine.append(this.myIn.readFloat());
            if (i == 8) continue;
            this.currentLine.append(' ');
        }
    }

    private void readShortArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            this.currentLine.append(this.myIn.readShort());
            if (i == n - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readByteArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            this.currentLine.append(this.myIn.readByte());
            if (i == n - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readQuatArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == n - 1 && j == 3) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readColor() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readQuat() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readVec3f() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat());
    }

    private void readVec2f() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readIntArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            this.currentLine.append(Integer.toString(this.myIn.readInt()));
            if (i == n - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readVec2fArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == n - 1 && j == 1) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readColorArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == n - 1 && j == 3) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readVec3fArray() throws IOException {
        int n = this.myIn.readInt();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == n - 1 && j == 2) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readHeader() throws IOException {
        if (1234567L != this.myIn.readLong()) {
            throw new IOException("Header data doesn't match");
        }
    }

    private void writeLine() throws IOException {
        for (int i = 0; i < this.tabCount; ++i) {
            this.XMLFile.write(9);
        }
        this.currentLine.append('\n');
        this.XMLFile.write(this.currentLine.toString());
        this.currentLine.setLength(0);
    }
}

