/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.Face;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AseToJme
extends FormatConverter {
    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new AseToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Unable to load null streams");
        }
        Node node = new Node("ase model");
        new ASEModelCopy(inputStream, node);
        BinaryExporter.getInstance().save((Savable)node, outputStream);
    }

    private class ASEModelCopy {
        private static final long serialVersionUID = 1L;
        private static final String OBJECT = "*GEOMOBJECT";
        private static final String NUM_VERTEX = "*MESH_NUMVERTEX";
        private static final String NUM_FACES = "*MESH_NUMFACES";
        private static final String NUM_TVERTEX = "*MESH_NUMTVERTEX";
        private static final String VERTEX = "*MESH_VERTEX";
        private static final String FACE = "*MESH_FACE";
        private static final String NORMALS = "*MESH_NORMALS";
        private static final String FACE_NORMAL = "*MESH_FACENORMAL";
        private static final String NVERTEX = "*MESH_VERTEXNORMAL";
        private static final String TVERTEX = "*MESH_TVERT";
        private static final String TFACE = "*MESH_TFACE";
        private static final String TEXTURE = "*BITMAP";
        private static final String UTILE = "*UVW_U_TILING";
        private static final String VTILE = "*UVW_V_TILING";
        private static final String UOFFSET = "*UVW_U_OFFSET";
        private static final String VOFFSET = "*UVW_V_OFFSET";
        private static final String MATERIAL_ID = "*MATERIAL_REF";
        private static final String MATERIAL_COUNT = "*MATERIAL_COUNT";
        private static final String MATERIAL = "*MATERIAL";
        private static final String MATERIAL_NAME = "*MATERIAL_NAME";
        private static final String MATERIAL_DIFFUSE = "*MATERIAL_DIFFUSE";
        private static final String MATERIAL_AMBIENT = "*MATERIAL_AMBIENT";
        private static final String MATERIAL_SPECULAR = "*MATERIAL_SPECULAR";
        private static final String MATERIAL_SHINE = "*MATERIAL_SHINE";
        private String textureDirectory = "";
        private BufferedReader reader = null;
        private StringTokenizer tokenizer;
        private String fileContents;
        private int numOfObjects;
        private int numOfMaterials;
        private ArrayList materials = new ArrayList();
        private ArrayList objectList = new ArrayList();
        Node mynode;

        public ASEModelCopy(String string, Node node) {
            this.mynode = node;
        }

        public ASEModelCopy(InputStream inputStream, Node node) {
            this.mynode = node;
            this.load(inputStream);
        }

        public void load(InputStream inputStream) {
            if (null == inputStream) {
                LoggingSystem.getLogger().log(Level.WARNING, "Null URL could not load ASE.");
                return;
            }
            int n = 0;
            try {
                String string;
                n = inputStream.available();
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = this.reader.readLine()) != null) {
                    stringBuffer.append(string + "\n");
                }
                this.fileContents = stringBuffer.toString();
                this.reader.close();
                this.parseFile();
                this.computeNormals();
                this.convertToTriMesh();
            }
            catch (IOException iOException) {
                LoggingSystem.getLogger().log(Level.WARNING, "Could not load " + inputStream.toString());
            }
        }

        public Controller getAnimationController() {
            return null;
        }

        private void parseFile() {
            int n;
            ASEMaterialInfo aSEMaterialInfo = new ASEMaterialInfo();
            ASEObject aSEObject = new ASEObject("ASEMesh");
            this.numOfObjects = this.getObjectCount();
            this.numOfMaterials = this.getMaterialCount();
            for (n = 0; n < this.numOfMaterials; ++n) {
                this.materials.add(aSEMaterialInfo);
                this.getMaterialInfo((ASEMaterialInfo)this.materials.get(n), n + 1);
            }
            for (n = 0; n < this.numOfObjects; ++n) {
                aSEObject.materialID = -1;
                this.moveToObject(n + 1);
                this.readObjectInfo(aSEObject, n + 1);
                this.readObjectData(aSEObject, n + 1);
                this.objectList.add(aSEObject);
            }
        }

        private void convertToTriMesh() {
            Object object;
            Object object2;
            Object object3;
            int n;
            for (n = 0; n < this.numOfObjects; ++n) {
                int n2;
                object3 = (ASEObject)this.objectList.get(n);
                object2 = new Vector2f[((ASEObject)object3).tm.getVertexCount()];
                for (int i = 0; i < ((ASEObject)object3).faces.length; ++i) {
                    n2 = ((ASEObject)object3).faces[i].vertIndex[0];
                    object2[n2] = new Vector2f();
                    object2[n2] = ((ASEObject)object3).tempTexVerts[((ASEObject)object3).faces[i].coordIndex[0]];
                    n2 = ((ASEObject)object3).faces[i].vertIndex[1];
                    object2[n2] = new Vector2f();
                    object2[n2] = ((ASEObject)object3).tempTexVerts[((ASEObject)object3).faces[i].coordIndex[1]];
                    n2 = ((ASEObject)object3).faces[i].vertIndex[2];
                    object2[n2] = new Vector2f();
                    object2[n2] = ((ASEObject)object3).tempTexVerts[((ASEObject)object3).faces[i].coordIndex[2]];
                }
                object = new int[((ASEObject)object3).faces.length * 3];
                n2 = 0;
                for (int i = 0; i < ((ASEObject)object3).faces.length; ++i) {
                    object[n2] = ((ASEObject)object3).faces[i].vertIndex[0];
                    object[++n2] = ((ASEObject)object3).faces[i].vertIndex[1];
                    object[++n2] = ((ASEObject)object3).faces[i].vertIndex[2];
                    ++n2;
                }
                ((ASEObject)object3).tm.setIndexBuffer(0, BufferUtils.createIntBuffer((int[])object));
                ((ASEObject)object3).tm.setTextureBuffer(0, BufferUtils.createFloatBuffer((Vector2f[])object2));
                ((ASEObject)object3).tm.setModelBound((BoundingVolume)new BoundingBox());
                ((ASEObject)object3).tm.updateModelBound();
                this.mynode.attachChild((Spatial)((ASEObject)object3).tm);
            }
            for (n = 0; n < this.numOfMaterials; ++n) {
                object3 = (ASEMaterialInfo)this.materials.get(n);
                if (((ASEMaterialInfo)object3).file.length() <= 0) continue;
                object2 = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                object2.setEnabled(true);
                object2.setAmbient(new ColorRGBA(((ASEMaterialInfo)object3).ambient[0], ((ASEMaterialInfo)object3).ambient[1], ((ASEMaterialInfo)object3).ambient[2], 1.0f));
                object2.setDiffuse(new ColorRGBA(((ASEMaterialInfo)object3).diffuse[0], ((ASEMaterialInfo)object3).diffuse[1], ((ASEMaterialInfo)object3).diffuse[2], 1.0f));
                object2.setSpecular(new ColorRGBA(((ASEMaterialInfo)object3).specular[0], ((ASEMaterialInfo)object3).specular[1], ((ASEMaterialInfo)object3).specular[2], 1.0f));
                object2.setEmissive(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
                object2.setShininess(((ASEMaterialInfo)object3).shine);
                this.mynode.setRenderState((RenderState)object2);
            }
            for (n = 0; n < this.numOfMaterials; ++n) {
                object3 = null;
                if (((ASEMaterialInfo)this.materials.get((int)n)).file.length() <= 0) continue;
                object2 = ((ASEMaterialInfo)this.materials.get((int)n)).file;
                object3 = ASEModelCopy.class.getClassLoader().getResource((String)object2);
                if (object3 == null) {
                    try {
                        object3 = new URL("file:" + (String)object2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LoggingSystem.getLogger().log(Level.WARNING, "Could not load: " + (String)object2);
                        return;
                    }
                }
                object = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                object.setEnabled(true);
                Texture texture = new Texture();
                texture.setImageLocation("file:/" + (String)object2);
                try {
                    texture.setTextureKey(new TextureKey(new URL("file:/" + (String)object2), 1, 1, 2.0f, true, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2));
                    object.setTexture(texture);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                this.mynode.setRenderState((RenderState)object);
            }
        }

        private int getObjectCount() {
            int n = 0;
            this.tokenizer = new StringTokenizer(this.fileContents);
            while (this.tokenizer.hasMoreTokens()) {
                if (!OBJECT.equals(this.tokenizer.nextToken())) continue;
                ++n;
            }
            return n;
        }

        private int getMaterialCount() {
            int n = 0;
            this.tokenizer = new StringTokenizer(this.fileContents);
            while (this.tokenizer.hasMoreTokens()) {
                if (!MATERIAL_COUNT.equals(this.tokenizer.nextToken())) continue;
                n = Integer.parseInt(this.tokenizer.nextToken());
                return n;
            }
            return 0;
        }

        private void getMaterialInfo(ASEMaterialInfo aSEMaterialInfo, int n) {
            int n2 = 0;
            this.tokenizer = new StringTokenizer(this.fileContents);
            while (this.tokenizer.hasMoreTokens() && (!MATERIAL.equals(this.tokenizer.nextToken()) || ++n2 != n)) {
            }
            while (this.tokenizer.hasMoreTokens()) {
                String string = this.tokenizer.nextToken();
                if (string.equals(MATERIAL)) {
                    return;
                }
                if (string.equals(MATERIAL_AMBIENT)) {
                    aSEMaterialInfo.ambient[0] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.ambient[1] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.ambient[2] = Float.parseFloat(this.tokenizer.nextToken());
                } else if (string.equals(MATERIAL_DIFFUSE)) {
                    aSEMaterialInfo.diffuse[0] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.diffuse[1] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.diffuse[2] = Float.parseFloat(this.tokenizer.nextToken());
                } else if (string.equals(MATERIAL_SPECULAR)) {
                    aSEMaterialInfo.specular[0] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.specular[1] = Float.parseFloat(this.tokenizer.nextToken());
                    aSEMaterialInfo.specular[2] = Float.parseFloat(this.tokenizer.nextToken());
                } else if (string.equals(MATERIAL_SHINE)) {
                    aSEMaterialInfo.shine = Float.parseFloat(this.tokenizer.nextToken());
                }
                if (string.equals(TEXTURE)) {
                    aSEMaterialInfo.file = this.textureDirectory + this.tokenizer.nextToken().replace('\"', ' ').trim();
                    continue;
                }
                if (string.equals(MATERIAL_NAME)) {
                    aSEMaterialInfo.name = this.tokenizer.nextToken();
                    continue;
                }
                if (string.equals(UTILE)) {
                    aSEMaterialInfo.uTile = Float.parseFloat(this.tokenizer.nextToken());
                    continue;
                }
                if (!string.equals(VTILE)) continue;
                aSEMaterialInfo.vTile = Float.parseFloat(this.tokenizer.nextToken());
            }
        }

        private void moveToObject(int n) {
            int n2 = 0;
            this.tokenizer = new StringTokenizer(this.fileContents);
            while (this.tokenizer.hasMoreTokens()) {
                if (!OBJECT.equals(this.tokenizer.nextToken()) || ++n2 != n) continue;
                return;
            }
        }

        private void readObjectInfo(ASEObject aSEObject, int n) {
            this.moveToObject(n);
            while (this.tokenizer.hasMoreTokens()) {
                int n2;
                String string = this.tokenizer.nextToken();
                if (string.equals("*NODE_NAME")) {
                    aSEObject.tm.setName(this.tokenizer.nextToken());
                }
                if (string.equals(NUM_VERTEX)) {
                    n2 = Integer.parseInt(this.tokenizer.nextToken());
                    aSEObject.tm.setVertexBuffer(0, BufferUtils.createVector3Buffer((int)n2));
                    continue;
                }
                if (string.equals(NUM_FACES)) {
                    n2 = Integer.parseInt(this.tokenizer.nextToken());
                    aSEObject.faces = new Face[n2];
                    continue;
                }
                if (string.equals(NUM_TVERTEX)) {
                    n2 = Integer.parseInt(this.tokenizer.nextToken());
                    aSEObject.tempTexVerts = new Vector2f[n2];
                    continue;
                }
                if (!string.equals(OBJECT)) continue;
                return;
            }
        }

        private void readObjectData(ASEObject aSEObject, int n) {
            this.getData(aSEObject, MATERIAL_ID, n);
            this.getData(aSEObject, VERTEX, n);
            this.getData(aSEObject, TVERTEX, n);
            this.getData(aSEObject, FACE, n);
            this.getData(aSEObject, TFACE, n);
            this.getData(aSEObject, TEXTURE, n);
            this.getData(aSEObject, UTILE, n);
            this.getData(aSEObject, VTILE, n);
        }

        private void getData(ASEObject aSEObject, String string, int n) {
            this.moveToObject(n);
            while (this.tokenizer.hasMoreTokens()) {
                String string2 = this.tokenizer.nextToken();
                if (string2.equals(OBJECT)) {
                    return;
                }
                if (string2.equals(VERTEX)) {
                    if (!string.equals(VERTEX)) continue;
                    this.readVertex(aSEObject);
                    continue;
                }
                if (string2.equals(TVERTEX)) {
                    if (!string.equals(TVERTEX)) continue;
                    this.readTextureVertex(aSEObject, (ASEMaterialInfo)this.materials.get(aSEObject.materialID));
                    continue;
                }
                if (string2.equals(FACE)) {
                    if (!string.equals(FACE)) continue;
                    this.readFace(aSEObject);
                    continue;
                }
                if (string2.equals(TFACE)) {
                    if (!string.equals(TFACE)) continue;
                    this.readTextureFace(aSEObject);
                    continue;
                }
                if (!string2.equals(MATERIAL_ID) || !string.equals(MATERIAL_ID)) continue;
                aSEObject.materialID = (int)Float.parseFloat(this.tokenizer.nextToken());
                return;
            }
        }

        private void readVertex(ASEObject aSEObject) {
            int n = 0;
            n = Integer.parseInt(this.tokenizer.nextToken());
            float f = Float.parseFloat(this.tokenizer.nextToken());
            float f2 = -Float.parseFloat(this.tokenizer.nextToken());
            float f3 = Float.parseFloat(this.tokenizer.nextToken());
            aSEObject.tm.getVertexBuffer(0).position(n * 3);
            aSEObject.tm.getVertexBuffer(0).put(f).put(f3).put(f2);
        }

        private void readTextureVertex(ASEObject aSEObject, ASEMaterialInfo aSEMaterialInfo) {
            int n = 0;
            n = Integer.parseInt(this.tokenizer.nextToken());
            aSEObject.tempTexVerts[n] = new Vector2f();
            aSEObject.tempTexVerts[n].x = Float.parseFloat(this.tokenizer.nextToken());
            aSEObject.tempTexVerts[n].y = Float.parseFloat(this.tokenizer.nextToken());
            aSEObject.tempTexVerts[n].x *= aSEMaterialInfo.uTile;
            aSEObject.tempTexVerts[n].y *= aSEMaterialInfo.vTile;
        }

        private void readFace(ASEObject aSEObject) {
            int n = 0;
            String string = this.tokenizer.nextToken();
            if (string.indexOf(":") > 0) {
                string = string.substring(0, string.length() - 1);
            }
            n = Integer.parseInt(string);
            aSEObject.faces[n] = new Face();
            this.tokenizer.nextToken();
            aSEObject.faces[n].vertIndex[0] = Integer.parseInt(this.tokenizer.nextToken());
            this.tokenizer.nextToken();
            aSEObject.faces[n].vertIndex[1] = Integer.parseInt(this.tokenizer.nextToken());
            this.tokenizer.nextToken();
            aSEObject.faces[n].vertIndex[2] = Integer.parseInt(this.tokenizer.nextToken());
        }

        private void readTextureFace(ASEObject aSEObject) {
            int n = 0;
            n = Integer.parseInt(this.tokenizer.nextToken());
            aSEObject.faces[n].coordIndex[0] = Integer.parseInt(this.tokenizer.nextToken());
            aSEObject.faces[n].coordIndex[1] = Integer.parseInt(this.tokenizer.nextToken());
            aSEObject.faces[n].coordIndex[2] = Integer.parseInt(this.tokenizer.nextToken());
        }

        private void computeNormals() {
            if (this.numOfObjects <= 0) {
                return;
            }
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            Vector3f vector3f3 = new Vector3f();
            for (int i = 0; i < this.numOfObjects; ++i) {
                ASEObject aSEObject = (ASEObject)this.objectList.get(i);
                Vector3f[] vector3fArray = new Vector3f[aSEObject.faces.length];
                Vector3f[] vector3fArray2 = new Vector3f[aSEObject.tm.getVertexCount()];
                for (int j = 0; j < aSEObject.faces.length; ++j) {
                    BufferUtils.populateFromBuffer((Vector3f)vector3f, (FloatBuffer)aSEObject.tm.getVertexBuffer(0), (int)aSEObject.faces[j].vertIndex[0]);
                    BufferUtils.populateFromBuffer((Vector3f)vector3f2, (FloatBuffer)aSEObject.tm.getVertexBuffer(0), (int)aSEObject.faces[j].vertIndex[1]);
                    BufferUtils.populateFromBuffer((Vector3f)vector3f3, (FloatBuffer)aSEObject.tm.getVertexBuffer(0), (int)aSEObject.faces[j].vertIndex[2]);
                    vector3f.subtractLocal(vector3f3);
                    vector3fArray[j] = vector3f.cross(vector3f3.subtract(vector3f2)).normalizeLocal();
                }
                Vector3f vector3f4 = new Vector3f();
                int n = 0;
                for (int j = 0; j < aSEObject.tm.getVertexCount(); ++j) {
                    for (int k = 0; k < aSEObject.faces.length; ++k) {
                        if (aSEObject.faces[k].vertIndex[0] != j && aSEObject.faces[k].vertIndex[1] != j && aSEObject.faces[k].vertIndex[2] != j) continue;
                        vector3f4.addLocal(vector3fArray[k]);
                        ++n;
                    }
                    vector3fArray2[j] = vector3f4.divide((float)(-n)).normalizeLocal();
                    vector3f4.zero();
                    n = 0;
                }
                aSEObject.tm.setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vector3fArray2));
            }
        }

        public class ASEObject {
            private static final long serialVersionUID = 1L;
            public int materialID;
            public Vector2f[] tempTexVerts;
            public Face[] faces;
            public TriMesh tm;

            public ASEObject(String string) {
                this.tm = new TriMesh(string);
            }
        }

        private class ASEMaterialInfo {
            String name;
            public String file;
            public float[] diffuse = new float[3];
            public float[] ambient = new float[3];
            public float[] specular = new float[3];
            public float shine;
            float uTile;
            float vTile;
            float uOffset;
            float vOffset;

            private ASEMaterialInfo() {
            }
        }
    }
}

