/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters;

import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.BinaryFileReader;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import com.jmex.model.animation.KeyframeController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Md3ToJme
extends FormatConverter {
    private BinaryFileReader file;
    private MD3Header head;
    private MD3Frame[] frames;
    private MD3Tag[][] tags;
    private MD3Surface[] surfaces;
    private KeyframeController vkc;

    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new Md3ToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.file = new BinaryFileReader(inputStream);
        this.readHeader();
        this.readFrames();
        this.readTags();
        this.readSurfaces();
        BinaryExporter.getInstance().save((Savable)this.constructMesh(), outputStream);
    }

    private Node constructMesh() {
        Node node = new Node("MD3 File");
        for (int i = 0; i < this.head.numSurface; ++i) {
            this.vkc = new KeyframeController();
            MD3Surface mD3Surface = this.surfaces[i];
            TriMesh triMesh = new TriMesh(mD3Surface.name);
            triMesh.setIndexBuffer(0, BufferUtils.createIntBuffer((int[])mD3Surface.triIndexes));
            triMesh.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])mD3Surface.verts[0]));
            triMesh.setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])mD3Surface.norms[0]));
            triMesh.setTextureBuffer(0, BufferUtils.createFloatBuffer((Vector2f[])mD3Surface.texCoords));
            node.attachChild((Spatial)triMesh);
            this.vkc.setMorphingMesh(triMesh);
            for (int j = 0; j < this.head.numFrames; ++j) {
                TriMesh triMesh2 = new TriMesh();
                triMesh2.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])mD3Surface.verts[j]));
                triMesh2.setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])mD3Surface.norms[j]));
                this.vkc.setKeyframe(j, triMesh2);
            }
            this.vkc.setActive(true);
            this.vkc.setSpeed(5.0f);
            triMesh.addController((Controller)this.vkc);
            node.addController((Controller)this.vkc);
        }
        this.nullAll();
        return node;
    }

    public KeyframeController getController() {
        return this.vkc;
    }

    private void nullAll() {
        this.frames = null;
        this.tags = null;
        this.surfaces = null;
        this.head = null;
        this.file = null;
    }

    public static KeyframeController findController(Node node) {
        if (node.getQuantity() == 0 || node.getChild(0).getControllers().size() == 0 || !(node.getChild(0).getController(0) instanceof KeyframeController)) {
            return null;
        }
        return (KeyframeController)node.getChild(0).getController(0);
    }

    private void readSurfaces() throws IOException {
        this.file.setOffset(this.head.surfaceOffset);
        this.surfaces = new MD3Surface[this.head.numSurface];
        for (int i = 0; i < this.head.numSurface; ++i) {
            this.surfaces[i] = new MD3Surface();
            this.surfaces[i].readMe();
        }
    }

    private void readTags() {
        this.file.setOffset(this.head.tagOffset);
        this.tags = new MD3Tag[this.head.numFrames][];
        for (int i = 0; i < this.head.numFrames; ++i) {
            this.tags[i] = new MD3Tag[this.head.numTags];
            for (int j = 0; j < this.head.numTags; ++j) {
                this.tags[i][j] = new MD3Tag();
                this.tags[i][j].readMe();
            }
        }
    }

    private void readFrames() {
        this.file.setOffset(this.head.frameOffset);
        this.frames = new MD3Frame[this.head.numFrames];
        for (int i = 0; i < this.head.numFrames; ++i) {
            this.frames[i] = new MD3Frame();
            this.frames[i].readMe();
        }
    }

    private void readHeader() throws IOException {
        this.head = new MD3Header();
        this.head.readMe();
    }

    void readVecFloat(Vector3f vector3f) {
        vector3f.z = this.file.readFloat();
        vector3f.x = this.file.readFloat();
        vector3f.y = this.file.readFloat();
    }

    private class MD3Surface {
        String name;
        int flags;
        int numFrames;
        int numShaders;
        int numVerts;
        int numTriangles;
        int offTriangles;
        int offShaders;
        int offTexCoord;
        int offXyzNor;
        int offEnd;
        int[] triIndexes;
        Vector2f[] texCoords;
        Vector3f[][] verts;
        Vector3f[][] norms;
        private static final float XYZ_SCALE = 0.015625f;
        private static final boolean DEBUG = false;

        private MD3Surface() {
        }

        public void readMe() throws IOException {
            Md3ToJme.this.file.markPos();
            int n = Md3ToJme.this.file.readInt();
            if (n != 860898377) {
                throw new IOException("Unknown file format:" + n);
            }
            this.name = Md3ToJme.this.file.readString(64);
            this.flags = Md3ToJme.this.file.readInt();
            this.numFrames = Md3ToJme.this.file.readInt();
            this.numShaders = Md3ToJme.this.file.readInt();
            this.numVerts = Md3ToJme.this.file.readInt();
            this.numTriangles = Md3ToJme.this.file.readInt();
            this.offTriangles = Md3ToJme.this.file.readInt();
            this.offShaders = Md3ToJme.this.file.readInt();
            this.offTexCoord = Md3ToJme.this.file.readInt();
            this.offXyzNor = Md3ToJme.this.file.readInt();
            this.offEnd = Md3ToJme.this.file.readInt();
            this.readTriangles();
            this.readTexCoord();
            this.readVerts();
        }

        private void readVerts() {
            Md3ToJme.this.file.seekMarkOffset(this.offXyzNor);
            this.verts = new Vector3f[((Md3ToJme)Md3ToJme.this).head.numFrames][];
            this.norms = new Vector3f[((Md3ToJme)Md3ToJme.this).head.numFrames][];
            for (int i = 0; i < ((Md3ToJme)Md3ToJme.this).head.numFrames; ++i) {
                this.verts[i] = new Vector3f[this.numVerts];
                this.norms[i] = new Vector3f[this.numVerts];
                for (int j = 0; j < this.numVerts; ++j) {
                    this.verts[i][j] = new Vector3f();
                    this.norms[i][j] = new Vector3f();
                    this.readVecShort(this.verts[i][j]);
                    this.readNormal(this.norms[i][j]);
                }
            }
        }

        private void readVecShort(Vector3f vector3f) {
            vector3f.z = (float)Md3ToJme.this.file.readSignedShort() * 0.015625f;
            vector3f.x = (float)Md3ToJme.this.file.readSignedShort() * 0.015625f;
            vector3f.y = (float)Md3ToJme.this.file.readSignedShort() * 0.015625f;
        }

        private void readNormal(Vector3f vector3f) {
            int n = Md3ToJme.this.file.readByte();
            int n2 = Md3ToJme.this.file.readByte();
            float f = (float)(n2 * 2) * (float)Math.PI / 255.0f;
            float f2 = (float)(n * 2) * (float)Math.PI / 255.0f;
            vector3f.x = FastMath.cos((float)f) * FastMath.sin((float)f2);
            vector3f.y = FastMath.sin((float)f) * FastMath.sin((float)f2);
            vector3f.z = FastMath.cos((float)f2);
        }

        private void readTexCoord() {
            Md3ToJme.this.file.seekMarkOffset(this.offTexCoord);
            this.texCoords = new Vector2f[this.numVerts];
            for (int i = 0; i < this.texCoords.length; ++i) {
                this.texCoords[i] = new Vector2f();
                this.texCoords[i].x = Md3ToJme.this.file.readFloat();
                this.texCoords[i].y = 1.0f - Md3ToJme.this.file.readFloat();
            }
        }

        private void readTriangles() {
            Md3ToJme.this.file.seekMarkOffset(this.offTriangles);
            this.triIndexes = new int[this.numTriangles * 3];
            for (int i = 0; i < this.triIndexes.length; ++i) {
                this.triIndexes[i] = Md3ToJme.this.file.readInt();
            }
        }

        private void readShader() {
            Md3ToJme.this.file.seekMarkOffset(this.offShaders);
            for (int i = 0; i < this.numShaders; ++i) {
                String string = Md3ToJme.this.file.readString(64);
                int n = Md3ToJme.this.file.readInt();
            }
        }
    }

    private class MD3Tag {
        String path;
        Vector3f origin = new Vector3f();
        Matrix3f axis;

        private MD3Tag() {
        }

        void readMe() {
            this.path = Md3ToJme.this.file.readString(64);
            Md3ToJme.this.readVecFloat(this.origin);
            float[] fArray = new float[9];
            for (int i = 0; i < 9; ++i) {
                fArray[i] = Md3ToJme.this.file.readFloat();
            }
            this.axis = new Matrix3f();
            this.axis.set(fArray);
        }
    }

    private class MD3Frame {
        Vector3f minBounds = new Vector3f();
        Vector3f maxBounds = new Vector3f();
        Vector3f localOrigin = new Vector3f();
        float scale;
        String name;

        private MD3Frame() {
        }

        void readMe() {
            Md3ToJme.this.readVecFloat(this.minBounds);
            Md3ToJme.this.readVecFloat(this.maxBounds);
            Md3ToJme.this.readVecFloat(this.localOrigin);
            this.scale = Md3ToJme.this.file.readFloat();
            this.name = Md3ToJme.this.file.readString(16);
        }
    }

    private class MD3Header {
        int version;
        String name;
        int flags;
        int numFrames;
        int numTags;
        int numSurface;
        int numSkins;
        int frameOffset;
        int tagOffset;
        int surfaceOffset;
        int fileOffset;

        private MD3Header() {
        }

        void readMe() throws IOException {
            int n = Md3ToJme.this.file.readInt();
            if (n != 860898377) {
                throw new IOException("Unknown file format:" + n);
            }
            this.version = Md3ToJme.this.file.readInt();
            if (this.version != 15) {
                throw new IOException("Unsupported version " + this.version + ", only know ver 15");
            }
            this.name = Md3ToJme.this.file.readString(64);
            this.flags = Md3ToJme.this.file.readInt();
            this.numFrames = Md3ToJme.this.file.readInt();
            this.numTags = Md3ToJme.this.file.readInt();
            this.numSurface = Md3ToJme.this.file.readInt();
            this.numSkins = Md3ToJme.this.file.readInt();
            this.frameOffset = Md3ToJme.this.file.readInt();
            this.tagOffset = Md3ToJme.this.file.readInt();
            this.surfaceOffset = Md3ToJme.this.file.readInt();
            this.fileOffset = Md3ToJme.this.file.readInt();
        }
    }
}

